/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2006, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.test.jbossmx.compliance.registration;

import java.io.IOException;

import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanRegistrationException;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.management.ReflectionException;

import junit.framework.Test;

import org.jboss.test.jbossmx.compliance.TestCase;
import org.jboss.test.jbossmx.compliance.registration.mxbean.InvalidImpl1;
import org.jboss.test.jbossmx.compliance.registration.mxbean.InvalidImpl2;
import org.jboss.test.jbossmx.compliance.registration.mxbean.InvalidImpl3;
import org.jboss.test.jbossmx.compliance.registration.mxbean.InvalidImpl4;
import org.jboss.test.jbossmx.compliance.registration.mxbean.InvalidImplSub1;
import org.jboss.test.jbossmx.compliance.registration.mxbean.InvalidImplSub2;
import org.jboss.test.jbossmx.compliance.registration.mxbean.InvalidImplSub3;
import org.jboss.test.jbossmx.compliance.registration.mxbean.ValidImpl1;
import org.jboss.test.jbossmx.compliance.registration.mxbean.ValidImpl2;
import org.jboss.test.jbossmx.compliance.registration.mxbean.ValidImpl3;
import org.jboss.test.jbossmx.compliance.registration.mxbean.ValidImplDeepSub;
import org.jboss.test.jbossmx.compliance.registration.mxbean.ValidImplSub1;
import org.jboss.test.jbossmx.compliance.registration.mxbean.ValidImplSub2;
import org.jboss.test.jbossmx.compliance.registration.mxbean.ValidImplSub3;
/** 
 * @author baranowb
 */
public class MXBeanRegistrationTestCase 
extends TestCase
{


    /**
     * Setup the test suite.
     */
    public static Test suite()
            throws Exception
         {
            return getDeploySetup(MXBeanRegistrationTestCase.class, "mxbean-compliance.sar");
         }

    private ObjectName name;

    // Constructor ---------------------------------------------------------------

    public MXBeanRegistrationTestCase(String s) {
        super(s);
    }

    // Tests ---------------------------------------------------------------------

    public void testInvalidImpl() {

        setup();
        try {
            register(InvalidImpl1.class.getName());
            clear();
            fail();
        } catch (NotCompliantMBeanException e) {
            //e.printStackTrace();
        } catch (InstanceAlreadyExistsException e) {
            e.printStackTrace();
            fail(2+e.getMessage());
        } catch (MBeanRegistrationException e) {
            e.printStackTrace();
            fail(3+e.getMessage());
        } catch (InstanceNotFoundException e) {
            e.printStackTrace();
            fail(4+e.getMessage());
        } catch (MBeanException e) {
            e.printStackTrace();
            fail(5+e.getMessage());
        } catch (ReflectionException e) {
            e.printStackTrace();
            fail(6+e.getMessage());
        } catch (IOException e) {
            e.printStackTrace();
            fail(7+e.getMessage());
        } catch (Exception e) {
            e.printStackTrace();
            fail(8+e.getMessage());
        }
    }

    public void testInvalidImpl2() {

        setup();
        try {
            register(InvalidImpl2.class.getName());
            clear();
            fail();
        } catch (NotCompliantMBeanException e) {
            //e.printStackTrace();
        } catch (InstanceAlreadyExistsException e) {
            e.printStackTrace();
            fail(e.getMessage());
        } catch (MBeanRegistrationException e) {
            e.printStackTrace();
            fail(e.getMessage());
        } catch (InstanceNotFoundException e) {
            e.printStackTrace();
            fail(e.getMessage());
        } catch (MBeanException e) {
            e.printStackTrace();
            fail(e.getMessage());
        } catch (ReflectionException e) {
            e.printStackTrace();
            fail(e.getMessage());
        } catch (IOException e) {
            e.printStackTrace();
            fail(e.getMessage());
        } catch (Exception e) {
            e.printStackTrace();
            fail(e.getMessage());
        }
    }

    public void testInvalidImpl3() {

        setup();
        try {
            register(InvalidImpl3.class.getName());
            clear();
            fail();
        } catch (NotCompliantMBeanException e) {
            //e.printStackTrace();
        } catch (InstanceAlreadyExistsException e) {
            e.printStackTrace();
            fail(e.getMessage());
        } catch (MBeanRegistrationException e) {
            e.printStackTrace();
            fail(e.getMessage());
        } catch (InstanceNotFoundException e) {
            e.printStackTrace();
            fail(e.getMessage());
        } catch (MBeanException e) {
            e.printStackTrace();
            fail(e.getMessage());
        } catch (ReflectionException e) {
            e.printStackTrace();
            fail(e.getMessage());
        } catch (IOException e) {
            e.printStackTrace();
            fail(e.getMessage());
        } catch (Exception e) {
            e.printStackTrace();
            fail(e.getMessage());
        }
    }

    public void testInvalidImpl4() {

        setup();
        try {
            register(InvalidImpl4.class.getName());
            clear();
            fail();
        } catch (NotCompliantMBeanException e) {
           // e.printStackTrace();
        } catch (InstanceAlreadyExistsException e) {
            e.printStackTrace();
            fail(e.getMessage());
        } catch (MBeanRegistrationException e) {
            e.printStackTrace();
            fail(e.getMessage());
        } catch (InstanceNotFoundException e) {
            e.printStackTrace();
            fail(e.getMessage());
        } catch (MBeanException e) {
            e.printStackTrace();
            fail(e.getMessage());
        } catch (ReflectionException e) {
            e.printStackTrace();
            fail(e.getMessage());
        } catch (IOException e) {
            e.printStackTrace();
            fail(e.getMessage());
        } catch (Exception e) {
            e.printStackTrace();
            fail(e.getMessage());
        }
    }
    
    public void testInvalidImplSub1() {

        setup();
        try {
            register(InvalidImplSub1.class.getName());
            clear();
            fail();
        } catch (NotCompliantMBeanException e) {
            //e.printStackTrace();
        } catch (InstanceAlreadyExistsException e) {
            e.printStackTrace();
            fail(e.getMessage());
        } catch (MBeanRegistrationException e) {
            e.printStackTrace();
            fail(e.getMessage());
        } catch (InstanceNotFoundException e) {
            e.printStackTrace();
            fail(e.getMessage());
        } catch (MBeanException e) {
            e.printStackTrace();
            fail(e.getMessage());
        } catch (ReflectionException e) {
            e.printStackTrace();
            fail(e.getMessage());
        } catch (IOException e) {
            e.printStackTrace();
            fail(e.getMessage());
        } catch (Exception e) {
            e.printStackTrace();
            fail(e.getMessage());
        }
    }
    
    public void testInvalidImplSub2() {

        setup();
        try {
            register(InvalidImplSub2.class.getName());
            clear();
            fail();
        } catch (NotCompliantMBeanException e) {
            //e.printStackTrace();
        } catch (InstanceAlreadyExistsException e) {
            e.printStackTrace();
            fail(e.getMessage());
        } catch (MBeanRegistrationException e) {
            e.printStackTrace();
            fail(e.getMessage());
        } catch (InstanceNotFoundException e) {
            e.printStackTrace();
            fail(e.getMessage());
        } catch (MBeanException e) {
            e.printStackTrace();
            fail(e.getMessage());
        } catch (ReflectionException e) {
            e.printStackTrace();
            fail(e.getMessage());
        } catch (IOException e) {
            e.printStackTrace();
            fail(e.getMessage());
        } catch (Exception e) {
            e.printStackTrace();
            fail(e.getMessage());
        }
    }
    
    public void testInvalidImplSub3() {

        setup();
        try {
            register(InvalidImplSub3.class.getName());
            clear();
            fail();
        } catch (NotCompliantMBeanException e) {
           // e.printStackTrace();
        } catch (InstanceAlreadyExistsException e) {
            e.printStackTrace();
            fail(e.getMessage());
        } catch (MBeanRegistrationException e) {
            e.printStackTrace();
            fail(e.getMessage());
        } catch (InstanceNotFoundException e) {
            e.printStackTrace();
            fail(e.getMessage());
        } catch (MBeanException e) {
            e.printStackTrace();
            fail(e.getMessage());
        } catch (ReflectionException e) {
            e.printStackTrace();
            fail(e.getMessage());
        } catch (IOException e) {
            e.printStackTrace();
            fail(e.getMessage());
        } catch (Exception e) {
            e.printStackTrace();
            fail(e.getMessage());
        }
    }
    // tests which must pass ------------------------

    public void testValidImpl1() {

        setup();
        try {
            register(ValidImpl1.class.getName());
            clear();
        } catch (NotCompliantMBeanException e) {
            e.printStackTrace();
            fail(e.getMessage());
        } catch (InstanceAlreadyExistsException e) {
            e.printStackTrace();
            fail(e.getMessage());
        } catch (MBeanRegistrationException e) {
            e.printStackTrace();
            fail(e.getMessage());
        } catch (InstanceNotFoundException e) {
            e.printStackTrace();
            fail(e.getMessage());
        } catch (MBeanException e) {
            e.printStackTrace();
            fail(e.getMessage());
        } catch (ReflectionException e) {
            e.printStackTrace();
            fail(e.getMessage());
        } catch (IOException e) {
            e.printStackTrace();
            fail(e.getMessage());
        } catch (Exception e) {
            e.printStackTrace();
            fail(e.getMessage());
        }
    }
    
    public void testValidImpl2() {

        setup();
        try {
            register(ValidImpl2.class.getName());
            clear();
        } catch (NotCompliantMBeanException e) {
            e.printStackTrace();
            fail(e.getMessage());
        } catch (InstanceAlreadyExistsException e) {
            e.printStackTrace();
            fail(e.getMessage());
        } catch (MBeanRegistrationException e) {
            e.printStackTrace();
            fail(e.getMessage());
        } catch (InstanceNotFoundException e) {
            e.printStackTrace();
            fail(e.getMessage());
        } catch (MBeanException e) {
            e.printStackTrace();
            fail(e.getMessage());
        } catch (ReflectionException e) {
            e.printStackTrace();
            fail(e.getMessage());
        } catch (IOException e) {
            e.printStackTrace();
            fail(e.getMessage());
        } catch (Exception e) {
            e.printStackTrace();
            fail(e.getMessage());
        }
    }
    
    public void testValidImpl3() {

        setup();
        try {
            register(ValidImpl3.class.getName());
            clear();
        } catch (NotCompliantMBeanException e) {
            e.printStackTrace();
            fail(e.getMessage());
        } catch (InstanceAlreadyExistsException e) {
            e.printStackTrace();
            fail(e.getMessage());
        } catch (MBeanRegistrationException e) {
            e.printStackTrace();
            fail(e.getMessage());
        } catch (InstanceNotFoundException e) {
            e.printStackTrace();
            fail(e.getMessage());
        } catch (MBeanException e) {
            e.printStackTrace();
            fail(e.getMessage());
        } catch (ReflectionException e) {
            e.printStackTrace();
            fail(e.getMessage());
        } catch (IOException e) {
            e.printStackTrace();
            fail(e.getMessage());
        } catch (Exception e) {
            e.printStackTrace();
            fail(e.getMessage());
        }
    }
    
    public void testValidImplSub1() {

        setup();
        try {
            register(ValidImplSub1.class.getName());
            clear();
        } catch (NotCompliantMBeanException e) {
            e.printStackTrace();
            fail(e.getMessage());
        } catch (InstanceAlreadyExistsException e) {
            e.printStackTrace();
            fail(e.getMessage());
        } catch (MBeanRegistrationException e) {
            e.printStackTrace();
            fail(e.getMessage());
        } catch (InstanceNotFoundException e) {
            e.printStackTrace();
            fail(e.getMessage());
        } catch (MBeanException e) {
            e.printStackTrace();
            fail(e.getMessage());
        } catch (ReflectionException e) {
            e.printStackTrace();
            fail(e.getMessage());
        } catch (IOException e) {
            e.printStackTrace();
            fail(e.getMessage());
        } catch (Exception e) {
            e.printStackTrace();
            fail(e.getMessage());
        }
    }
    
    public void testValidImplSub2() {

        setup();
        try {
            register(ValidImplSub2.class.getName());
            clear();
        } catch (NotCompliantMBeanException e) {
            e.printStackTrace();
            fail(e.getMessage());
        } catch (InstanceAlreadyExistsException e) {
            e.printStackTrace();
            fail(e.getMessage());
        } catch (MBeanRegistrationException e) {
            e.printStackTrace();
            fail(e.getMessage());
        } catch (InstanceNotFoundException e) {
            e.printStackTrace();
            fail(e.getMessage());
        } catch (MBeanException e) {
            e.printStackTrace();
            fail(e.getMessage());
        } catch (ReflectionException e) {
            e.printStackTrace();
            fail(e.getMessage());
        } catch (IOException e) {
            e.printStackTrace();
            fail(e.getMessage());
        } catch (Exception e) {
            e.printStackTrace();
            fail(e.getMessage());
        }
    }
    
    public void testValidImplSub3() {

        setup();
        try {
            register(ValidImplSub3.class.getName());
            clear();
        } catch (NotCompliantMBeanException e) {
            e.printStackTrace();
            fail(e.getMessage());
        } catch (InstanceAlreadyExistsException e) {
            e.printStackTrace();
            fail(e.getMessage());
        } catch (MBeanRegistrationException e) {
            e.printStackTrace();
            fail(e.getMessage());
        } catch (InstanceNotFoundException e) {
            e.printStackTrace();
            fail(e.getMessage());
        } catch (MBeanException e) {
            e.printStackTrace();
            fail(e.getMessage());
        } catch (ReflectionException e) {
            e.printStackTrace();
            fail(e.getMessage());
        } catch (IOException e) {
            e.printStackTrace();
            fail(e.getMessage());
        } catch (Exception e) {
            e.printStackTrace();
            fail(e.getMessage());
        }
    }
    
    public void testValidImplDeepSub() {

        setup();
        try {
            register(ValidImplDeepSub.class.getName());
            clear();
            
        } catch (NotCompliantMBeanException e) {
            e.printStackTrace();
            fail(e.getMessage());
        } catch (InstanceAlreadyExistsException e) {
            e.printStackTrace();
            fail(e.getMessage());
        } catch (MBeanRegistrationException e) {
            e.printStackTrace();
            fail(e.getMessage());
        } catch (InstanceNotFoundException e) {
            e.printStackTrace();
            fail(e.getMessage());
        } catch (MBeanException e) {
            e.printStackTrace();
            fail(e.getMessage());
        } catch (ReflectionException e) {
            e.printStackTrace();
            fail(e.getMessage());
        } catch (IOException e) {
            e.printStackTrace();
            fail(e.getMessage());
        } catch (Exception e) {
            e.printStackTrace();
            fail(e.getMessage());
        }
    }
    // Helper methods
    private void setup() {
        if (this.name == null) {
            try {
                this.name = new ObjectName("jboss.mx:type=MXBean");
            } catch (MalformedObjectNameException e) {
                // TODO Auto-generated catch block
                e.printStackTrace();
            }
        }
    }

    private void register(String className) throws InstanceNotFoundException, MBeanException, ReflectionException, IOException, Exception {
        
        getServer().createMBean(className, this.name);
    }
    
    private void clear(){
        try{
        
            getServer().unregisterMBean(this.name);
        }catch(Exception e){
            
        }
    }
}
