/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2008, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.test;

import org.jboss.test.jms.JMSTestAdmin;
import org.jboss.test.jms.TestRole;
import org.jboss.util.NestedRuntimeException;

/**
 * A Base class with abstraction on creating and deleting JMS destinations.
 */
public class JBossJMSTestCase extends JBossTestCase
{
   /** JBM provider properties resource name */
   
	
	/**
    * Constructor for JMSTestCase object
    * 
    * @param name
    *           test case name
    */
   public JBossJMSTestCase(String name)
   {
      super(name);
   }
   
   
   protected static void deployTopic(String name, TestRole ... securityConfig) throws Exception
   {
      JMSTestAdmin.getAdmin().createTopic(name, securityConfig);
   }

   protected static void deployQueue(String name, TestRole ... securityConfig) throws Exception
   {
      JMSTestAdmin.getAdmin().createQueue(name, securityConfig);
   }

   /**
    * Create the Admin object to perform all JMS adminsitrative functions in a
    * JMS provider-independent manner
    */
   protected void setUp() throws Exception
   {
      // perform any setUp required in the superclass
      super.setUp();
   }
   
   protected void tearDown() throws Exception
   {
      super.tearDown();
   }
   
   protected static void undeployDestinations() throws Exception
   {
      JMSTestAdmin.getAdmin().destroyCreatedDestinations();
   }


   protected static void undeployQueue(String queue) throws Exception
   {
      JMSTestAdmin.getAdmin().deleteQueue(queue);
   }


   protected static void undeployTopic(String topic) throws Exception
   {
      JMSTestAdmin.getAdmin().deleteTopic(topic);
   }
   

   /**
    * Create a JMS Queue.
    * 
    * The Queue is created dynamically, in a JMS provider-specific manner,
    * according to the instance of the Admin interface currently in use.
    * 
    * @param name
    *           The name of the Queue to be created.
    */
   public void createQueue(String name) throws Exception
   {
      deployQueue(name, new TestRole("guest", true, true, true));
   }

   /**
    * Delete a JMS Queue.
    * 
    * The Queue is deleted dynamically, in a JMS provider-specific manner,
    * according to the instance of the Admin interface currently in use.
    * 
    * @param name
    *           The name of the Queue to be deleted.
    */
   public void deleteQueue(String name)
   {
      try
      {
         undeployQueue(name);
      }
      catch (Exception e)
      {
         throw new NestedRuntimeException("deleteQueue() operation failed", e);
      }
   }

   /**
    * Create a JMS Topic.
    * 
    * The Topic is created dynamically, in a JMS provider-specific manner,
    * according to the instance of the Admin interface currently in use.
    * 
    * @param name
    *           The name of the Topic to be created.
    */
   public void createTopic(String name) throws Exception
   {
      deployTopic(name);
   }

   /**
    * Delete a JMS Topic.
    * 
    * The Topic is deleted dynamically, in a JMS provider-specific manner,
    * according to the instance of the Admin interface currently in use.
    * 
    * @param name
    *           The name of the Topic to be deleted.
    */
   public void deleteTopic(String name) throws Exception
   {
      undeployTopic(name);
   }

}
