/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.cache.simple;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import javax.ejb.EJBException;
import javax.ejb.NoSuchEJBException;
import org.jboss.aop.Advisor;
import org.jboss.ejb3.EJBContainer;
import org.jboss.ejb3.annotation.CacheConfig;
import org.jboss.ejb3.annotation.PersistenceManager;
import org.jboss.ejb3.cache.StatefulCache;
import org.jboss.ejb3.cache.persistence.PersistenceManagerFactory;
import org.jboss.ejb3.cache.persistence.PersistenceManagerFactoryRegistry;
import org.jboss.ejb3.cache.simple.StatefulSessionPersistenceManager;
import org.jboss.ejb3.stateful.StatefulBeanContext;
import org.jboss.ejb3.stateful.StatefulContainer;
import org.jboss.logging.Logger;

public class SimpleStatefulCache
implements StatefulCache {
    private Logger log = Logger.getLogger(SimpleStatefulCache.class);
    private StatefulContainer container;
    protected CacheMap cacheMap;
    private int maxSize = 1000;
    private StatefulSessionPersistenceManager pm;
    private long sessionTimeout = 300L;
    private long removalTimeout = 0L;
    private Thread timeoutTask;
    private RemovalTimeoutTask removalTask = null;
    private boolean running = true;
    private int createCount = 0;
    private int passivatedCount = 0;
    private int removeCount = 0;
    private Queue<StatefulBeanContext> passivationQueue = new LinkedBlockingQueue<StatefulBeanContext>();
    private Map<Object, FutureTask<StatefulBeanContext>> activations = new HashMap<Object, FutureTask<StatefulBeanContext>>();

    @Override
    public void initialize(EJBContainer container) throws Exception {
        this.container = (StatefulContainer)container;
        Advisor advisor = container.getAdvisor();
        this.cacheMap = new CacheMap();
        PersistenceManager pmConfig = (PersistenceManager)advisor.resolveAnnotation(PersistenceManager.class);
        EJBContainer ejbContainer = container;
        String pmConfigValue = pmConfig.value();
        PersistenceManagerFactoryRegistry pmFactoryRegistry = ejbContainer.getDeployment().getPersistenceManagerFactoryRegistry();
        PersistenceManagerFactory pmFactory = pmFactoryRegistry.getPersistenceManagerFactory(pmConfigValue);
        this.pm = pmFactory.createPersistenceManager();
        this.pm.initialize(container);
        CacheConfig config = (CacheConfig)advisor.resolveAnnotation(CacheConfig.class);
        this.maxSize = config.maxSize();
        this.sessionTimeout = config.idleTimeoutSeconds();
        this.removalTimeout = config.removalTimeoutSeconds();
        this.log = Logger.getLogger((String)(this.getClass().getName() + "." + container.getEjbName()));
        this.log.debug((Object)("Initializing SimpleStatefulCache with maxSize: " + this.maxSize + " timeout: " + this.sessionTimeout + " for " + container.getObjectName().getCanonicalName()));
        this.timeoutTask = new SessionTimeoutTask("SFSB Passivation Thread - " + container.getObjectName().getCanonicalName());
        if (this.removalTimeout > 0L) {
            this.removalTask = new RemovalTimeoutTask("SFSB Removal Thread - " + container.getObjectName().getCanonicalName());
        }
    }

    public void start() {
        this.running = true;
        this.timeoutTask.start();
        if (this.removalTask != null) {
            this.removalTask.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        CacheMap cacheMap = this.cacheMap;
        synchronized (cacheMap) {
            this.running = false;
            this.timeoutTask.interrupt();
            if (this.removalTask != null) {
                this.removalTask.interrupt();
            }
            this.cacheMap.clear();
            try {
                this.pm.destroy();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void passivate(StatefulBeanContext ctx) {
        ClassLoader oldCl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(ctx.getContainer().getClassloader());
            StatefulSessionPersistenceManager statefulSessionPersistenceManager = this.pm;
            synchronized (statefulSessionPersistenceManager) {
                this.pm.passivateSession(ctx);
            }
            ++this.passivatedCount;
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldCl);
        }
    }

    public StatefulBeanContext create() {
        return this.create((Class[])null, (Object[])null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StatefulBeanContext create(Class<?>[] initTypes, Object[] initValues) {
        Object ctx = null;
        try {
            ctx = this.container.create((Class[])initTypes, initValues);
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("Caching context " + ((StatefulBeanContext)ctx).getId() + " of type " + ctx.getClass()));
            }
            CacheMap cacheMap = this.cacheMap;
            synchronized (cacheMap) {
                this.cacheMap.put(((StatefulBeanContext)ctx).getId(), ctx);
                ((StatefulBeanContext)ctx).setInUse(true);
                ((StatefulBeanContext)ctx).lastUsed = System.currentTimeMillis();
            }
            ++this.createCount;
        }
        catch (EJBException e) {
            e.printStackTrace();
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new EJBException(e);
        }
        return ctx;
    }

    @Override
    public StatefulBeanContext get(Object key) throws EJBException {
        return this.get(key, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StatefulBeanContext get(final Object key, boolean markInUse) throws EJBException {
        StatefulBeanContext entry = null;
        CacheMap cacheMap = this.cacheMap;
        synchronized (cacheMap) {
            entry = (StatefulBeanContext)this.cacheMap.get(key);
        }
        if (entry == null) {
            cacheMap = this.cacheMap;
            synchronized (cacheMap) {
                entry = (StatefulBeanContext)this.cacheMap.get(key);
                if (entry == null) {
                    for (StatefulBeanContext statefulBeanContext : this.passivationQueue) {
                        if (!statefulBeanContext.getId().equals(key)) continue;
                        boolean passivationCanceled = this.passivationQueue.remove(statefulBeanContext);
                        if (!passivationCanceled) break;
                        entry = statefulBeanContext;
                        this.cacheMap.put(key, entry);
                        break;
                    }
                }
            }
        }
        if (entry == null) {
            boolean executeActivation;
            FutureTask<StatefulBeanContext> activation;
            StatefulSessionPersistenceManager statefulSessionPersistenceManager = this.pm;
            synchronized (statefulSessionPersistenceManager) {
                activation = this.activations.get(key);
                if (activation == null) {
                    activation = new FutureTask<StatefulBeanContext>(new Callable<StatefulBeanContext>(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public StatefulBeanContext call() throws Exception {
                            StatefulBeanContext entry;
                            CacheMap cacheMap = SimpleStatefulCache.this.cacheMap;
                            synchronized (cacheMap) {
                                entry = (StatefulBeanContext)SimpleStatefulCache.this.cacheMap.get(key);
                            }
                            if (entry == null) {
                                entry = SimpleStatefulCache.this.pm.activateSession(key);
                                if (entry == null) {
                                    throw new NoSuchEJBException("Could not find stateful bean: " + key);
                                }
                                --SimpleStatefulCache.this.passivatedCount;
                                if (SimpleStatefulCache.this.log.isTraceEnabled()) {
                                    SimpleStatefulCache.this.log.trace((Object)("Caching activated context " + entry.getId() + " of type " + entry.getClass()));
                                }
                                cacheMap = SimpleStatefulCache.this.cacheMap;
                                synchronized (cacheMap) {
                                    SimpleStatefulCache.this.cacheMap.put(key, entry);
                                    SimpleStatefulCache.this.activations.remove(key);
                                }
                            }
                            return entry;
                        }
                    });
                    this.activations.put(key, activation);
                    executeActivation = true;
                } else {
                    executeActivation = false;
                }
            }
            if (executeActivation) {
                activation.run();
            }
            try {
                entry = activation.get();
            }
            catch (InterruptedException interruptedException) {
                throw new EJBException((Exception)interruptedException);
            }
            catch (ExecutionException executionException) {
                if (executionException.getCause() instanceof RuntimeException) {
                    throw (RuntimeException)executionException.getCause();
                }
                throw (EJBException)new EJBException().initCause(executionException.getCause());
            }
        }
        if (markInUse) {
            if (entry.isRemoved()) {
                throw new NoSuchEJBException("Could not find stateful bean: " + key + " (bean was marked as removed");
            }
            entry.setInUse(true);
            entry.lastUsed = System.currentTimeMillis();
        }
        return entry;
    }

    public StatefulBeanContext peek(Object key) throws NoSuchEJBException {
        return this.get(key, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(StatefulBeanContext ctx) {
        StatefulBeanContext statefulBeanContext = ctx;
        synchronized (statefulBeanContext) {
            ctx.setInUse(false);
            ctx.lastUsed = System.currentTimeMillis();
            if (ctx.markedForPassivation) {
                this.passivate(ctx);
            }
        }
    }

    public void remove(Object key) {
        this.remove(key, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Object key, Iterator it) {
        StatefulBeanContext ctx;
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Removing context " + key));
        }
        if ((ctx = this.get(key)) == null) {
            throw new NoSuchEJBException("Could not find Stateful bean: " + key);
        }
        if (!ctx.isRemoved()) {
            this.container.destroy(ctx);
        }
        ++this.removeCount;
        if (ctx.getCanRemoveFromCache()) {
            if (it == null) {
                CacheMap cacheMap = this.cacheMap;
                synchronized (cacheMap) {
                    this.cacheMap.remove(key);
                }
            } else {
                it.remove();
            }
        }
    }

    @Override
    public int getCacheSize() {
        return this.cacheMap.size();
    }

    @Override
    public int getTotalSize() {
        return this.getCacheSize() + this.getPassivatedCount();
    }

    @Override
    public int getCreateCount() {
        return this.createCount;
    }

    @Override
    public int getPassivatedCount() {
        return this.passivatedCount;
    }

    @Override
    public int getRemoveCount() {
        return this.removeCount;
    }

    @Override
    public int getAvailableCount() {
        int maxSize = this.getMaxSize();
        if (maxSize < 0) {
            return maxSize;
        }
        int currentSize = this.getCurrentSize();
        int available = maxSize - currentSize;
        return available;
    }

    @Override
    public int getMaxSize() {
        return this.maxSize;
    }

    @Override
    public int getCurrentSize() {
        return this.cacheMap.size();
    }

    @Override
    public boolean isStarted() {
        return this.running;
    }

    protected Thread getTimeoutTask() {
        return this.timeoutTask;
    }

    protected void setTimeoutTask(Thread timeoutTask) {
        this.timeoutTask = timeoutTask;
    }

    protected long getSessionTimeout() {
        return this.sessionTimeout;
    }

    protected long getRemovalTimeout() {
        return this.removalTimeout;
    }

    protected RemovalTimeoutTask getRemovalTask() {
        return this.removalTask;
    }

    protected void setRemovalTask(RemovalTimeoutTask removalTask) {
        this.removalTask = removalTask;
    }

    protected class SessionTimeoutTask
    extends Thread {
        public SessionTimeoutTask(String name) {
            super(name);
        }

        public void block() throws InterruptedException {
            Thread.sleep(SimpleStatefulCache.this.sessionTimeout * 1000L);
        }

        protected void passivationCompleted() {
        }

        protected void prePassivationCompleted() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (SimpleStatefulCache.this.running) {
                try {
                    this.block();
                }
                catch (InterruptedException e) {
                    SimpleStatefulCache.this.running = false;
                    return;
                }
                try {
                    StatefulBeanContext ctx;
                    CacheMap e = SimpleStatefulCache.this.cacheMap;
                    synchronized (e) {
                        if (!SimpleStatefulCache.this.running) {
                            return;
                        }
                        boolean trace = SimpleStatefulCache.this.log.isTraceEnabled();
                        Iterator it = SimpleStatefulCache.this.cacheMap.entrySet().iterator();
                        long now = System.currentTimeMillis();
                        while (it.hasNext()) {
                            Map.Entry entry = it.next();
                            StatefulBeanContext centry = (StatefulBeanContext)entry.getValue();
                            if (now - centry.lastUsed >= SimpleStatefulCache.this.sessionTimeout * 1000L) {
                                StatefulBeanContext statefulBeanContext = centry;
                                synchronized (statefulBeanContext) {
                                    if (centry.getCanPassivate()) {
                                        if (!centry.getCanRemoveFromCache()) {
                                            SimpleStatefulCache.this.passivationQueue.add(centry);
                                        } else if (trace) {
                                            SimpleStatefulCache.this.log.trace((Object)("Removing " + entry.getKey() + " from cache"));
                                        }
                                    } else {
                                        centry.markedForPassivation = true;
                                        assert (centry.isInUse()) : centry + " is not in use, and thus will never be passivated";
                                    }
                                    it.remove();
                                    continue;
                                }
                            }
                            if (!trace) continue;
                            SimpleStatefulCache.this.log.trace((Object)("Not passivating; id=" + centry.getId() + " only inactive " + Math.max(0L, now - centry.lastUsed) + " ms"));
                        }
                    }
                    this.prePassivationCompleted();
                    while ((ctx = (StatefulBeanContext)SimpleStatefulCache.this.passivationQueue.poll()) != null) {
                        SimpleStatefulCache.this.passivate(ctx);
                    }
                    this.passivationCompleted();
                }
                catch (Exception ex) {
                    SimpleStatefulCache.this.log.error((Object)"problem passivation thread", (Throwable)ex);
                }
            }
        }
    }

    protected class RemovalTimeoutTask
    extends Thread {
        public RemovalTimeoutTask(String name) {
            super(name);
        }

        protected void block() throws InterruptedException {
            Thread.sleep(SimpleStatefulCache.this.removalTimeout * 1000L);
        }

        protected void preRemoval() {
        }

        protected void postRemoval() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (SimpleStatefulCache.this.running) {
                try {
                    this.block();
                }
                catch (InterruptedException e) {
                    SimpleStatefulCache.this.running = false;
                    return;
                }
                try {
                    this.preRemoval();
                    long now = System.currentTimeMillis();
                    CacheMap cacheMap = SimpleStatefulCache.this.cacheMap;
                    synchronized (cacheMap) {
                        if (!SimpleStatefulCache.this.running) {
                            return;
                        }
                        Iterator<Object> it = SimpleStatefulCache.this.cacheMap.entrySet().iterator();
                        while (it.hasNext()) {
                            Map.Entry entry = it.next();
                            StatefulBeanContext centry = (StatefulBeanContext)entry.getValue();
                            if (now - centry.lastUsed < SimpleStatefulCache.this.removalTimeout * 1000L) continue;
                            StatefulBeanContext statefulBeanContext = centry;
                            synchronized (statefulBeanContext) {
                                SimpleStatefulCache.this.remove(centry.getId(), it);
                            }
                        }
                    }
                    List<StatefulBeanContext> beans = SimpleStatefulCache.this.pm.getPassivatedBeans();
                    for (StatefulBeanContext centry : beans) {
                        if (now - centry.lastUsed < SimpleStatefulCache.this.removalTimeout * 1000L) continue;
                        SimpleStatefulCache.this.get(centry.getId(), false);
                        SimpleStatefulCache.this.remove(centry.getId());
                    }
                    this.postRemoval();
                }
                catch (Exception ex) {
                    SimpleStatefulCache.this.log.error((Object)"problem removing SFSB thread", (Throwable)ex);
                }
            }
        }
    }

    protected class CacheMap
    extends LinkedHashMap<Object, StatefulBeanContext> {
        private static final long serialVersionUID = 4514182777643616159L;

        public CacheMap() {
            super(SimpleStatefulCache.this.maxSize, 0.75f, true);
        }

        public CacheMap(Map<? extends Object, ? extends StatefulBeanContext> original) {
            super(original);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean removeEldestEntry(Map.Entry<Object, StatefulBeanContext> entry) {
            boolean removeIt;
            boolean bl = removeIt = this.size() > SimpleStatefulCache.this.maxSize;
            if (removeIt) {
                StatefulBeanContext centry;
                StatefulBeanContext statefulBeanContext = centry = entry.getValue();
                synchronized (statefulBeanContext) {
                    if (centry.getCanPassivate()) {
                        SimpleStatefulCache.this.passivate(centry);
                    } else {
                        centry.markedForPassivation = true;
                        if (!centry.isInUse()) {
                            removeIt = false;
                        }
                    }
                }
            }
            return removeIt;
        }
    }
}

