/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting;

import java.io.Serializable;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import org.jboss.logging.Logger;
import org.jboss.remoting.Home;
import org.jboss.remoting.InvokerRegistry;
import org.jboss.remoting.Version;
import org.jboss.remoting.transport.ClientInvoker;
import org.jboss.remoting.util.SecurityUtility;

public class InvokerLocator
implements Serializable {
    static final long serialVersionUID;
    protected static Logger log;
    protected static Boolean legacyParsingFlag;
    protected String protocol;
    protected String host;
    protected ArrayList connectHomes = new ArrayList();
    protected ArrayList homes = new ArrayList();
    protected int port;
    protected String path;
    protected String query;
    protected Map parameters;
    private String uri;
    private String originalURL;
    private Home homeInUse;
    public static final String ANY = "0.0.0.0";
    private static final String SERVER_BIND_ADDRESS = "jboss.bind.address";
    public static final String BIND_BY_HOST = "remoting.bind_by_host";
    public static final String DATATYPE = "datatype";
    public static final String DATATYPE_CASED = "dataType";
    public static final String SERIALIZATIONTYPE = "serializationtype";
    public static final String SERIALIZATIONTYPE_CASED = "serializationType";
    public static final String MARSHALLER = "marshaller";
    public static final String UNMARSHALLER = "unmarshaller";
    public static final String LOADER_PORT = "loaderport";
    public static final String BYVALUE = "byvalue";
    public static final String FORCE_REMOTE = "force_remote";
    public static final String CLIENT_LEASE = "leasing";
    public static final String CLIENT_LEASE_PERIOD = "lease_period";
    public static final String LEGACY_PARSING = "legacyParsing";
    public static final String MULTIHOME = "multihome";
    public static final String CONNECT_HOMES_KEY = "connecthomes";
    public static final String HOMES_KEY = "homes";
    public static final String DEFAULT_CONNECT_PORT = "defaultConnectPort";
    public static final String DEFAULT_PORT = "defaultPort";
    public static final String SUPPRESS_HOST_WARNING = "suppressHostWarning";
    private static final InetAddress LOCAL_HOST;

    public static boolean getUseLegacyParsing() {
        if (legacyParsingFlag == null) {
            return false;
        }
        return legacyParsingFlag;
    }

    public static void setUseLegacyParsing(boolean flag) {
        legacyParsingFlag = new Boolean(flag);
    }

    public static InvokerLocator validateLocator(InvokerLocator locator) throws MalformedURLException {
        InvokerLocator externalLocator = locator;
        String host = locator.getHost();
        String newHost = null;
        if (host == null || ANY.equals(host)) {
            try {
                newHost = (String)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        String bindByHost = System.getProperty(InvokerLocator.BIND_BY_HOST, "True");
                        boolean byHost = Boolean.valueOf(bindByHost);
                        if (byHost) {
                            return InvokerLocator.getLocalHost().getHostName();
                        }
                        return InvokerLocator.getLocalHost().getHostAddress();
                    }
                });
            }
            catch (PrivilegedActionException e) {
                log.debug((Object)"Could not get host by name or address.", e.getCause());
            }
            if (newHost == null) {
                throw new RuntimeException("Can not determine bindable address for locator (" + locator + ")");
            }
            externalLocator = new InvokerLocator(locator.protocol, newHost, locator.port, locator.getPath(), locator.getParameters());
        }
        return externalLocator;
    }

    public static void extractHomes(String homeList, List list, int defaultPort) {
        StringTokenizer tok = new StringTokenizer(homeList, "!");
        while (tok.hasMoreTokens()) {
            int pos;
            boolean isIPv6;
            String h = null;
            int p = -1;
            String token = tok.nextToken();
            boolean bl = isIPv6 = token.indexOf(91) >= 0;
            int boundary = isIPv6 ? ((pos = token.indexOf(93)) + 1 == token.length() ? -1 : token.indexOf(93) + 1) : token.lastIndexOf(58);
            if (boundary > -1) {
                h = token.substring(0, boundary);
                try {
                    p = Integer.valueOf(token.substring(boundary + 1));
                }
                catch (NumberFormatException e) {
                    log.warn((Object)("invalid port value: " + token.substring(boundary + 1)));
                }
            } else {
                h = token;
            }
            if (p == -1) {
                p = defaultPort;
            }
            list.add(new Home(h, p));
        }
    }

    public static String convertHomesListToString(List homes) {
        if (homes == null || homes.size() == 0) {
            return "";
        }
        Iterator it = homes.iterator();
        StringBuffer b = new StringBuffer(((Home)it.next()).toString());
        while (it.hasNext()) {
            b.append("!").append(it.next());
        }
        return b.toString();
    }

    private static InetAddress getLocalHost() throws UnknownHostException {
        if (LOCAL_HOST != null) {
            return LOCAL_HOST;
        }
        try {
            return InetAddress.getLocalHost();
        }
        catch (UnknownHostException e) {
            return InetAddress.getByName("127.0.0.1");
        }
    }

    public InvokerLocator(String uri) throws MalformedURLException {
        this.originalURL = uri;
        this.parse(this.originalURL);
    }

    private void parse(String uriString) throws MalformedURLException {
        String s;
        boolean doLegacyParsing = false;
        if (legacyParsingFlag != null) {
            doLegacyParsing = legacyParsingFlag;
        } else {
            s = InvokerLocator.getSystemProperty(LEGACY_PARSING);
            doLegacyParsing = "true".equalsIgnoreCase(s);
        }
        if (doLegacyParsing) {
            log.warn((Object)"using deprecated legacy URL parsing routine");
            this.legacyParse(uriString);
        } else {
            this.URIParse(uriString);
        }
        if (this.query != null) {
            StringTokenizer tok = new StringTokenizer(this.query, "&");
            this.parameters = new TreeMap();
            while (tok.hasMoreTokens()) {
                String token = tok.nextToken();
                int eq = token.indexOf("=");
                String name = eq > -1 ? token.substring(0, eq) : token;
                String value = eq > -1 ? token.substring(eq + 1) : "";
                this.parameters.put(name, value);
            }
        }
        if (!MULTIHOME.equals(this.host) && this.parameters != null && (s = (String)this.parameters.remove(CONNECT_HOMES_KEY)) != null) {
            log.warn((Object)"host != multihome: connecthomes will be ignored");
        }
        if (this.parameters != null) {
            String homesString = (String)this.parameters.remove(HOMES_KEY);
            String connectHomesString = (String)this.parameters.remove(CONNECT_HOMES_KEY);
            this.createHomeLists(this.parameters, homesString, connectHomesString);
        }
        this.rebuildLocatorURI();
        if (!MULTIHOME.equals(this.host)) {
            this.homeInUse = new Home(this.host, this.port);
            this.connectHomes.add(this.homeInUse);
            if (this.homes.isEmpty()) {
                this.homes.add(this.homeInUse);
            }
        }
    }

    private void URIParse(String uriString) throws MalformedURLException {
        try {
            URI uri = new URI(InvokerLocator.encodePercent(uriString));
            this.protocol = uri.getScheme();
            InvokerLocator.checkHost(this.originalURL, uri.getHost());
            this.host = InvokerLocator.decodePercent(InvokerLocator.resolveHost(uri.getHost()));
            this.port = uri.getPort();
            this.path = uri.getPath();
            this.query = InvokerLocator.decodePercent(uri.getQuery());
        }
        catch (URISyntaxException e) {
            throw new MalformedURLException(e.getMessage());
        }
    }

    private void legacyParse(String uri) throws MalformedURLException {
        log.warn((Object)"Legacy InvokerLocator parsing is deprecated");
        int i = uri.indexOf("://");
        if (i < 0) {
            throw new MalformedURLException("Invalid url " + uri);
        }
        String tmp = uri.substring(i + 3);
        this.protocol = uri.substring(0, i);
        i = tmp.indexOf("/");
        int p = tmp.indexOf(":");
        if (i != -1) {
            int n = p = p < i ? p : -1;
        }
        if (p != -1) {
            this.host = InvokerLocator.resolveHost(tmp.substring(0, p).trim());
            this.port = i > -1 ? Integer.parseInt(tmp.substring(p + 1, i)) : Integer.parseInt(tmp.substring(p + 1));
        } else {
            this.host = i > -1 ? InvokerLocator.resolveHost(tmp.substring(0, i).trim()) : InvokerLocator.resolveHost(tmp.substring(0).trim());
            this.port = -1;
        }
        p = tmp.indexOf("?");
        if (p != -1) {
            this.path = tmp.substring(i + 1, p);
            this.query = tmp.substring(p + 1);
        } else {
            p = tmp.indexOf("/");
            this.path = p != -1 ? tmp.substring(p + 1) : "";
            this.query = null;
        }
    }

    private static void checkHost(String uri, String host) {
        if (host == null && !InvokerLocator.getBoolean(SUPPRESS_HOST_WARNING)) {
            StringBuffer sb = new StringBuffer("Host resolves to null in ");
            sb.append(uri).append(". Perhaps the host contains an invalid character.  ");
            sb.append("See http://www.ietf.org/rfc/rfc2396.txt.");
            log.warn((Object)sb.toString());
        }
    }

    private static final String resolveHost(String host) {
        if (host == null) {
            host = InvokerLocator.fixRemoteAddress(host);
        } else if (host.indexOf(ANY) != -1) {
            String bindAddress = InvokerLocator.getSystemProperty(SERVER_BIND_ADDRESS, ANY);
            host = bindAddress.equals(ANY) ? InvokerLocator.fixRemoteAddress(host) : host.replaceAll("0\\.0\\.0\\.0", InvokerLocator.getSystemProperty(SERVER_BIND_ADDRESS));
        }
        return host;
    }

    private static String fixRemoteAddress(String address) {
        if (address == null) {
            try {
                address = (String)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws UnknownHostException {
                        String bindByHost = System.getProperty(InvokerLocator.BIND_BY_HOST, "True");
                        boolean byHost = Boolean.valueOf(bindByHost);
                        if (byHost) {
                            return InvokerLocator.getLocalHost().getHostName();
                        }
                        return InvokerLocator.getLocalHost().getHostAddress();
                    }
                });
            }
            catch (PrivilegedActionException e) {
                log.debug((Object)"error", e.getCause());
            }
        }
        return address;
    }

    private void createHomeLists(Map parameters, String homesString, String connectHomesString) {
        int defaultPort = this.port;
        String s = (String)parameters.get(DEFAULT_PORT);
        if (s != null && s != "") {
            try {
                defaultPort = Integer.parseInt(s);
            }
            catch (Exception e) {
                log.warn((Object)("invalid value for defaultPort: " + s));
            }
        }
        if (homesString != null) {
            InvokerLocator.extractHomes(homesString, this.homes, defaultPort);
        }
        if ((s = (String)parameters.get(DEFAULT_CONNECT_PORT)) != null && s != "") {
            try {
                defaultPort = Integer.parseInt(s);
            }
            catch (Exception e) {
                log.warn((Object)("invalid value for defaultConnectPort: " + s));
            }
        }
        if (connectHomesString != null) {
            InvokerLocator.extractHomes(connectHomesString, this.connectHomes, defaultPort);
        }
    }

    public InvokerLocator(String protocol, String host, int port, String path, Map parameters) {
        this.protocol = protocol;
        this.host = InvokerLocator.resolveHost(host);
        this.port = port;
        this.path = path == null ? "" : path;
        TreeMap treeMap = this.parameters = parameters == null ? new TreeMap() : new TreeMap(parameters);
        if (this.parameters != null) {
            String homesString = (String)this.parameters.remove(HOMES_KEY);
            String connectHomesString = (String)this.parameters.remove(CONNECT_HOMES_KEY);
            this.createHomeLists(this.parameters, homesString, connectHomesString);
        }
        if (this.host != null && this.host.indexOf(":") >= 0 && this.host.indexOf("[") == -1) {
            this.host = "[" + this.host + "]";
        }
        this.rebuildLocatorURI();
        this.originalURL = this.uri;
        if (!MULTIHOME.equals(host)) {
            String s;
            this.homeInUse = new Home(host, port);
            this.homes.add(this.homeInUse);
            this.connectHomes.add(this.homeInUse);
            if (parameters != null && (s = (String)parameters.remove(CONNECT_HOMES_KEY)) != null) {
                log.warn((Object)"host != multihome: connecthomes will be ignored");
            }
        }
    }

    public int hashCode() {
        return this.uri.hashCode();
    }

    public boolean equals(Object obj) {
        return obj != null && obj instanceof InvokerLocator && this.uri.equals(((InvokerLocator)obj).getLocatorURI());
    }

    public boolean isSameEndpoint(InvokerLocator compareMe) {
        return compareMe != null && this.getProtocol().equalsIgnoreCase(compareMe.getProtocol()) && this.getHost().equalsIgnoreCase(compareMe.getHost()) && this.getPort() == compareMe.getPort();
    }

    public boolean isCompatibleWith(InvokerLocator other) {
        if (other == null) {
            return false;
        }
        if (this.homes == null || other.homes == null) {
            return false;
        }
        boolean result1 = this.getProtocol().equalsIgnoreCase(other.getProtocol()) && this.path.equals(other.getPath()) && ((Object)this.parameters).equals(other.getParameters());
        ArrayList tempHomes = this.connectHomes.isEmpty() ? this.homes : this.connectHomes;
        boolean result2 = this.intersects(tempHomes, other.getConnectHomeList()) || this.intersects(tempHomes, other.getHomeList());
        return result1 && result2;
    }

    public String getLocatorURI() {
        return this.uri;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getHost() {
        if (this.host.equals(MULTIHOME) && this.homeInUse != null) {
            return this.homeInUse.host;
        }
        return this.host;
    }

    public String getActualHost() {
        return this.host;
    }

    public boolean isMultihome() {
        return MULTIHOME.equals(this.host);
    }

    public String getConnectHomes() {
        return InvokerLocator.convertHomesListToString(this.connectHomes);
    }

    public List getConnectHomeList() {
        if (this.connectHomes == null) {
            ArrayList<Home> list = new ArrayList<Home>();
            list.add(new Home(this.host, this.port));
            return list;
        }
        return new ArrayList(this.connectHomes);
    }

    public void setConnectHomeList(List connectHomes) {
        this.connectHomes = connectHomes == null ? new ArrayList() : new ArrayList(connectHomes);
        this.rebuildLocatorURI();
    }

    public Home getHomeInUse() {
        if (this.homeInUse != null || this.isMultihome()) {
            return this.homeInUse;
        }
        return new Home(this.host, this.port);
    }

    public void setHomeInUse(Home homeInUse) {
        this.homeInUse = homeInUse;
    }

    public String getHomes() {
        return InvokerLocator.convertHomesListToString(this.homes);
    }

    public List getHomeList() {
        if (this.homes == null) {
            ArrayList<Home> list = new ArrayList<Home>();
            list.add(new Home(this.host, this.port));
            return new ArrayList();
        }
        return new ArrayList(this.homes);
    }

    public void setHomeList(List homes) {
        this.homes = homes == null ? new ArrayList() : new ArrayList(homes);
        this.rebuildLocatorURI();
    }

    public int getPort() {
        if (this.host.equals(MULTIHOME) && this.homeInUse != null) {
            return this.homeInUse.port;
        }
        return this.port;
    }

    public int getActualPort() {
        return this.port;
    }

    public String getPath() {
        return this.path;
    }

    public Map getParameters() {
        if (this.parameters == null) {
            this.parameters = new TreeMap();
        }
        return this.parameters;
    }

    public String toString() {
        return "InvokerLocator [" + this.uri + "]";
    }

    public String getOriginalURI() {
        return this.originalURL;
    }

    public ClientInvoker narrow() throws Exception {
        try {
            return (ClientInvoker)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return InvokerRegistry.createClientInvoker(InvokerLocator.this);
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw pae.getException();
        }
    }

    public String findSerializationType() {
        String serializationTypeLocal = "java";
        if (this.parameters != null && (serializationTypeLocal = (String)this.parameters.get(SERIALIZATIONTYPE)) == null && (serializationTypeLocal = (String)this.parameters.get(SERIALIZATIONTYPE_CASED)) == null) {
            serializationTypeLocal = "java";
        }
        return serializationTypeLocal;
    }

    protected boolean intersects(Collection c1, Collection c2) {
        Iterator it = c1.iterator();
        while (it.hasNext()) {
            if (!c2.contains(it.next())) continue;
            return true;
        }
        return false;
    }

    protected void rebuildLocatorURI() {
        String portPart = this.port > -1 ? ":" + this.port : "";
        String divider = this.path.startsWith("/") ? "" : "/";
        String parametersPart = this.parameters != null ? "?" : "";
        this.uri = this.protocol + "://" + this.host + portPart + divider + this.path + parametersPart;
        if (this.parameters != null) {
            if (!this.homes.isEmpty()) {
                this.parameters.put(HOMES_KEY, InvokerLocator.convertHomesListToString(this.homes));
            }
            if (!this.connectHomes.isEmpty()) {
                this.parameters.put(CONNECT_HOMES_KEY, InvokerLocator.convertHomesListToString(this.connectHomes));
            }
            Iterator iter = this.parameters.keySet().iterator();
            while (iter.hasNext()) {
                String key = (String)iter.next();
                String val = (String)this.parameters.get(key);
                this.uri = "".equals(val) ? this.uri + key : this.uri + key + "=" + val;
                if (!iter.hasNext()) continue;
                this.uri = this.uri + "&";
            }
            this.parameters.remove(HOMES_KEY);
            this.parameters.remove(CONNECT_HOMES_KEY);
        }
    }

    protected static String encodePercent(String s) {
        if (s == null) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(s, "%");
        StringBuffer sb = new StringBuffer();
        int limit = st.countTokens() - 1;
        for (int i = 0; i < limit; ++i) {
            String token = st.nextToken();
            sb.append(token).append("%25");
        }
        sb.append(st.nextToken());
        return sb.toString();
    }

    protected static String decodePercent(String s) {
        if (s == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        int fromIndex = 0;
        int index = s.indexOf("%25", fromIndex);
        while (index >= 0) {
            sb.append(s.substring(fromIndex, index)).append('%');
            fromIndex = index + 3;
            index = s.indexOf("%25", fromIndex);
        }
        sb.append(s.substring(fromIndex));
        return sb.toString();
    }

    private static String getSystemProperty(final String name, final String defaultValue) {
        if (SecurityUtility.skipAccessControl()) {
            return System.getProperty(name, defaultValue);
        }
        String value = null;
        try {
            value = (String)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return System.getProperty(name, defaultValue);
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (RuntimeException)e.getCause();
        }
        return value;
    }

    private static String getSystemProperty(final String name) {
        if (SecurityUtility.skipAccessControl()) {
            return System.getProperty(name);
        }
        String value = null;
        try {
            value = (String)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return System.getProperty(name);
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (RuntimeException)e.getCause();
        }
        return value;
    }

    private static boolean getBoolean(final String name) {
        if (SecurityUtility.skipAccessControl()) {
            return Boolean.getBoolean(name);
        }
        Boolean value = null;
        try {
            value = (Boolean)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return Boolean.getBoolean(name);
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (RuntimeException)e.getCause();
        }
        return value;
    }

    static {
        log = Logger.getLogger(InvokerLocator.class);
        serialVersionUID = Version.getDefaultVersion() == 1 ? -2909329895029296248L : -4977622166779282521L;
        try {
            LOCAL_HOST = (InetAddress)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws UnknownHostException {
                    try {
                        return InetAddress.getLocalHost();
                    }
                    catch (UnknownHostException e) {
                        return InetAddress.getByName("127.0.0.1");
                    }
                }
            });
        }
        catch (PrivilegedActionException e) {
            log.debug((Object)(InvokerLocator.class.getName() + " unable to get local host address"), e.getCause());
            throw new ExceptionInInitializerError(e.getCause());
        }
        catch (SecurityException e) {
            log.debug((Object)(InvokerLocator.class.getName() + " unable to get local host address"), (Throwable)e);
            throw e;
        }
    }
}

