/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.virtual.spi;

import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CopyOnWriteArraySet;
import org.jboss.virtual.spi.FileHandlerPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileHandlerPluginRegistry {
    private static FileHandlerPluginRegistry instance = new FileHandlerPluginRegistry();
    private Set<FileHandlerPlugin> plugins = new CopyOnWriteArraySet<FileHandlerPlugin>(new TreeSet<FileHandlerPlugin>(FileHandlerPlugin.COMPARATOR));

    private FileHandlerPluginRegistry() {
    }

    public static FileHandlerPluginRegistry getInstance() {
        return instance;
    }

    public boolean addFileHandlerPlugin(FileHandlerPlugin plugin) {
        return this.plugins.add(plugin);
    }

    public boolean removeFileHandlerPlugin(FileHandlerPlugin plugin) {
        return this.plugins.remove(plugin);
    }

    public Set<FileHandlerPlugin> getFileHandlerPlugins() {
        return Collections.unmodifiableSet(this.plugins);
    }
}

