/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.gui.table.renderer;

import java.io.IOException;
import java.util.List;
import javax.faces.component.UIComponent;
import javax.faces.component.UIData;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.gui.table.component.AllRowsSelectorComponent;
import org.rhq.core.gui.table.component.RowSelectorComponent;
import org.rhq.core.gui.table.renderer.AbstractRenderer;
import org.rhq.core.gui.util.FacesComponentUtility;

public class AllRowsSelectorRenderer
extends AbstractRenderer {
    private final Log log = LogFactory.getLog(((Object)((Object)this)).getClass());

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        this.validateParameters(context, component);
        AllRowsSelectorComponent allRowsSelector = (AllRowsSelectorComponent)component;
        UIData data = this.getTargetUIData(allRowsSelector);
        RowSelectorComponent rowSelector = this.getRowSelector(data);
        if (rowSelector.getMode() != RowSelectorComponent.Mode.multi) {
            this.log.error((Object)("An allRowsSelector component was specified for dataTable component " + data + ", which has a rowSelector with mode 'single', " + "but allRowsSelector components can only be used with rowSelectors with mode 'multi'. " + "The allRowSelector will not be rendered."));
            allRowsSelector.setRendered(false);
            return;
        }
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("input", component);
        this.writeIdAttributeIfNecessary(context, writer, component);
        String type = "checkbox";
        writer.writeAttribute("type", (Object)type, "type");
        String clientId = component.getClientId(context);
        writer.writeAttribute("name", (Object)clientId, "clientId");
        String onclick = "selectAll(this, '" + rowSelector.getClientId(context) + "')";
        String userSpecifiedOnclick = (String)rowSelector.getAttributes().get("onclick");
        if (userSpecifiedOnclick != null) {
            onclick = onclick + "; " + userSpecifiedOnclick;
        }
        writer.writeAttribute("onclick", (Object)onclick, "onclick");
        Boolean disabled = (Boolean)rowSelector.getAttributes().get("disabled");
        if (disabled != null && disabled.booleanValue()) {
            writer.writeAttribute("disabled", (Object)"disabled", "disabled");
        }
        writer.endElement("input");
    }

    private RowSelectorComponent getRowSelector(UIData data) {
        List<RowSelectorComponent> rowSelectors = FacesComponentUtility.getDescendantsOfType((UIComponent)data, RowSelectorComponent.class);
        if (rowSelectors.isEmpty()) {
            throw new IllegalStateException("No rowSelector component was found within the target dataTable component " + data + ".");
        }
        if (rowSelectors.size() > 1) {
            throw new IllegalStateException("More than one rowSelector component was found within the target dataTable component " + data + ".");
        }
        RowSelectorComponent rowSelector = rowSelectors.get(0);
        return rowSelector;
    }

    private UIData getTargetUIData(AllRowsSelectorComponent allRowsSelector) {
        UIData data;
        String dataTableId = allRowsSelector.getDataTableId();
        if (dataTableId != null) {
            data = (UIData)allRowsSelector.findComponent(dataTableId);
            if (data == null) {
                throw new IllegalStateException("UIData component (i.e. h:dataTable or rich:*dataTable) with id '" + dataTableId + "' not found within naming scope of component " + (Object)((Object)allRowsSelector) + ". The allRowsSelector component must either be within a UIData component or must specify the id of a UIData component within its naming scope via the 'dataTableId' attribute.");
            }
        } else {
            data = FacesComponentUtility.getAncestorOfType((UIComponent)allRowsSelector, UIData.class);
            if (data == null) {
                throw new IllegalStateException("Enclosing UIData component (i.e. h:dataTable or rich:*dataTable) not found for component " + (Object)((Object)allRowsSelector) + ". The allRowsSelector component must either be within a UIData component or must specify the id of a UIData component within its naming scope via the 'dataTableId' attribute.");
            }
        }
        return data;
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        this.validateParameters(context, component);
        ResponseWriter writer = context.getResponseWriter();
        writer.endElement("input");
    }
}

