/*
 * Decompiled with CFR 0.152.
 */
package xdoclet.tagshandler;

import java.util.Properties;
import org.apache.commons.logging.Log;
import xdoclet.XDocletException;
import xdoclet.XDocletMessages;
import xdoclet.XDocletTagSupport;
import xdoclet.template.TemplateException;
import xdoclet.template.TemplateTagHandler;
import xdoclet.util.LogUtil;
import xdoclet.util.Translator;

public class TagDefTagsHandler
extends XDocletTagSupport {
    public String tagDef(Properties attributes) throws XDocletException {
        Log log = LogUtil.getLog(TagDefTagsHandler.class, "tagDef");
        String namespace = attributes.getProperty("namespace");
        String handlerFullClassName = attributes.getProperty("handler");
        if (log.isDebugEnabled()) {
            log.debug((Object)("namespace=" + namespace));
            log.debug((Object)("handler=" + handlerFullClassName));
        }
        if (namespace == null) {
            this.mandatoryTemplateTagParamNotFound("tagDef", "namespace");
        }
        if (handlerFullClassName == null) {
            this.mandatoryTemplateTagParamNotFound("tagDef", "handler");
        }
        Class<?> handlerClass = null;
        try {
            handlerClass = this.getClass().getClassLoader().loadClass(handlerFullClassName);
            Object handlerInstance = handlerClass.newInstance();
            this.getEngine().setTagHandlerFor(namespace, (TemplateTagHandler)handlerInstance);
        }
        catch (ClassNotFoundException e) {
            String msg = Translator.getString(XDocletMessages.class, "CLASS_NOT_FOUND", new String[]{handlerFullClassName});
            log.error((Object)msg, (Throwable)e);
            throw new XDocletException(e, msg);
        }
        catch (InstantiationException e) {
            String msg = Translator.getString(XDocletMessages.class, "TAGDEF_INSTANTIATION_EXCEPTION", new String[]{handlerClass.toString()});
            log.error((Object)msg, (Throwable)e);
            throw new XDocletException(e, msg);
        }
        catch (IllegalAccessException e) {
            String msg = Translator.getString(XDocletMessages.class, "TAGDEF_ILLEGALACCESS_EXCEPTION", new String[]{handlerClass.toString()});
            log.error((Object)msg, (Throwable)e);
            throw new XDocletException(e, msg);
        }
        catch (TemplateException e) {
            String msg = Translator.getString(XDocletMessages.class, "TAGDEF_COULDNT_DEF_HANDLER", new String[]{handlerFullClassName, namespace});
            log.error((Object)msg, (Throwable)e);
            throw new XDocletException(e, msg);
        }
        return "";
    }
}

