/*
 * Decompiled with CFR 0.152.
 */
package xdoclet.tagshandler;

import java.util.List;
import java.util.Properties;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import xdoclet.XDocletException;
import xdoclet.tagshandler.AbstractProgramElementTagsHandler;
import xdoclet.tagshandler.TypeTagsHandler;
import xdoclet.util.DocletUtil;
import xdoclet.util.LogUtil;
import xjavadoc.XClass;
import xjavadoc.XConstructor;
import xjavadoc.XMember;

public class ConstructorTagsHandler
extends AbstractProgramElementTagsHandler {
    public void setCurrentConstructor(String template, Properties attributes) throws XDocletException {
        String constructorName = attributes.getProperty("name");
        String parametersStr = attributes.getProperty("parameters");
        String delimiter = attributes.getProperty("delimiter");
        String[] parameters = null;
        if (parametersStr != null) {
            if (delimiter == null) {
                delimiter = ",";
            }
            parameters = DocletUtil.tokenizeDelimitedToArray(parametersStr, delimiter);
        }
        XConstructor oldConstructor = ConstructorTagsHandler.getCurrentConstructor();
        if (this.hasConstructor(ConstructorTagsHandler.getCurrentClass(), constructorName, parameters, true)) {
            this.generate(template);
        }
        ConstructorTagsHandler.setCurrentConstructor(oldConstructor);
    }

    public String constructorComment(Properties attributes) throws XDocletException {
        return this.memberComment(attributes, 3);
    }

    public String exceptionList(Properties attributes) throws XDocletException {
        return this.exceptionList(attributes, 3);
    }

    public void forAllClassConstructors(String template, Properties attributes) throws XDocletException {
        String typeName = attributes.getProperty("type");
        int extent = TypeTagsHandler.extractExtentType(attributes.getProperty("extent"));
        TreeSet constructors = new TreeSet();
        for (XClass clazz : ConstructorTagsHandler.getAllClasses()) {
            if (typeName != null && !TypeTagsHandler.isOfType(clazz, typeName, extent)) continue;
            List classConstructors = clazz.getConstructors();
            constructors.addAll(classConstructors);
        }
        for (XConstructor current : constructors) {
            ConstructorTagsHandler.setCurrentClass(current.getContainingClass());
            ConstructorTagsHandler.setCurrentConstructor(current);
            this.generate(template);
        }
    }

    public void forAllConstructors(String template, Properties attributes) throws XDocletException {
        this.forAllMembers(template, attributes, 3);
    }

    public void ifDoesntHaveConstructorTag(String template, Properties attributes) throws XDocletException {
        if (!ConstructorTagsHandler.hasTag(attributes, 3)) {
            this.generate(template);
        } else {
            String error = attributes.getProperty("error");
            if (error != null) {
                this.getEngine().print(error);
            }
        }
    }

    public void ifHasConstructorTag(String template, Properties attributes) throws XDocletException {
        if (ConstructorTagsHandler.hasTag(attributes, 3)) {
            this.generate(template);
        } else {
            String error = attributes.getProperty("error");
            if (error != null) {
                this.getEngine().print(error);
            }
        }
    }

    public void executeAndRestoreConstructor(String template, Properties attributes) throws XDocletException {
        XConstructor constructor = ConstructorTagsHandler.getCurrentConstructor();
        this.generate(template);
        ConstructorTagsHandler.setCurrentConstructor(constructor);
    }

    public void ifConstructorTagValueEquals(String template, Properties attributes) throws XDocletException {
        if (ConstructorTagsHandler.isTagValueEqual(attributes, 3)) {
            this.generate(template);
        }
    }

    public void ifConstructorTagValueNotEquals(String template, Properties attributes) throws XDocletException {
        if (!ConstructorTagsHandler.isTagValueEqual(attributes, 3)) {
            this.generate(template);
        }
    }

    public String constructorTagValue(Properties attributes) throws XDocletException {
        return ConstructorTagsHandler.getExpandedDelimitedTagValue(attributes, 3);
    }

    public void forAllConstructorTags(String template, Properties attributes) throws XDocletException {
        this.forAllMemberTags(template, attributes, 3, "ONLY_CALL_CONSTRUCTOR_NOT_NULL", new String[]{"forAllConstructorTags"});
    }

    public void forAllConstructorTagTokens(String template, Properties attributes) throws XDocletException {
        this.forAllMemberTagTokens(template, attributes, 3);
    }

    public String firstSentenceDescriptionOfCurrentConstructor() throws XDocletException {
        return this.firstSentenceDescriptionOfCurrentMember((XMember)ConstructorTagsHandler.getCurrentConstructor());
    }

    public String modifiers() throws XDocletException {
        return this.modifiers(3);
    }

    public String constructorName(Properties attributes) throws XDocletException {
        String value;
        if (attributes != null && (value = (String)attributes.get("value")) != null) {
            String m = ConstructorTagsHandler.getCurrentConstructor().getName().substring(Integer.parseInt(value));
            char firstU = m.charAt(0);
            char firstL = Character.toLowerCase(firstU);
            return firstL + m.substring(1);
        }
        return ConstructorTagsHandler.getCurrentConstructor() != null ? ConstructorTagsHandler.getCurrentConstructor().getName() : "";
    }

    public String currentConstructorName() throws XDocletException {
        return ConstructorTagsHandler.getCurrentConstructor().getName();
    }

    public void ifHasConstructor(String template, Properties attributes) throws XDocletException {
        this.ifHasConstructor_Impl(template, attributes, true);
    }

    public void ifDoesntHaveConstructor(String template, Properties attributes) throws XDocletException {
        this.ifHasConstructor_Impl(template, attributes, false);
    }

    private boolean hasConstructor(XClass clazz, String constructorName, String[] parameters, boolean setCurrentConstructor) throws XDocletException {
        return ConstructorTagsHandler.hasExecutableMember(clazz, constructorName, parameters, setCurrentConstructor, 3);
    }

    private void ifHasConstructor_Impl(String template, Properties attributes, boolean hasConstructor) throws XDocletException {
        Log log = LogUtil.getLog(ConstructorTagsHandler.class, "ifHasConstructor_Impl");
        String constructorName = attributes.getProperty("name");
        String parametersStr = attributes.getProperty("parameters");
        String delimiter = attributes.getProperty("delimiter");
        String[] parameters = null;
        if (log.isDebugEnabled()) {
            log.debug((Object)("constructorName=" + constructorName));
            log.debug((Object)("parametersStr=" + parametersStr));
            log.debug((Object)("delimiter=" + delimiter));
            log.debug((Object)("hasConstructor=" + hasConstructor));
            log.debug((Object)("getCurrentClass()=" + ConstructorTagsHandler.getCurrentClass()));
        }
        if (parametersStr != null) {
            if (delimiter == null) {
                delimiter = ",";
            }
            parameters = DocletUtil.tokenizeDelimitedToArray(parametersStr, delimiter);
            if (log.isDebugEnabled()) {
                log.debug((Object)("parameters.length=" + parameters.length));
                log.debug((Object)("parameters[0]=" + parameters[0]));
            }
        }
        if (this.hasConstructor(ConstructorTagsHandler.getCurrentClass(), constructorName, parameters, false) == hasConstructor) {
            log.debug((Object)"constructor found.");
            this.generate(template);
        } else {
            log.debug((Object)"constructor not found.");
        }
    }
}

