/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.persist.impl;

import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.persist.impl.Catalog;
import com.sleepycat.persist.impl.EntityInput;
import com.sleepycat.persist.impl.EntityOutput;
import com.sleepycat.persist.impl.Format;
import com.sleepycat.persist.impl.KeyLocation;
import com.sleepycat.persist.raw.RawObject;
import com.sleepycat.persist.raw.RawType;
import java.lang.reflect.Array;
import java.util.Map;
import java.util.Set;

public class ObjectArrayFormat
extends Format {
    private static final long serialVersionUID = 4317004346690441892L;
    private Format componentFormat;
    private int nDimensions;

    ObjectArrayFormat(Class type) {
        super(type);
        String name = this.getClassName();
        this.nDimensions = 0;
        while (name.charAt(this.nDimensions) == '[') {
            ++this.nDimensions;
        }
    }

    @Override
    public boolean isArray() {
        return true;
    }

    @Override
    public int getDimensions() {
        return this.nDimensions;
    }

    @Override
    public Format getComponentType() {
        return this.componentFormat;
    }

    @Override
    void collectRelatedFormats(Catalog catalog, Map<String, Format> newFormats) {
        Class<?> cls = this.getType().getComponentType();
        this.componentFormat = catalog.createFormat(cls, newFormats);
    }

    @Override
    void initialize(Catalog catalog) {
    }

    @Override
    boolean isAssignableTo(Format format) {
        if (super.isAssignableTo(format)) {
            return true;
        }
        if (format instanceof ObjectArrayFormat) {
            ObjectArrayFormat other = (ObjectArrayFormat)format;
            if (this.componentFormat.isAssignableTo(other.componentFormat)) {
                return true;
            }
        }
        return false;
    }

    @Override
    Object newArray(int len) {
        return Array.newInstance(this.getType(), len);
    }

    @Override
    Object newInstance(EntityInput input, boolean rawAccess) {
        int len = input.readPackedInt();
        if (rawAccess) {
            return new RawObject((RawType)this, new Object[len]);
        }
        return this.componentFormat.newArray(len);
    }

    @Override
    void writeObject(Object o, EntityOutput output, boolean rawAccess) {
        Object[] a = rawAccess ? ((RawObject)o).getElements() : (Object[])o;
        output.writePackedInt(a.length);
        for (int i = 0; i < a.length; ++i) {
            output.writeObject(a[i], this.componentFormat);
        }
    }

    @Override
    void readObject(Object o, EntityInput input, boolean rawAccess) {
        Object[] a = rawAccess ? ((RawObject)o).getElements() : (Object[])o;
        for (int i = 0; i < a.length; ++i) {
            a[i] = input.readObject();
        }
    }

    @Override
    void skipContents(EntityInput input) {
        int len = input.readPackedInt();
        for (int i = 0; i < len; ++i) {
            input.skipField(this.componentFormat);
        }
    }

    @Override
    void copySecMultiKey(EntityInput input, Format keyFormat, Set results) {
        int len = input.readPackedInt();
        for (int i = 0; i < len; ++i) {
            KeyLocation loc = input.getKeyLocation(this.componentFormat);
            if (loc == null) {
                throw new IllegalArgumentException("Secondary key values in array may not be null");
            }
            if (loc.format != this.componentFormat) {
                throw new IllegalStateException(this.componentFormat.getClassName());
            }
            int off1 = loc.input.getBufferOffset();
            this.componentFormat.skipContents(loc.input);
            int off2 = loc.input.getBufferOffset();
            DatabaseEntry entry = new DatabaseEntry(loc.input.getBufferBytes(), off1, off2 - off1);
            results.add(entry);
        }
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof ObjectArrayFormat) {
            ObjectArrayFormat o = (ObjectArrayFormat)other;
            return super.equals(o);
        }
        return false;
    }
}

