/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.jms.server.recovery;

import java.util.Arrays;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.hornetq.api.core.DiscoveryGroupConfiguration;
import org.hornetq.api.core.HornetQException;
import org.hornetq.api.core.TransportConfiguration;
import org.hornetq.api.core.client.ClientSession;
import org.hornetq.api.core.client.ClientSessionFactory;
import org.hornetq.api.core.client.HornetQClient;
import org.hornetq.api.core.client.ServerLocator;
import org.hornetq.api.core.client.SessionFailureListener;
import org.hornetq.core.logging.Logger;
import org.hornetq.jms.server.recovery.XARecoveryConfig;

public class HornetQXAResourceWrapper
implements XAResource,
SessionFailureListener {
    private static final Logger log = Logger.getLogger(HornetQXAResourceWrapper.class);
    private static final Object lock = new Object();
    private ServerLocator serverLocator;
    private ClientSessionFactory csf;
    private ClientSession delegate;
    private XARecoveryConfig[] xaRecoveryConfigs;

    public HornetQXAResourceWrapper(XARecoveryConfig ... xaRecoveryConfigs) {
        this.xaRecoveryConfigs = xaRecoveryConfigs;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Recovery configured with " + Arrays.toString(xaRecoveryConfigs) + ", instance=" + System.identityHashCode(this)));
        }
    }

    @Override
    public Xid[] recover(int flag) throws XAException {
        XAResource xaResource = this.getDelegate(false);
        if (log.isDebugEnabled()) {
            log.debug((Object)("looking for recover at " + xaResource + " configuration " + Arrays.toString(this.xaRecoveryConfigs)));
        }
        try {
            Object[] xids = xaResource.recover(flag);
            if (log.isDebugEnabled() && xids != null && xids.length > 0) {
                log.debug((Object)("Recovering these following IDs " + Arrays.toString(xids) + " at " + this));
            }
            return xids;
        }
        catch (XAException e) {
            log.warn((Object)e.getMessage(), (Throwable)e);
            throw this.check(e);
        }
    }

    @Override
    public void commit(Xid xid, boolean onePhase) throws XAException {
        XAResource xaResource = this.getDelegate(true);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Commit " + xaResource + " xid " + " onePhase=" + onePhase));
        }
        try {
            xaResource.commit(xid, onePhase);
        }
        catch (XAException e) {
            throw this.check(e);
        }
    }

    @Override
    public void rollback(Xid xid) throws XAException {
        XAResource xaResource = this.getDelegate(true);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Rollback " + xaResource + " xid "));
        }
        try {
            xaResource.rollback(xid);
        }
        catch (XAException e) {
            throw this.check(e);
        }
    }

    @Override
    public void forget(Xid xid) throws XAException {
        XAResource xaResource = this.getDelegate(false);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Forget " + xaResource + " xid "));
        }
        try {
            xaResource.forget(xid);
        }
        catch (XAException e) {
            throw this.check(e);
        }
    }

    @Override
    public boolean isSameRM(XAResource xaRes) throws XAException {
        if (xaRes instanceof HornetQXAResourceWrapper) {
            xaRes = ((HornetQXAResourceWrapper)xaRes).getDelegate(false);
        }
        XAResource xaResource = this.getDelegate(false);
        try {
            return xaResource.isSameRM(xaRes);
        }
        catch (XAException e) {
            throw this.check(e);
        }
    }

    @Override
    public int prepare(Xid xid) throws XAException {
        XAResource xaResource = this.getDelegate(true);
        if (log.isDebugEnabled()) {
            log.debug((Object)("prepare " + xaResource + " xid "));
        }
        try {
            return xaResource.prepare(xid);
        }
        catch (XAException e) {
            throw this.check(e);
        }
    }

    @Override
    public void start(Xid xid, int flags) throws XAException {
        XAResource xaResource = this.getDelegate(false);
        if (log.isDebugEnabled()) {
            log.debug((Object)("start " + xaResource + " xid "));
        }
        try {
            xaResource.start(xid, flags);
        }
        catch (XAException e) {
            throw this.check(e);
        }
    }

    @Override
    public void end(Xid xid, int flags) throws XAException {
        XAResource xaResource = this.getDelegate(false);
        if (log.isDebugEnabled()) {
            log.debug((Object)("end " + xaResource + " xid "));
        }
        try {
            xaResource.end(xid, flags);
        }
        catch (XAException e) {
            throw this.check(e);
        }
    }

    @Override
    public int getTransactionTimeout() throws XAException {
        XAResource xaResource = this.getDelegate(false);
        if (log.isDebugEnabled()) {
            log.debug((Object)("getTransactionTimeout " + xaResource + " xid "));
        }
        try {
            return xaResource.getTransactionTimeout();
        }
        catch (XAException e) {
            throw this.check(e);
        }
    }

    @Override
    public boolean setTransactionTimeout(int seconds) throws XAException {
        XAResource xaResource = this.getDelegate(false);
        if (log.isDebugEnabled()) {
            log.debug((Object)("setTransactionTimeout " + xaResource + " xid "));
        }
        try {
            return xaResource.setTransactionTimeout(seconds);
        }
        catch (XAException e) {
            throw this.check(e);
        }
    }

    public void connectionFailed(HornetQException me, boolean failedOver) {
        if (me.getCode() == 4) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"being disconnected for server shutdown", (Throwable)me);
            }
        } else {
            log.warn((Object)("Notified of connection failure in xa recovery connectionFactory for provider " + this.csf + " will attempt reconnect on next pass"), (Throwable)me);
        }
        this.close();
    }

    public void beforeReconnect(HornetQException me) {
    }

    public XAResource getDelegate(boolean retry) throws XAException {
        XAResource result = null;
        Exception error = null;
        try {
            result = this.connect();
        }
        catch (Exception e) {
            error = e;
        }
        if (result == null) {
            if (retry) {
                XAException xae = new XAException("Connection unavailable for xa recovery");
                xae.errorCode = 4;
                if (error != null) {
                    xae.initCause(error);
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Cannot get connectionFactory XAResource", (Throwable)xae);
                }
                throw xae;
            }
            XAException xae = new XAException("Error trying to connect to any providers for xa recovery");
            xae.errorCode = -3;
            if (error != null) {
                xae.initCause(error);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)"Cannot get connectionFactory XAResource", (Throwable)xae);
            }
            throw xae;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected XAResource connect() throws Exception {
        Object object = lock;
        synchronized (object) {
            if (this.delegate != null) {
                return this.delegate;
            }
        }
        for (XARecoveryConfig xaRecoveryConfig : this.xaRecoveryConfigs) {
            if (xaRecoveryConfig == null) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Trying to connect recovery on " + xaRecoveryConfig + " of " + Arrays.toString(this.xaRecoveryConfigs)));
            }
            ClientSession cs = null;
            try {
                this.serverLocator = xaRecoveryConfig.getDiscoveryConfiguration() != null ? HornetQClient.createServerLocator((boolean)false, (DiscoveryGroupConfiguration)xaRecoveryConfig.getDiscoveryConfiguration()) : HornetQClient.createServerLocator((boolean)false, (TransportConfiguration[])xaRecoveryConfig.getTransportConfig());
                this.serverLocator.disableFinalizeCheck();
                this.csf = this.serverLocator.createSessionFactory();
                cs = xaRecoveryConfig.getUsername() == null ? this.csf.createSession(true, false, false) : this.csf.createSession(xaRecoveryConfig.getUsername(), xaRecoveryConfig.getPassword(), true, false, false, false, 1);
            }
            catch (Throwable e) {
                log.warn((Object)("Can't connect to " + xaRecoveryConfig + " on auto-generated resource recovery"), e);
                if (log.isDebugEnabled()) {
                    log.debug((Object)e.getMessage(), e);
                }
                try {
                    if (cs != null) {
                        cs.close();
                    }
                    if (this.serverLocator == null) continue;
                    this.serverLocator.close();
                }
                catch (Throwable ignored) {
                    if (!log.isTraceEnabled()) continue;
                    log.trace((Object)e.getMessage(), ignored);
                }
                continue;
            }
            cs.addFailureListener((SessionFailureListener)this);
            Object object2 = lock;
            synchronized (object2) {
                this.delegate = cs;
            }
            return this.delegate;
        }
        log.warn((Object)("Can't connect to any hornetq server on recovery " + Arrays.toString(this.xaRecoveryConfigs)));
        throw new HornetQException(2);
    }

    public String toString() {
        return "HornetQXAResourceWrapper [serverLocator=" + this.serverLocator + ", csf=" + this.csf + ", delegate=" + this.delegate + ", xaRecoveryConfigs=" + Arrays.toString(this.xaRecoveryConfigs) + ", instance=" + System.identityHashCode(this) + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        ServerLocator oldServerLocator = null;
        ClientSessionFactory oldCSF = null;
        ClientSession oldDelegate = null;
        Object object = lock;
        synchronized (object) {
            oldCSF = this.csf;
            this.csf = null;
            oldDelegate = this.delegate;
            this.delegate = null;
            oldServerLocator = this.serverLocator;
            this.serverLocator = null;
        }
        if (oldDelegate != null) {
            try {
                oldDelegate.close();
            }
            catch (Throwable ignorable) {
                log.debug((Object)ignorable.getMessage(), ignorable);
            }
        }
        if (oldCSF != null) {
            try {
                oldCSF.close();
            }
            catch (Throwable ignorable) {
                log.debug((Object)ignorable.getMessage(), ignorable);
            }
        }
        if (oldServerLocator != null) {
            try {
                oldServerLocator.close();
            }
            catch (Throwable ignorable) {
                log.debug((Object)ignorable.getMessage(), ignorable);
            }
        }
    }

    protected XAException check(XAException e) throws XAException {
        log.warn((Object)e.getMessage(), (Throwable)e);
        this.close();
        throw e;
    }

    protected void finalize() throws Throwable {
        this.close();
    }
}

