/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.jms.server.recovery;

import java.util.concurrent.atomic.AtomicBoolean;
import org.hornetq.jms.server.recovery.HornetQRecoveryRegistry;
import org.hornetq.jms.server.recovery.XARecoveryConfig;
import org.jboss.tm.XAResourceRecovery;
import org.jboss.tm.XAResourceRecoveryRegistry;

public abstract class HornetQRegistryBase {
    private final AtomicBoolean started = new AtomicBoolean(false);

    public abstract XAResourceRecoveryRegistry getTMRegistry();

    public void register(XARecoveryConfig resourceConfig) {
        this.init();
        HornetQRecoveryRegistry.getInstance().register(resourceConfig);
    }

    public void unRegister(XARecoveryConfig resourceConfig) {
        this.init();
        HornetQRecoveryRegistry.getInstance().unRegister(resourceConfig);
    }

    private void init() {
        if (this.started.compareAndSet(false, true) && this.getTMRegistry() != null) {
            this.getTMRegistry().addXAResourceRecovery((XAResourceRecovery)HornetQRecoveryRegistry.getInstance());
        }
    }
}

