/*
 * Decompiled with CFR 0.152.
 */
package hidden.org.apache.webdav.lib;

import hidden.org.apache.webdav.lib.Property;
import hidden.org.apache.webdav.lib.ResponseEntity;
import hidden.org.apache.webdav.lib.util.DOMUtils;
import hidden.org.apache.webdav.lib.util.PropertyWriter;
import hidden.org.jdom.Element;
import hidden.org.jdom.input.DOMBuilder;
import hidden.org.jdom.output.Format;
import hidden.org.jdom.output.XMLOutputter;
import java.io.StringWriter;
import java.util.List;

public class BaseProperty
implements Property {
    protected ResponseEntity response;
    protected org.w3c.dom.Element element;

    public BaseProperty(ResponseEntity response, org.w3c.dom.Element element) {
        this.element = element;
        this.response = response;
    }

    public String getName() {
        return this.element.getTagName();
    }

    public String getLocalName() {
        return DOMUtils.getElementLocalName(this.element);
    }

    public String getNamespaceURI() {
        return DOMUtils.getElementNamespaceURI(this.element);
    }

    public org.w3c.dom.Element getElement() {
        return this.element;
    }

    public String getPropertyAsString() {
        StringBuffer text = new StringBuffer();
        DOMBuilder builder = new DOMBuilder();
        XMLOutputter outputter = new XMLOutputter(Format.getPrettyFormat());
        Element e = builder.build(this.element);
        List children = e.getChildren();
        if (children.size() > 0) {
            text.append(outputter.outputString(children));
        }
        text.append(e.getTextTrim());
        return text.toString();
    }

    public int getStatusCode() {
        org.w3c.dom.Element status = DOMUtils.getFirstElement(this.element.getParentNode().getParentNode(), "DAV:", "status");
        if (status != null) {
            return DOMUtils.parseStatus(DOMUtils.getTextValue(status));
        }
        return this.response.getStatusCode();
    }

    public String getOwningURL() {
        return this.response.getHref();
    }

    public String toString() {
        StringWriter tmp = new StringWriter();
        PropertyWriter propertyWriter = new PropertyWriter(tmp, true);
        propertyWriter.print(this.element);
        return tmp.getBuffer().toString();
    }
}

