/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.hibernate.dialect.Dialect;
import org.hibernate.type.DiscriminatorType;
import org.hibernate.type.PrimitiveType;

public class BooleanType
extends PrimitiveType
implements DiscriminatorType {
    @Override
    public Serializable getDefaultValue() {
        return Boolean.FALSE;
    }

    @Override
    public Object get(ResultSet rs, String name) throws SQLException {
        return rs.getBoolean(name) ? Boolean.TRUE : Boolean.FALSE;
    }

    @Override
    public Class getPrimitiveClass() {
        return Boolean.TYPE;
    }

    @Override
    public Class getReturnedClass() {
        return Boolean.class;
    }

    @Override
    public void set(PreparedStatement st, Object value, int index) throws SQLException {
        st.setBoolean(index, (Boolean)value);
    }

    @Override
    public int sqlType() {
        return -7;
    }

    @Override
    public String getName() {
        return "boolean";
    }

    @Override
    public String objectToSQLString(Object value, Dialect dialect) throws Exception {
        return dialect.toBooleanValueString((Boolean)value);
    }

    @Override
    public Object stringToObject(String xml) throws Exception {
        return this.fromStringValue(xml);
    }

    @Override
    public Object fromStringValue(String xml) {
        return Boolean.valueOf(xml);
    }
}

