/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.entity;

import java.util.Collections;
import java.util.Map;
import org.hibernate.FetchMode;
import org.hibernate.LockMode;
import org.hibernate.MappingException;
import org.hibernate.engine.CascadeStyle;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.loader.AbstractEntityJoinWalker;
import org.hibernate.persister.entity.OuterJoinLoadable;
import org.hibernate.type.AssociationType;

public class EntityJoinWalker
extends AbstractEntityJoinWalker {
    private final LockMode lockMode;

    public EntityJoinWalker(OuterJoinLoadable persister, String[] uniqueKey, int batchSize, LockMode lockMode, SessionFactoryImplementor factory, Map enabledFilters) throws MappingException {
        super(persister, factory, enabledFilters);
        this.lockMode = lockMode;
        StringBuffer whereCondition = this.whereString(this.getAlias(), uniqueKey, batchSize).append(persister.filterFragment(this.getAlias(), Collections.EMPTY_MAP));
        this.initAll(whereCondition.toString(), "", lockMode);
    }

    @Override
    protected boolean isJoinedFetchEnabled(AssociationType type, FetchMode config, CascadeStyle cascadeStyle) {
        return this.lockMode.greaterThan(LockMode.READ) ? false : super.isJoinedFetchEnabled(type, config, cascadeStyle);
    }

    @Override
    public String getComment() {
        return "load " + this.getPersister().getEntityName();
    }
}

