/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.context;

import java.util.HashMap;
import java.util.Map;
import org.hibernate.HibernateException;
import org.hibernate.SessionFactory;
import org.hibernate.classic.Session;
import org.hibernate.context.CurrentSessionContext;
import org.hibernate.engine.SessionFactoryImplementor;

public class ManagedSessionContext
implements CurrentSessionContext {
    private static final ThreadLocal context = new ThreadLocal();
    private final SessionFactoryImplementor factory;

    public ManagedSessionContext(SessionFactoryImplementor factory) {
        this.factory = factory;
    }

    @Override
    public Session currentSession() {
        Session current = ManagedSessionContext.existingSession(this.factory);
        if (current == null) {
            throw new HibernateException("No session currently bound to execution context");
        }
        return current;
    }

    public static boolean hasBind(SessionFactory factory) {
        return ManagedSessionContext.existingSession(factory) != null;
    }

    public static Session bind(Session session) {
        return ManagedSessionContext.sessionMap(true).put(session.getSessionFactory(), session);
    }

    public static Session unbind(SessionFactory factory) {
        Session existing = null;
        Map sessionMap = ManagedSessionContext.sessionMap();
        if (sessionMap != null) {
            existing = (Session)sessionMap.remove(factory);
            ManagedSessionContext.doCleanup();
        }
        return existing;
    }

    private static Session existingSession(SessionFactory factory) {
        Map sessionMap = ManagedSessionContext.sessionMap();
        if (sessionMap == null) {
            return null;
        }
        return (Session)sessionMap.get(factory);
    }

    protected static Map sessionMap() {
        return ManagedSessionContext.sessionMap(false);
    }

    private static synchronized Map sessionMap(boolean createMap) {
        HashMap sessionMap = (HashMap)context.get();
        if (sessionMap == null && createMap) {
            sessionMap = new HashMap();
            context.set(sessionMap);
        }
        return sessionMap;
    }

    private static synchronized void doCleanup() {
        Map sessionMap = ManagedSessionContext.sessionMap(false);
        if (sessionMap != null && sessionMap.isEmpty()) {
            context.set(null);
        }
    }
}

