/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache;

import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.CacheProvider;
import org.hibernate.util.NamingHelper;
import org.hibernate.util.StringHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractJndiBoundCacheProvider
implements CacheProvider {
    private static final Logger log = LoggerFactory.getLogger(AbstractJndiBoundCacheProvider.class);
    private Object cache;

    protected void prepare(Properties properties) {
    }

    protected void release() {
    }

    @Override
    public final void start(Properties properties) throws CacheException {
        String jndiNamespace = properties.getProperty("hibernate.cache.jndi");
        if (StringHelper.isEmpty(jndiNamespace)) {
            throw new CacheException("No JNDI namespace specified for cache");
        }
        this.cache = this.locateCache(jndiNamespace, NamingHelper.getJndiProperties(properties));
        this.prepare(properties);
    }

    @Override
    public final void stop() {
        this.release();
        this.cache = null;
    }

    private Object locateCache(String jndiNamespace, Properties jndiProperties) {
        InitialContext ctx = null;
        try {
            ctx = new InitialContext(jndiProperties);
            Object object = ctx.lookup(jndiNamespace);
            return object;
        }
        catch (NamingException ne) {
            String msg = "Unable to retreive Cache from JNDI [" + jndiNamespace + "]";
            log.info(msg, (Throwable)ne);
            throw new CacheException(msg);
        }
        finally {
            if (ctx != null) {
                try {
                    ctx.close();
                }
                catch (NamingException ne) {
                    log.info("Unable to release initial context", (Throwable)ne);
                }
            }
        }
    }

    public Object getCache() {
        return this.cache;
    }
}

