/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb;

import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.rmi.Remote;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.jacorb.config.Configuration;
import org.jacorb.config.ConfigurationException;
import org.jacorb.ir.RepositoryID;
import org.jacorb.orb.CDROutputStream;
import org.jacorb.orb.DataInputStream;
import org.jacorb.orb.EncapsInfo;
import org.jacorb.orb.IORMutator;
import org.jacorb.orb.ORB;
import org.jacorb.orb.ORBSingleton;
import org.jacorb.orb.ParsedIOR;
import org.jacorb.orb.TypeCode;
import org.jacorb.orb.giop.CodeSet;
import org.jacorb.orb.giop.GIOPConnection;
import org.jacorb.util.ObjectUtil;
import org.jacorb.util.Stack;
import org.jacorb.util.ValueHandler;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.BAD_TYPECODE;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CORBA.Object;
import org.omg.CORBA.Principal;
import org.omg.CORBA.StringValueHelper;
import org.omg.CORBA.StructMember;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TCKind;
import org.omg.CORBA.TypeCodePackage.BadKind;
import org.omg.CORBA.TypeCodePackage.Bounds;
import org.omg.CORBA.UnionMember;
import org.omg.CORBA.ValueMember;
import org.omg.CORBA.WStringValueHelper;
import org.omg.CORBA.portable.BoxedValueHelper;
import org.omg.CORBA.portable.CustomValue;
import org.omg.CORBA.portable.IDLEntity;
import org.omg.CORBA.portable.IndirectionException;
import org.omg.CORBA.portable.ObjectImpl;
import org.omg.CORBA.portable.Streamable;
import org.omg.CORBA_2_3.portable.InputStream;
import org.omg.CORBA_2_3.portable.OutputStream;
import org.omg.IOP.IOR;
import org.omg.IOP.IORHelper;
import org.slf4j.Logger;

public class CDRInputStream
extends InputStream
implements CodeSet.InputBuffer {
    private Stack encaps_stack;
    private Map repeatedTCMap;
    private Map cachedTypecodes;
    private int marked_pos;
    private int marked_index;
    private boolean closed;
    private Logger logger;
    private boolean cometInteropFix;
    private boolean laxBooleanEncoding;
    private boolean cacheTypecodes;
    private CodeSet codeSet = CodeSet.getTCSDefault();
    private CodeSet codeSetW = CodeSet.getTCSWDefault();
    protected int giop_minor = 2;
    private Map valueMap;
    private int currentValueIndex;
    private Map repIdMap;
    private Map codebaseMap;
    public boolean littleEndian = false;
    protected byte[] buffer = null;
    protected int pos = 0;
    protected int index = 0;
    private boolean chunkedValue = false;
    private int valueNestingLevel = 0;
    private int chunk_end_pos = -1;
    private IORMutator mutator;
    private boolean isMutatorEnabled;
    private boolean codesetEnabled;
    private final org.omg.CORBA.ORB orb;
    private static final int MAX_BLOCK_SIZE = 0x7FFFFF00;
    private boolean sunInteropFix;
    private Map tcMap;

    public CDRInputStream(org.omg.CORBA.ORB oRB, byte[] byArray) {
        this.buffer = byArray;
        if (oRB != null) {
            this.orb = oRB;
            if (oRB instanceof ORB) {
                try {
                    this.configure(((ORB)oRB).getConfiguration());
                }
                catch (ConfigurationException configurationException) {
                    throw new INTERNAL("ConfigurationException: " + configurationException);
                }
            }
        } else {
            this.orb = org.omg.CORBA.ORB.init();
        }
    }

    public CDRInputStream(org.omg.CORBA.ORB oRB, byte[] byArray, boolean bl) {
        this(oRB, byArray);
        this.littleEndian = bl;
    }

    public CDRInputStream(byte[] byArray) {
        this(null, byArray);
    }

    public CDRInputStream(byte[] byArray, boolean bl) {
        this(null, byArray, bl);
    }

    private void configure(Configuration configuration) throws ConfigurationException {
        Configuration configuration2 = configuration;
        this.logger = configuration2.getLogger("jacorb.orb.cdr");
        this.codesetEnabled = configuration.getAttribute("jacorb.codeset", "on").equals("on");
        this.cometInteropFix = configuration.getAttribute("jacorb.interop.comet", "off").equals("on");
        this.laxBooleanEncoding = configuration.getAttribute("jacorb.interop.lax_boolean_encoding", "off").equals("on");
        this.cacheTypecodes = configuration.getAttribute("jacorb.cacheTypecodes", "off").equals("on");
        this.sunInteropFix = configuration.getAttribute("jacorb.interop.sun", "off").equalsIgnoreCase("on");
        boolean bl = this.isMutatorEnabled = configuration.getAttribute("jacorb.iormutator", "").length() > 0;
        if (this.isMutatorEnabled) {
            this.mutator = (IORMutator)configuration2.getAttributeAsObject("jacorb.iormutator");
        }
    }

    private Map getValueMap() {
        if (this.valueMap == null) {
            this.valueMap = new HashMap();
        }
        return this.valueMap;
    }

    private Map getRepIdMap() {
        if (this.repIdMap == null) {
            this.repIdMap = new HashMap();
        }
        return this.repIdMap;
    }

    private Map getCodebaseMap() {
        if (this.codebaseMap == null) {
            this.codebaseMap = new HashMap();
        }
        return this.codebaseMap;
    }

    private Pair getCachedTypecode(java.lang.Object object) {
        Pair pair;
        if (this.cacheTypecodes) {
            if (this.cachedTypecodes == null) {
                this.cachedTypecodes = new HashMap();
                pair = null;
            } else {
                pair = (Pair)this.cachedTypecodes.get(object);
            }
        } else {
            pair = null;
        }
        return pair;
    }

    private void putCachedTypecode(java.lang.Object object, Pair pair) {
        if (this.cacheTypecodes) {
            this.cachedTypecodes.put(object, pair);
        }
    }

    public void setGIOPMinor(int n) {
        this.giop_minor = n;
    }

    public int getGIOPMinor() {
        return this.giop_minor;
    }

    public void close() {
        if (this.closed) {
            return;
        }
        this.buffer = null;
        this.encaps_stack = null;
        this.closed = true;
        if (this.tcMap != null) {
            this.tcMap.clear();
        }
    }

    public org.omg.CORBA.ORB orb() {
        return this.orb;
    }

    public void setCodeSet(CodeSet codeSet, CodeSet codeSet2) {
        this.codeSet = codeSet;
        this.codeSetW = codeSet2;
    }

    private static final int _read4int(boolean bl, byte[] byArray, int n) {
        if (bl) {
            return ((byArray[n + 3] & 0xFF) << 24) + ((byArray[n + 2] & 0xFF) << 16) + ((byArray[n + 1] & 0xFF) << 8) + ((byArray[n] & 0xFF) << 0);
        }
        return ((byArray[n] & 0xFF) << 24) + ((byArray[n + 1] & 0xFF) << 16) + ((byArray[n + 2] & 0xFF) << 8) + ((byArray[n + 3] & 0xFF) << 0);
    }

    private static final short _read2int(boolean bl, byte[] byArray, int n) {
        if (bl) {
            return (short)(((byArray[n + 1] & 0xFF) << 8) + ((byArray[n] & 0xFF) << 0));
        }
        return (short)(((byArray[n] & 0xFF) << 8) + ((byArray[n + 1] & 0xFF) << 0));
    }

    private final int _read_long() {
        int n = CDRInputStream._read4int(this.littleEndian, this.buffer, this.pos);
        this.index += 4;
        this.pos += 4;
        return n;
    }

    private final long _read_longlong() {
        if (this.littleEndian) {
            return ((long)this._read_long() & 0xFFFFFFFFL) + ((long)this._read_long() << 32);
        }
        return ((long)this._read_long() << 32) + ((long)this._read_long() & 0xFFFFFFFFL);
    }

    private final void handle_chunking() {
        int n;
        int n2 = 4 - this.index % 4;
        int n3 = n = n2 != 4 ? this.pos + n2 : this.pos;
        if (this.chunk_end_pos >= this.pos && this.chunk_end_pos <= n) {
            this.adjust_positions();
        }
    }

    private final void adjust_positions() {
        this.chunk_end_pos = -1;
        int n = this.pos;
        int n2 = this.index;
        int n3 = this.read_long();
        if (n3 < 0) {
            if (-n3 > this.valueNestingLevel) {
                throw new INTERNAL("received end tag " + n3 + " with value nesting level " + this.valueNestingLevel);
            }
            this.valueNestingLevel = -n3;
            --this.valueNestingLevel;
            if (this.valueNestingLevel > 0) {
                this.chunk_end_pos = this.pos;
                this.handle_chunking();
            }
        } else if (n3 > 0 && n3 < 0x7FFFFF00) {
            this.chunk_end_pos = this.pos + n3;
        } else {
            this.pos = n;
            this.index = n2;
        }
    }

    protected final void skip(int n) {
        this.pos += n;
        this.index += n;
    }

    public final void closeEncapsulation() {
        if (this.encaps_stack == null) {
            throw new MARSHAL("Internal Error - closeEncapsulation failed");
        }
        EncapsInfo encapsInfo = (EncapsInfo)this.encaps_stack.pop();
        this.littleEndian = encapsInfo.littleEndian;
        int n = encapsInfo.start;
        int n2 = encapsInfo.size;
        if (this.pos < n + n2) {
            this.pos = n + n2;
        }
        this.index = encapsInfo.index + n2;
    }

    public final int openEncapsulation() {
        boolean bl = this.littleEndian;
        int n = this.read_long();
        if (this.cometInteropFix && (n < 0 || n > this.buffer.length)) {
            int n2 = (n >> 24 & 0xFF) + (n >> 8 & 0xFF00) + (n << 8 & 0xFF0000) + (n << 24 & 0xFF000000);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Size of CDR encapsulation larger than buffer, swapping byte order\nSize of CDR encapsulation was " + n + ", is now " + n2);
            }
            n = n2;
        }
        if (this.encaps_stack == null) {
            this.encaps_stack = new Stack();
        }
        this.encaps_stack.push(new EncapsInfo(bl, this.index, this.pos, n));
        this.openEncapsulatedArray();
        return n;
    }

    public final void openEncapsulatedArray() {
        this.resetIndex();
        this.littleEndian = this.read_boolean();
    }

    public byte[] getBufferCopy() {
        byte[] byArray = new byte[this.buffer.length];
        System.arraycopy(this.buffer, 0, byArray, 0, this.buffer.length);
        return byArray;
    }

    public int read() throws IOException {
        if (this.closed) {
            throw new IOException("Stream already closed!");
        }
        if (this.available() < 1) {
            return -1;
        }
        ++this.index;
        return this.buffer[this.pos++];
    }

    public int available() {
        return this.buffer.length - this.index;
    }

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (byArray == null) {
            throw new IOException("buffer may not be null");
        }
        if (n < 0 || n2 < 0 || n + n2 > byArray.length) {
            throw new IOException("buffer index out of bounds");
        }
        if (n2 == 0) {
            return 0;
        }
        if (this.available() < 1) {
            return -1;
        }
        if (this.closed) {
            throw new IOException("Stream already closed!");
        }
        int n3 = Math.min(n2, this.available());
        System.arraycopy(this.buffer, this.index, byArray, n, n3);
        this.pos += n3;
        this.index += n3;
        return n3;
    }

    public final Any read_any() {
        org.omg.CORBA.TypeCode typeCode = this.read_TypeCode();
        Any any = this.orb.create_any();
        any.read_value(this, typeCode);
        return any;
    }

    public final boolean read_boolean() {
        byte by;
        if (this.chunk_end_pos == this.pos) {
            this.adjust_positions();
        }
        ++this.index;
        if ((by = this.buffer[this.pos++]) == 0) {
            return false;
        }
        if (by == 1) {
            return true;
        }
        if (this.laxBooleanEncoding) {
            return true;
        }
        throw new MARSHAL("Unexpected boolean value: " + by + " pos: " + this.pos + " index: " + this.index);
    }

    public final void read_boolean_array(boolean[] blArray, int n, int n2) {
        this.handle_chunking();
        for (int i = n; i < n + n2; ++i) {
            byte by;
            ++this.index;
            if ((by = this.buffer[this.pos++]) == 1) {
                blArray[i] = true;
                continue;
            }
            if (by == 0) {
                blArray[i] = false;
                continue;
            }
            throw new MARSHAL("Unexpected boolean value: " + by + " pos: " + this.pos + " index: " + this.index);
        }
    }

    public final char read_char() {
        this.handle_chunking();
        ++this.index;
        return (char)(this.buffer[this.pos++] & 0xFF);
    }

    public final void read_char_array(char[] cArray, int n, int n2) {
        if (cArray == null) {
            throw new MARSHAL("Cannot marshall result into null array.");
        }
        if (n + n2 > cArray.length || n2 < 0 || n < 0) {
            throw new MARSHAL("Cannot marshall as indices for array are out bounds.");
        }
        this.handle_chunking();
        for (int i = n; i < n + n2; ++i) {
            ++this.index;
            cArray[i] = (char)(0xFF & this.buffer[this.pos++]);
        }
    }

    public final double read_double() {
        return Double.longBitsToDouble(this.read_longlong());
    }

    public final void read_double_array(double[] dArray, int n, int n2) {
        if (n2 == 0) {
            return;
        }
        this.handle_chunking();
        int n3 = 8 - this.index % 8;
        if (n3 != 8) {
            this.index += n3;
            this.pos += n3;
        }
        for (int i = n; i < n + n2; ++i) {
            dArray[i] = Double.longBitsToDouble(this._read_longlong());
        }
    }

    public BigDecimal read_fixed() {
        this.handle_chunking();
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.read_fixed_internal(stringBuffer, (short)-1);
        BigDecimal bigDecimal = new BigDecimal(new BigInteger(stringBuffer.toString()));
        return this.read_fixed_negate(n, bigDecimal);
    }

    public BigDecimal read_fixed(short s, short s2) {
        if (s < 1) {
            throw new BAD_PARAM("digits must be a positive value: " + s + ".");
        }
        if (s2 < 0) {
            throw new BAD_PARAM("scale must be a non-negative value: " + s2 + ".");
        }
        if (s2 > s) {
            throw new BAD_PARAM("scale factor " + s2 + " must be less than or equal to the total number of digits " + s + ".");
        }
        this.handle_chunking();
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.read_fixed_internal(stringBuffer, s);
        BigDecimal bigDecimal = new BigDecimal(new BigInteger(stringBuffer.toString()), s2);
        return this.read_fixed_negate(n, bigDecimal);
    }

    private BigDecimal read_fixed_negate(int n, BigDecimal bigDecimal) {
        if (n == 13) {
            return bigDecimal.negate();
        }
        return bigDecimal;
    }

    private int read_fixed_internal(StringBuffer stringBuffer, short s) {
        byte by = this.buffer[this.pos++];
        int n = by & 0xF;
        ++this.index;
        while (true) {
            n = (by & 0xF0) >>> 4;
            if (stringBuffer.length() > 0 || n != 0) {
                stringBuffer.append(n);
            }
            if ((n = by & 0xF) == 12 || n == 13) break;
            stringBuffer.append(n);
            by = this.buffer[this.pos++];
            ++this.index;
        }
        if (s != -1 && stringBuffer.length() != s) {
            throw new MARSHAL("unexpected number of digits: expected " + s + " got " + stringBuffer.length() + " " + stringBuffer);
        }
        return n;
    }

    public final float read_float() {
        return Float.intBitsToFloat(this.read_long());
    }

    public final void read_float_array(float[] fArray, int n, int n2) {
        if (n2 == 0) {
            return;
        }
        this.handle_chunking();
        int n3 = 4 - this.index % 4;
        if (n3 != 4) {
            this.index += n3;
            this.pos += n3;
        }
        for (int i = n; i < n + n2; ++i) {
            fArray[i] = Float.intBitsToFloat(this._read_long());
        }
    }

    public final int read_long() {
        this.handle_chunking();
        int n = 4 - this.index % 4;
        if (n != 4) {
            this.index += n;
            this.pos += n;
        }
        int n2 = CDRInputStream._read4int(this.littleEndian, this.buffer, this.pos);
        this.index += 4;
        this.pos += 4;
        return n2;
    }

    public final void read_long_array(int[] nArray, int n, int n2) {
        if (n2 == 0) {
            return;
        }
        this.handle_chunking();
        int n3 = 4 - this.index % 4;
        if (n3 != 4) {
            this.index += n3;
            this.pos += n3;
        }
        for (int i = n; i < n + n2; ++i) {
            nArray[i] = CDRInputStream._read4int(this.littleEndian, this.buffer, this.pos);
            this.pos += 4;
        }
        this.index += 4 * n2;
    }

    public final long read_longlong() {
        this.handle_chunking();
        int n = 8 - this.index % 8;
        if (n != 8) {
            this.index += n;
            this.pos += n;
        }
        if (this.littleEndian) {
            return ((long)this._read_long() & 0xFFFFFFFFL) + ((long)this._read_long() << 32);
        }
        return ((long)this._read_long() << 32) + ((long)this._read_long() & 0xFFFFFFFFL);
    }

    public final void read_longlong_array(long[] lArray, int n, int n2) {
        if (n2 == 0) {
            return;
        }
        this.handle_chunking();
        int n3 = 8 - this.index % 8;
        if (n3 != 8) {
            this.index += n3;
            this.pos += n3;
        }
        if (this.littleEndian) {
            for (int i = n; i < n + n2; ++i) {
                lArray[i] = ((long)this._read_long() & 0xFFFFFFFFL) + ((long)this._read_long() << 32);
            }
        } else {
            for (int i = n; i < n + n2; ++i) {
                lArray[i] = ((long)this._read_long() << 32) + ((long)this._read_long() & 0xFFFFFFFFL);
            }
        }
    }

    public final Object read_Object() {
        ParsedIOR parsedIOR;
        if (!(this.orb instanceof ORB)) {
            throw new MARSHAL("Cannot use the singleton ORB to receive object references, please initialize a full ORB instead.");
        }
        this.handle_chunking();
        IOR iOR = IORHelper.read(this);
        if (this.isMutatorEnabled) {
            iOR = this.mutator.mutateIncoming(iOR);
        }
        if ((parsedIOR = new ParsedIOR((ORB)this.orb, iOR)).isNull()) {
            return null;
        }
        return ((ORB)this.orb)._getObject(parsedIOR);
    }

    public Object read_Object(Class clazz) {
        if (ObjectImpl.class.isAssignableFrom(clazz)) {
            Object object = this.read_Object();
            if (object instanceof ObjectImpl) {
                ObjectImpl objectImpl = null;
                try {
                    objectImpl = (ObjectImpl)clazz.newInstance();
                }
                catch (InstantiationException instantiationException) {
                    throw new MARSHAL("Exception in stub instantiation: " + instantiationException);
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new MARSHAL("Exception in stub instantiation: " + illegalAccessException);
                }
                objectImpl._set_delegate(((ObjectImpl)object)._get_delegate());
                return objectImpl;
            }
            return object;
        }
        if (clazz.isInterface() && Remote.class.isAssignableFrom(clazz)) {
            return (Object)ValueHandler.portableRemoteObject_narrow(this.read_Object(), clazz);
        }
        return this.read_Object();
    }

    public final byte read_octet() {
        this.handle_chunking();
        ++this.index;
        return this.buffer[this.pos++];
    }

    public final void read_octet_array(byte[] byArray, int n, int n2) {
        this.handle_chunking();
        System.arraycopy(this.buffer, this.pos, byArray, n, n2);
        this.index += n2;
        this.pos += n2;
    }

    public final Principal read_Principal() {
        throw new NO_IMPLEMENT("Principal deprecated");
    }

    public final short read_short() {
        this.handle_chunking();
        int n = 2 - this.index % 2;
        if (n != 2) {
            this.index += n;
            this.pos += n;
        }
        short s = CDRInputStream._read2int(this.littleEndian, this.buffer, this.pos);
        this.pos += 2;
        this.index += 2;
        return s;
    }

    public final void read_short_array(short[] sArray, int n, int n2) {
        if (n2 == 0) {
            return;
        }
        this.handle_chunking();
        int n3 = 2 - this.index % 2;
        if (n3 != 2) {
            this.index += n3;
            this.pos += n3;
        }
        for (int i = n; i < n + n2; ++i) {
            sArray[i] = CDRInputStream._read2int(this.littleEndian, this.buffer, this.pos);
            this.pos += 2;
        }
        this.index += n2 * 2;
    }

    public final String read_string() {
        int n;
        String string = null;
        this.handle_chunking();
        int n2 = 4 - this.index % 4;
        if (n2 != 4) {
            this.index += n2;
            this.pos += n2;
        }
        if ((n = CDRInputStream._read4int(this.littleEndian, this.buffer, this.pos)) < 1) {
            throw new MARSHAL("invalid string size: " + n);
        }
        int n3 = this.pos + 4;
        this.index += n + 4;
        this.pos += n + 4;
        int n4 = n3 + n - 1;
        if (this.buffer.length < n4 + 1) {
            throw new MARSHAL("buffer too small");
        }
        if (this.buffer[n4] != 0) {
            throw new MARSHAL("unexpected string terminator value " + Integer.toHexString(this.buffer[n4]) + " at buffer index " + n4);
        }
        if (--n == 0) {
            return "";
        }
        if (n3 + n > this.buffer.length) {
            String string2 = "Size (" + n + ") invalid for string extraction from buffer length of " + this.buffer.length + " from position " + n3;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(string2);
            }
            throw new MARSHAL(string2);
        }
        if (this.codesetEnabled) {
            try {
                string = new String(this.buffer, n3, n, this.codeSet.getName());
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                if (this.logger.isErrorEnabled()) {
                    this.logger.error("Charset " + this.codeSet.getName() + " is unsupported");
                    string = "";
                }
            }
        } else {
            char[] cArray = new char[n];
            for (int i = 0; i < n; ++i) {
                cArray[i] = (char)(0xFF & this.buffer[n3 + i]);
            }
            string = new String(cArray);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final org.omg.CORBA.TypeCode read_TypeCode() {
        if (this.tcMap == null) {
            this.tcMap = new TreeMap();
        }
        if (this.repeatedTCMap == null) {
            this.repeatedTCMap = new HashMap();
        }
        try {
            org.omg.CORBA.TypeCode typeCode = this.read_TypeCode(this.tcMap, this.repeatedTCMap);
            return typeCode;
        }
        finally {
            this.repeatedTCMap.clear();
        }
    }

    private final org.omg.CORBA.TypeCode read_TypeCode(Map map, Map map2) {
        org.omg.CORBA.TypeCode typeCode;
        int n = this.read_long();
        int n2 = this.pos - 4;
        Integer n3 = ObjectUtil.newInteger(n2);
        if (this.logger != null && this.logger.isDebugEnabled()) {
            this.logger.debug("Read Type code of kind " + n + " at pos: " + n2);
        }
        switch (n) {
            case -1: {
                int n4 = this.read_long();
                Integer n5 = ObjectUtil.newInteger(this.pos - 4 + n4);
                org.omg.CORBA.TypeCode typeCode2 = (org.omg.CORBA.TypeCode)map2.get(n5);
                if (typeCode2 != null) {
                    typeCode = typeCode2;
                    break;
                }
                String string = (String)map.get(n5);
                if (string != null) {
                    try {
                        typeCode = this.orb.create_recursive_tc(string);
                        break;
                    }
                    catch (SystemException systemException) {
                        throw new MARSHAL("Failed to create recursive typecode: " + systemException);
                    }
                }
                throw new MARSHAL("Found indirection marker, but no corresponding original typecode (pos: " + n5 + ")");
            }
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                typeCode = this.orb.get_primitive_tc(TCKind.from_int(n));
                break;
            }
            case 14: {
                int n6 = this.openEncapsulation();
                String string = this.validateID(this.read_string());
                Pair pair = this.getCachedTypecode(string);
                if (pair == null) {
                    String string2 = this.validateName(this.read_string());
                    typeCode = this.orb.create_interface_tc(string, string2);
                    this.putCachedTypecode(string, new Pair(typeCode, n3));
                } else {
                    int n7 = this.calcSkipAmount(n6, n2);
                    this.skip(n7);
                    typeCode = pair.typeCode;
                }
                this.closeEncapsulation();
                break;
            }
            case 15: {
                int n8 = this.openEncapsulation();
                String string = this.validateID(this.read_string());
                Pair pair = this.getCachedTypecode(string);
                if (pair == null) {
                    String string3 = this.validateName(this.read_string());
                    int n9 = this.read_long();
                    map.put(n3, string);
                    StructMember[] structMemberArray = new StructMember[n9];
                    for (int i = 0; i < n9; ++i) {
                        structMemberArray[i] = new StructMember(this.read_string(), this.read_TypeCode(map, map2), null);
                    }
                    typeCode = ((ORBSingleton)this.orb).create_struct_tc(string, string3, structMemberArray, false);
                    this.putCachedTypecode(string, new Pair(typeCode, n3));
                } else {
                    int n10 = this.calcSkipAmount(n8, n2);
                    this.updateTcMap(map, n2, n10, pair.position);
                    this.skip(n10);
                    map.put(n3, string);
                    typeCode = pair.typeCode;
                }
                this.closeEncapsulation();
                break;
            }
            case 16: {
                int n11 = this.openEncapsulation();
                String string = this.validateID(this.read_string());
                Pair pair = this.getCachedTypecode(string);
                if (pair == null) {
                    String string4 = this.validateName(this.read_string());
                    map.put(n3, string);
                    org.omg.CORBA.TypeCode typeCode3 = this.read_TypeCode(map, map2);
                    org.omg.CORBA.TypeCode typeCode4 = TypeCode.originalType(typeCode3);
                    int n12 = this.read_long();
                    int n13 = this.read_long();
                    UnionMember[] unionMemberArray = new UnionMember[n13];
                    for (int i = 0; i < n13; ++i) {
                        Any any = this.orb.create_any();
                        if (i == n12) {
                            any.insert_octet(this.read_octet());
                        } else {
                            any.read_value(this, typeCode4);
                        }
                        unionMemberArray[i] = new UnionMember(this.read_string(), any, this.read_TypeCode(map, map2), null);
                    }
                    typeCode = ((ORBSingleton)this.orb).create_union_tc(string, string4, typeCode3, unionMemberArray, false);
                    this.putCachedTypecode(string, new Pair(typeCode, n3));
                } else {
                    int n14 = this.calcSkipAmount(n11, n2);
                    this.updateTcMap(map, n2, n14, pair.position);
                    this.skip(n14);
                    map.put(n3, string);
                    typeCode = pair.typeCode;
                }
                this.closeEncapsulation();
                break;
            }
            case 17: {
                int n15 = this.openEncapsulation();
                String string = this.validateID(this.read_string());
                Pair pair = this.getCachedTypecode(string);
                if (pair == null) {
                    String string5 = this.validateName(this.read_string());
                    int n16 = this.read_long();
                    String[] stringArray = new String[n16];
                    for (int i = 0; i < n16; ++i) {
                        stringArray[i] = this.read_string();
                    }
                    typeCode = ((ORBSingleton)this.orb).create_enum_tc(string, string5, stringArray, false);
                    this.putCachedTypecode(string, new Pair(typeCode, n3));
                } else {
                    int n17 = this.calcSkipAmount(n15, n2);
                    this.skip(n17);
                    typeCode = pair.typeCode;
                }
                this.closeEncapsulation();
                break;
            }
            case 18: {
                typeCode = this.orb.create_string_tc(this.read_long());
                break;
            }
            case 19: {
                int n18 = this.openEncapsulation();
                org.omg.CORBA.TypeCode typeCode5 = this.read_TypeCode(map, map2);
                Pair pair = this.getCachedTypecode(typeCode5);
                if (pair == null) {
                    int n19 = this.read_long();
                    typeCode = this.orb.create_sequence_tc(n19, typeCode5);
                    this.putCachedTypecode(typeCode, new Pair(typeCode, n3));
                } else {
                    int n20 = this.calcSkipAmount(n18, n2);
                    this.skip(n20);
                    typeCode = pair.typeCode;
                }
                this.closeEncapsulation();
                break;
            }
            case 20: {
                int n21 = this.openEncapsulation();
                org.omg.CORBA.TypeCode typeCode6 = this.read_TypeCode(map, map2);
                Pair pair = this.getCachedTypecode(typeCode6);
                if (pair == null) {
                    typeCode = this.orb.create_array_tc(this.read_long(), typeCode6);
                    this.putCachedTypecode(typeCode, new Pair(typeCode, n3));
                } else {
                    int n22 = this.calcSkipAmount(n21, n2);
                    this.skip(n22);
                    typeCode = pair.typeCode;
                }
                this.closeEncapsulation();
                break;
            }
            case 21: {
                int n23 = this.openEncapsulation();
                String string = this.validateID(this.read_string());
                Pair pair = this.getCachedTypecode(string);
                if (pair == null) {
                    String string6 = this.validateName(this.read_string());
                    map.put(n3, string);
                    org.omg.CORBA.TypeCode typeCode7 = this.read_TypeCode(map, map2);
                    typeCode = this.orb.create_alias_tc(string, string6, typeCode7);
                    this.putCachedTypecode(string, new Pair(typeCode, n3));
                } else {
                    int n24 = this.calcSkipAmount(n23, n2);
                    this.updateTcMap(map, n2, n24, pair.position);
                    this.skip(n24);
                    map.put(n3, string);
                    typeCode = pair.typeCode;
                }
                this.closeEncapsulation();
                break;
            }
            case 22: {
                int n25 = this.openEncapsulation();
                String string = this.validateID(this.read_string());
                Pair pair = this.getCachedTypecode(string);
                if (pair == null) {
                    String string7 = this.validateName(this.read_string());
                    int n26 = this.read_long();
                    map.put(n3, string);
                    StructMember[] structMemberArray = new StructMember[n26];
                    for (int i = 0; i < n26; ++i) {
                        structMemberArray[i] = new StructMember(this.read_string(), this.read_TypeCode(map, map2), null);
                    }
                    typeCode = ((ORBSingleton)this.orb).create_exception_tc(string, string7, structMemberArray, false);
                    this.putCachedTypecode(string, new Pair(typeCode, n3));
                } else {
                    int n27 = this.calcSkipAmount(n25, n2);
                    this.updateTcMap(map, n2, n27, pair.position);
                    this.skip(n27);
                    map.put(n3, string);
                    typeCode = pair.typeCode;
                }
                this.closeEncapsulation();
                break;
            }
            case 23: 
            case 24: {
                typeCode = this.orb.get_primitive_tc(TCKind.from_int(n));
                break;
            }
            case 25: {
                throw new MARSHAL("Cannot handle TypeCode with kind " + n);
            }
            case 26: {
                typeCode = this.orb.get_primitive_tc(TCKind.from_int(n));
                break;
            }
            case 27: {
                typeCode = this.orb.create_wstring_tc(this.read_long());
                break;
            }
            case 28: {
                typeCode = this.orb.create_fixed_tc(this.read_ushort(), this.read_short());
                break;
            }
            case 29: {
                int n28 = this.openEncapsulation();
                String string = this.validateID(this.read_string());
                Pair pair = this.getCachedTypecode(string);
                if (pair == null) {
                    String string8 = this.validateName(this.read_string());
                    map.put(n3, string);
                    short s = this.read_short();
                    org.omg.CORBA.TypeCode typeCode8 = this.read_TypeCode(map, map2);
                    int n29 = this.read_long();
                    ValueMember[] valueMemberArray = new ValueMember[n29];
                    for (int i = 0; i < n29; ++i) {
                        valueMemberArray[i] = new ValueMember(this.read_string(), null, null, null, this.read_TypeCode(map, map2), null, this.read_short());
                    }
                    typeCode = this.orb.create_value_tc(string, string8, s, typeCode8, valueMemberArray);
                    this.putCachedTypecode(string, new Pair(typeCode, n3));
                } else {
                    int n30 = this.calcSkipAmount(n28, n2);
                    this.updateTcMap(map, n2, n30, pair.position);
                    this.skip(n30);
                    map.put(n3, string);
                    typeCode = pair.typeCode;
                }
                this.closeEncapsulation();
                break;
            }
            case 30: {
                int n31 = this.openEncapsulation();
                String string = this.validateID(this.read_string());
                Pair pair = this.getCachedTypecode(string);
                if (pair == null) {
                    String string9 = this.validateName(this.read_string());
                    map.put(n3, string);
                    org.omg.CORBA.TypeCode typeCode9 = this.read_TypeCode(map, map2);
                    typeCode = this.orb.create_value_box_tc(string, string9, typeCode9);
                    this.putCachedTypecode(string, new Pair(typeCode, n3));
                } else {
                    int n32 = this.calcSkipAmount(n31, n2);
                    this.updateTcMap(map, n2, n32, pair.position);
                    this.skip(n32);
                    map.put(n3, string);
                    typeCode = pair.typeCode;
                }
                this.closeEncapsulation();
                break;
            }
            case 31: {
                throw new MARSHAL("Cannot handle TypeCode with kind " + n);
            }
            case 32: {
                int n33 = this.openEncapsulation();
                String string = this.validateID(this.read_string());
                Pair pair = this.getCachedTypecode(string);
                if (pair == null) {
                    String string10 = this.validateName(this.read_string());
                    map.put(n3, string);
                    typeCode = this.orb.create_abstract_interface_tc(string, string10);
                    this.putCachedTypecode(string, new Pair(typeCode, n3));
                } else {
                    int n34 = this.calcSkipAmount(n33, n2);
                    this.updateTcMap(map, n2, n34, pair.position);
                    this.skip(n34);
                    map.put(n3, string);
                    typeCode = pair.typeCode;
                }
                this.closeEncapsulation();
                break;
            }
            default: {
                throw new MARSHAL("Cannot handle TypeCode with kind " + n);
            }
        }
        map2.put(n3, typeCode);
        return typeCode;
    }

    private int calcSkipAmount(int n, int n2) {
        return n - (this.pos - n2 - 4 - 4);
    }

    private void updateTcMap(Map map, int n, int n2, Integer n3) {
        SortedMap sortedMap = ((TreeMap)map).subMap(n3, ObjectUtil.newInteger(n2 + n3));
        if (sortedMap.size() > 0) {
            TreeMap treeMap = new TreeMap();
            for (Map.Entry entry : sortedMap.entrySet()) {
                int n4 = entry.getKey();
                treeMap.put(ObjectUtil.newInteger(n + (n4 - n3)), entry.getValue());
            }
            map.putAll(treeMap);
        }
    }

    public final int read_ulong() {
        this.handle_chunking();
        int n = 4 - this.index % 4;
        if (n != 4) {
            this.index += n;
            this.pos += n;
        }
        int n2 = CDRInputStream._read4int(this.littleEndian, this.buffer, this.pos);
        this.index += 4;
        this.pos += 4;
        return n2;
    }

    public final void read_ulong_array(int[] nArray, int n, int n2) {
        if (n2 == 0) {
            return;
        }
        this.handle_chunking();
        int n3 = 4 - this.index % 4;
        if (n3 != 4) {
            this.index += n3;
            this.pos += n3;
        }
        for (int i = n; i < n + n2; ++i) {
            nArray[i] = CDRInputStream._read4int(this.littleEndian, this.buffer, this.pos);
            this.pos += 4;
        }
        this.index += 4 * n2;
    }

    public final long read_ulonglong() {
        this.handle_chunking();
        int n = 8 - this.index % 8;
        if (n != 8) {
            this.index += n;
            this.pos += n;
        }
        if (this.littleEndian) {
            return ((long)this._read_long() & 0xFFFFFFFFL) + ((long)this._read_long() << 32);
        }
        return ((long)this._read_long() << 32) + ((long)this._read_long() & 0xFFFFFFFFL);
    }

    public final void read_ulonglong_array(long[] lArray, int n, int n2) {
        if (n2 == 0) {
            return;
        }
        this.handle_chunking();
        int n3 = 8 - this.index % 8;
        if (n3 != 8) {
            this.index += n3;
            this.pos += n3;
        }
        if (this.littleEndian) {
            for (int i = n; i < n + n2; ++i) {
                lArray[i] = ((long)this._read_long() & 0xFFFFFFFFL) + ((long)this._read_long() << 32);
            }
        } else {
            for (int i = n; i < n + n2; ++i) {
                lArray[i] = ((long)this._read_long() << 32) + ((long)this._read_long() & 0xFFFFFFFFL);
            }
        }
    }

    public final short read_ushort() {
        this.handle_chunking();
        int n = 2 - this.index % 2;
        if (n != 2) {
            this.index += n;
            this.pos += n;
        }
        short s = CDRInputStream._read2int(this.littleEndian, this.buffer, this.pos);
        this.pos += 2;
        this.index += 2;
        return s;
    }

    public final void read_ushort_array(short[] sArray, int n, int n2) {
        if (n2 == 0) {
            return;
        }
        this.handle_chunking();
        int n3 = 2 - this.index % 2;
        if (n3 != 2) {
            this.index += n3;
            this.pos += n3;
        }
        for (int i = n; i < n + n2; ++i) {
            sArray[i] = CDRInputStream._read2int(this.littleEndian, this.buffer, this.pos);
            this.pos += 2;
        }
        this.index += n2 * 2;
    }

    public final char read_wchar() {
        this.handle_chunking();
        if (this.giop_minor == 2) {
            this.read_wchar_size();
            boolean bl = this.readBOM();
            return this.read_wchar(bl);
        }
        return this.read_wchar(this.littleEndian);
    }

    public byte readByte() {
        ++this.index;
        return this.buffer[this.pos++];
    }

    private final int read_wchar_size() {
        ++this.index;
        return this.buffer[this.pos++];
    }

    private final char read_wchar(boolean bl) {
        return this.codeSetW.read_wchar(this, this.giop_minor, bl);
    }

    public final boolean readBOM() {
        if (this.buffer[this.pos] == -2 && this.buffer[this.pos + 1] == -1) {
            this.pos += 2;
            this.index += 2;
            return false;
        }
        if (this.buffer[this.pos] == -1 && this.buffer[this.pos + 1] == -2) {
            this.pos += 2;
            this.index += 2;
            return true;
        }
        return false;
    }

    public final void read_wchar_array(char[] cArray, int n, int n2) {
        this.handle_chunking();
        for (int i = n; i < n + n2; ++i) {
            cArray[i] = this.read_wchar();
        }
    }

    public final String read_wstring() {
        this.handle_chunking();
        int n = 4 - this.index % 4;
        if (n != 4) {
            this.index += n;
            this.pos += n;
        }
        int n2 = CDRInputStream._read4int(this.littleEndian, this.buffer, this.pos);
        this.index += 4;
        this.pos += 4;
        if (n2 == 0) {
            return "";
        }
        return this.codeSetW.read_wstring(this, n2, this.giop_minor, this.littleEndian);
    }

    public boolean markSupported() {
        return true;
    }

    public void mark(int n) {
        this.marked_pos = this.pos;
        this.marked_index = this.index;
    }

    public void reset() throws IOException {
        if (this.pos < 0) {
            throw new MARSHAL("Mark has not been set!");
        }
        this.pos = this.marked_pos;
        this.index = this.marked_index;
    }

    private final void resetIndex() {
        this.index = 0;
    }

    public final void setLittleEndian(boolean bl) {
        this.littleEndian = bl;
    }

    final void read_value(org.omg.CORBA.TypeCode typeCode, org.omg.CORBA.portable.OutputStream outputStream) {
        if (typeCode == null) {
            throw new BAD_PARAM("TypeCode is null");
        }
        int n = typeCode.kind().value();
        try {
            switch (n) {
                case 0: 
                case 1: {
                    break;
                }
                case 2: {
                    outputStream.write_short(this.read_short());
                    break;
                }
                case 3: {
                    outputStream.write_long(this.read_long());
                    break;
                }
                case 4: {
                    outputStream.write_ushort(this.read_ushort());
                    break;
                }
                case 5: {
                    outputStream.write_ulong(this.read_ulong());
                    break;
                }
                case 6: {
                    outputStream.write_float(this.read_float());
                    break;
                }
                case 7: {
                    outputStream.write_double(this.read_double());
                    break;
                }
                case 8: {
                    outputStream.write_boolean(this.read_boolean());
                    break;
                }
                case 9: {
                    outputStream.write_char(this.read_char());
                    break;
                }
                case 10: {
                    outputStream.write_octet(this.read_octet());
                    break;
                }
                case 11: {
                    outputStream.write_any(this.read_any());
                    break;
                }
                case 12: {
                    outputStream.write_TypeCode(this.read_TypeCode());
                    break;
                }
                case 13: {
                    throw new NO_IMPLEMENT("Principal deprecated");
                }
                case 14: {
                    outputStream.write_Object(this.read_Object());
                    break;
                }
                case 15: {
                    for (int i = 0; i < typeCode.member_count(); ++i) {
                        this.read_value(typeCode.member_type(i), outputStream);
                    }
                    break;
                }
                case 16: {
                    org.omg.CORBA.TypeCode typeCode2 = typeCode.discriminator_type();
                    typeCode2 = TypeCode.originalType(typeCode2);
                    int n2 = typeCode.default_index();
                    int n3 = -1;
                    block33 : switch (typeCode2.kind().value()) {
                        case 2: {
                            short s = this.read_short();
                            outputStream.write_short(s);
                            for (int i = 0; i < typeCode.member_count(); ++i) {
                                if (i == n2 || s != typeCode.member_label(i).extract_short()) continue;
                                n3 = i;
                                break block33;
                            }
                            break;
                        }
                        case 3: {
                            int n4 = this.read_long();
                            outputStream.write_long(n4);
                            for (int i = 0; i < typeCode.member_count(); ++i) {
                                if (i == n2 || n4 != typeCode.member_label(i).extract_long()) continue;
                                n3 = i;
                                break block33;
                            }
                            break;
                        }
                        case 4: {
                            short s = this.read_ushort();
                            outputStream.write_ushort(s);
                            for (int i = 0; i < typeCode.member_count(); ++i) {
                                if (i == n2 || s != typeCode.member_label(i).extract_ushort()) continue;
                                n3 = i;
                                break block33;
                            }
                            break;
                        }
                        case 5: {
                            int n5 = this.read_ulong();
                            outputStream.write_ulong(n5);
                            for (int i = 0; i < typeCode.member_count(); ++i) {
                                if (i == n2 || n5 != typeCode.member_label(i).extract_ulong()) continue;
                                n3 = i;
                                break block33;
                            }
                            break;
                        }
                        case 6: 
                        case 7: {
                            throw new MARSHAL("Invalid union discriminator type: " + typeCode2);
                        }
                        case 8: {
                            boolean bl = this.read_boolean();
                            outputStream.write_boolean(bl);
                            for (int i = 0; i < typeCode.member_count(); ++i) {
                                if (i == n2 || bl != typeCode.member_label(i).extract_boolean()) continue;
                                n3 = i;
                                break block33;
                            }
                            break;
                        }
                        case 9: {
                            char c = this.read_char();
                            outputStream.write_char(c);
                            for (int i = 0; i < typeCode.member_count(); ++i) {
                                if (i == n2 || c != typeCode.member_label(i).extract_char()) continue;
                                n3 = i;
                                break block33;
                            }
                            break;
                        }
                        case 10: 
                        case 11: 
                        case 12: 
                        case 13: 
                        case 14: 
                        case 15: 
                        case 16: {
                            throw new MARSHAL("Invalid union discriminator type: " + typeCode2);
                        }
                        case 17: {
                            int n6 = this.read_long();
                            outputStream.write_long(n6);
                            for (int i = 0; i < typeCode.member_count(); ++i) {
                                int n7;
                                if (i == n2 || n6 != (n7 = typeCode.member_label(i).create_input_stream().read_long())) continue;
                                n3 = i;
                                break block33;
                            }
                            break;
                        }
                        case 18: 
                        case 19: 
                        case 20: 
                        case 21: 
                        case 22: {
                            throw new MARSHAL("Invalid union discriminator type: " + typeCode2);
                        }
                        case 23: {
                            long l = this.read_longlong();
                            outputStream.write_longlong(l);
                            for (int i = 0; i < typeCode.member_count(); ++i) {
                                if (i == n2 || l != typeCode.member_label(i).extract_longlong()) continue;
                                n3 = i;
                                break block33;
                            }
                            break;
                        }
                        case 24: {
                            long l = this.read_ulonglong();
                            outputStream.write_ulonglong(l);
                            for (int i = 0; i < typeCode.member_count(); ++i) {
                                if (i == n2 || l != typeCode.member_label(i).extract_ulonglong()) continue;
                                n3 = i;
                                break block33;
                            }
                            break;
                        }
                        default: {
                            throw new MARSHAL("Invalid union discriminator type: " + typeCode2);
                        }
                    }
                    if (n3 != -1) {
                        this.read_value(typeCode.member_type(n3), outputStream);
                        break;
                    }
                    if (n2 != -1) {
                        this.read_value(typeCode.member_type(n2), outputStream);
                    }
                    break;
                }
                case 17: {
                    outputStream.write_long(this.read_long());
                    break;
                }
                case 18: {
                    outputStream.write_string(this.read_string());
                    break;
                }
                case 19: {
                    int n8 = this.read_long();
                    outputStream.write_long(n8);
                    for (int i = 0; i < n8; ++i) {
                        this.read_value(typeCode.content_type(), outputStream);
                    }
                    break;
                }
                case 20: {
                    int n9 = typeCode.length();
                    for (int i = 0; i < n9; ++i) {
                        this.read_value(typeCode.content_type(), outputStream);
                    }
                    break;
                }
                case 21: {
                    this.read_value(typeCode.content_type(), outputStream);
                    break;
                }
                case 22: {
                    outputStream.write_string(this.read_string());
                    for (int i = 0; i < typeCode.member_count(); ++i) {
                        this.read_value(typeCode.member_type(i), outputStream);
                    }
                    break;
                }
                case 23: {
                    outputStream.write_longlong(this.read_longlong());
                    break;
                }
                case 24: {
                    outputStream.write_ulonglong(this.read_ulonglong());
                    break;
                }
                case 25: {
                    throw new BAD_TYPECODE("type longdouble not supported in java");
                }
                case 26: {
                    outputStream.write_wchar(this.read_wchar());
                    break;
                }
                case 27: {
                    outputStream.write_wstring(this.read_wstring());
                    break;
                }
                case 28: {
                    short s = typeCode.fixed_digits();
                    short s2 = typeCode.fixed_scale();
                    BigDecimal bigDecimal = this.read_fixed(s, s2);
                    if (outputStream instanceof CDROutputStream) {
                        CDROutputStream cDROutputStream = (CDROutputStream)outputStream;
                        cDROutputStream.write_fixed(bigDecimal, s, s2);
                        break;
                    }
                    outputStream.write_fixed(bigDecimal);
                    break;
                }
                case 29: {
                    Serializable serializable = this.read_value();
                    ((OutputStream)outputStream).write_value(serializable, typeCode.id());
                    break;
                }
                case 30: {
                    String string = typeCode.id();
                    BoxedValueHelper boxedValueHelper = ((ORB)this.orb).getBoxedValueHelper(string);
                    if (boxedValueHelper == null) {
                        throw new MARSHAL("No BoxedValueHelper for id " + string);
                    }
                    Serializable serializable = this.read_value(boxedValueHelper);
                    ((OutputStream)outputStream).write_value(serializable, boxedValueHelper);
                    break;
                }
                default: {
                    throw new MARSHAL("Cannot handle TypeCode with kind " + n);
                }
            }
        }
        catch (BadKind badKind) {
            throw new MARSHAL("When processing TypeCode with kind: " + n + " caught " + badKind);
        }
        catch (Bounds bounds) {
            throw new MARSHAL("When processing TypeCode with kind: " + n + " caught " + bounds);
        }
    }

    public Serializable read_value() {
        int n = this.read_long();
        int n2 = this.pos - 4;
        if (n == -1) {
            return this.read_indirect_value();
        }
        if (n == 0) {
            return null;
        }
        String string = (n & 1) != 0 ? this.read_codebase() : null;
        this.chunkedValue = (n & 8) != 0;
        int n3 = n;
        if ((n &= 0xFFFFFFF6) == 0x7FFFFF00) {
            throw new MARSHAL("missing value type information");
        }
        if (n == 2147483394) {
            return this.read_typed_value(n2, string);
        }
        if (n == 2147483398) {
            return this.read_multi_typed_value(n2, string);
        }
        throw new MARSHAL("unknown value tag: 0x" + Integer.toHexString(n3) + " (offset=0x" + Integer.toHexString(n2) + ")");
    }

    public Serializable read_value(String string) {
        int n = this.read_long();
        int n2 = this.pos - 4;
        if (n == -1) {
            return this.read_indirect_value();
        }
        if (n == 0) {
            return null;
        }
        String string2 = (n & 1) != 0 ? this.read_codebase() : null;
        this.chunkedValue = (n & 8) != 0;
        int n3 = n;
        if ((n &= 0xFFFFFFF6) == 0x7FFFFF00) {
            return this.read_untyped_value(new String[]{string}, n2, string2);
        }
        if (n == 2147483394) {
            return this.read_typed_value(n2, string2);
        }
        if (n == 2147483398) {
            return this.read_multi_typed_value(n2, string2);
        }
        throw new MARSHAL("unknown value tag: 0x" + Integer.toHexString(n3) + " (offset=0x" + Integer.toHexString(n2) + ")");
    }

    public Serializable read_value(Serializable serializable) {
        if (serializable instanceof Streamable) {
            this.register_value(serializable);
            ((Streamable)((java.lang.Object)serializable))._read(this);
        } else if (serializable instanceof CustomValue) {
            this.register_value(serializable);
            ((CustomValue)serializable).unmarshal(new DataInputStream(this));
        } else {
            throw new BAD_PARAM("read_value is only implemented for Streamables");
        }
        return serializable;
    }

    public Serializable read_value(Class clazz) {
        int n = this.read_long();
        int n2 = this.pos - 4;
        if (n == -1) {
            return this.read_indirect_value();
        }
        if (n == 0) {
            return null;
        }
        String string = (n & 1) != 0 ? this.read_codebase() : null;
        this.chunkedValue = (n & 8) != 0;
        int n3 = n;
        if ((n &= 0xFFFFFFF6) == 0x7FFFFF00) {
            return this.read_untyped_value(new String[]{ValueHandler.getRMIRepositoryID(clazz)}, n2, string);
        }
        if (n == 2147483394) {
            return this.read_typed_value(n2, string);
        }
        if (n == 2147483398) {
            return this.read_multi_typed_value(n2, string);
        }
        throw new MARSHAL("unknown value tag: 0x" + Integer.toHexString(n3) + " (offset=0x" + Integer.toHexString(n2) + ")");
    }

    public Serializable read_value(BoxedValueHelper boxedValueHelper) {
        int n = this.read_long();
        int n2 = this.pos - 4;
        if (n == -1) {
            return this.read_indirect_value();
        }
        if (n == 0) {
            return null;
        }
        String string = (n & 1) != 0 ? this.read_codebase() : null;
        this.chunkedValue = (n & 8) != 0;
        int n3 = n;
        if ((n &= 0xFFFFFFF6) == 0x7FFFFF00) {
            Serializable serializable = boxedValueHelper.read_value(this);
            if (serializable != null) {
                this.getValueMap().put(ObjectUtil.newInteger(n2), serializable);
            }
            return serializable;
        }
        if (n == 2147483394) {
            Serializable serializable = this.read_typed_value(n2, string, boxedValueHelper);
            if (serializable != null) {
                this.getValueMap().put(ObjectUtil.newInteger(n2), serializable);
            }
            return serializable;
        }
        throw new MARSHAL("unknown value tag: 0x" + Integer.toHexString(n3) + " (offset=0x" + Integer.toHexString(n2) + ")");
    }

    private Serializable read_untyped_value(String[] stringArray, int n, String string) {
        java.lang.Object object = null;
        if (this.chunkedValue || this.valueNestingLevel > 0 && !this.sunInteropFix) {
            ++this.valueNestingLevel;
            this.readChunkSizeTag();
        }
        for (int i = 0; i < stringArray.length; ++i) {
            java.lang.Object object2;
            java.lang.Object object3;
            java.lang.Object object4;
            if (stringArray[i].equals(WStringValueHelper.id())) {
                object = this.read_wstring();
                break;
            }
            if (stringArray[i].equals(StringValueHelper.id())) {
                object = this.read_string();
                break;
            }
            if (stringArray[i].startsWith("RMI:javax.rmi.CORBA.ClassDesc:")) {
                object4 = (String)((java.lang.Object)this.read_value(String.class));
                object3 = (String)((java.lang.Object)this.read_value(String.class));
                object2 = RepositoryID.className((String)object3, null);
                try {
                    object = this.loadClass((String)object2, (String)object4);
                    break;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    if (i < stringArray.length - 1) continue;
                    throw new MARSHAL("class not found: " + (String)object2);
                }
            }
            if (stringArray[i].startsWith("IDL:")) {
                object4 = ((org.omg.CORBA_2_3.ORB)this.orb()).lookup_value_factory(stringArray[i]);
                if (object4 != null) {
                    this.currentValueIndex = n;
                    object = object4.read_value(this);
                    break;
                }
                if (i < stringArray.length - 1) continue;
                throw new MARSHAL("No factory found for: " + stringArray[0]);
            }
            object4 = RepositoryID.className(stringArray[i], null);
            try {
                object3 = this.loadClass((String)object4, string);
                if (IDLEntity.class.isAssignableFrom((Class<?>)object3)) {
                    object2 = null;
                    if (object3 != Any.class) {
                        String string2 = ((Class)object3).getName() + "Helper";
                        try {
                            ClassLoader classLoader = ((Class)object3).getClassLoader();
                            Class<?> clazz = classLoader == null ? ObjectUtil.classForName(string2) : classLoader.loadClass(string2);
                            Class[] classArray = new Class[]{org.omg.CORBA.portable.InputStream.class};
                            object2 = clazz.getMethod("read", classArray);
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new MARSHAL("Error loading class " + string2 + ": " + classNotFoundException);
                        }
                        catch (NoSuchMethodException noSuchMethodException) {
                            throw new MARSHAL("No read method in helper class " + string2 + ": " + noSuchMethodException);
                        }
                    }
                    if (object2 == null) {
                        object = this.read_any();
                        continue;
                    }
                    try {
                        object = (Serializable)((Method)object2).invoke(null, this);
                        continue;
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        throw new MARSHAL("Internal error: " + illegalAccessException);
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        throw new MARSHAL("Exception unmarshaling IDLEntity: " + invocationTargetException.getTargetException());
                    }
                }
                object = ValueHandler.readValue(this, n, (Class)object3, stringArray[i], null);
                continue;
            }
            catch (ClassNotFoundException classNotFoundException) {
                if (i < stringArray.length - 1) continue;
                throw new MARSHAL("class not found: " + (String)object4);
            }
        }
        if (object != null) {
            this.getValueMap().put(ObjectUtil.newInteger(n), object);
        }
        return object;
    }

    private Class loadClass(String string, String string2) throws ClassNotFoundException {
        Class clazz;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            clazz = ValueHandler.loadClass(string, string2, null);
        } else {
            try {
                clazz = classLoader.loadClass(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                clazz = ValueHandler.loadClass(string, string2, null);
            }
        }
        return clazz;
    }

    private void readChunkSizeTag() {
        int n = this.pos;
        int n2 = this.index;
        int n3 = this.read_long();
        if (!this.sunInteropFix || n3 > 0 && n3 < 0x7FFFFF00) {
            this.chunk_end_pos = this.pos + n3;
        } else {
            this.pos = n;
            this.index = n2;
            this.adjust_positions();
        }
    }

    private Serializable read_typed_value(int n, String string) {
        return this.read_untyped_value(new String[]{this.read_repository_id()}, n, string);
    }

    private Serializable read_typed_value(int n, String string, BoxedValueHelper boxedValueHelper) {
        String string2 = this.read_repository_id();
        if (!boxedValueHelper.get_id().equals(string2)) {
            throw new MARSHAL("unexpected RepositoryID. expected: " + boxedValueHelper.get_id() + " got: " + string2);
        }
        return boxedValueHelper.read_value(this);
    }

    private Serializable read_multi_typed_value(int n, String string) {
        int n2 = this.read_long();
        String[] stringArray = new String[n2];
        for (int i = 0; i < n2; ++i) {
            stringArray[i] = this.read_repository_id();
        }
        return this.read_untyped_value(stringArray, n, string);
    }

    private String read_repository_id() {
        int n = this.read_long();
        if (n == -1) {
            int n2 = this.read_long();
            n2 = n2 + this.pos - 4;
            String string = (String)this.getRepIdMap().get(ObjectUtil.newInteger(n2));
            if (string == null) {
                throw new MARSHAL("stale RepositoryID indirection");
            }
            return string;
        }
        this.pos -= 4;
        this.index -= 4;
        int n3 = this.pos;
        String string = this.read_string();
        this.getRepIdMap().put(ObjectUtil.newInteger(n3), string);
        return string;
    }

    private String read_codebase() {
        int n = this.read_long();
        if (n == -1) {
            int n2 = this.read_long();
            n2 = n2 + this.pos - 4;
            String string = (String)this.getCodebaseMap().get(ObjectUtil.newInteger(n2));
            if (string == null) {
                throw new MARSHAL("stale codebase indirection");
            }
            return string;
        }
        this.pos -= 4;
        this.index -= 4;
        int n3 = this.pos;
        String string = this.read_string();
        this.getCodebaseMap().put(ObjectUtil.newInteger(n3), string);
        return string;
    }

    private Serializable read_indirect_value() {
        int n = this.read_long();
        n = n + this.pos - 4;
        java.lang.Object v = this.getValueMap().get(ObjectUtil.newInteger(n));
        if (v == null) {
            throw new IndirectionException(n);
        }
        return (Serializable)v;
    }

    private String validateName(String string) {
        if (string != null && string.length() == 0) {
            return null;
        }
        return string;
    }

    private String validateID(String string) {
        if (string == null || string.length() == 0) {
            return "IDL:";
        }
        return string;
    }

    public java.lang.Object read_abstract_interface() {
        return this.read_boolean() ? this.read_Object() : this.read_value();
    }

    public java.lang.Object read_abstract_interface(Class clazz) {
        return this.read_boolean() ? this.read_Object(clazz) : this.read_value(clazz);
    }

    public int get_pos() {
        return this.pos;
    }

    public void register_value(Serializable serializable) {
        this.getValueMap().put(ObjectUtil.newInteger(this.currentValueIndex), serializable);
    }

    public void updateMutatorConnection(GIOPConnection gIOPConnection) {
        if (this.isMutatorEnabled) {
            this.mutator.updateConnection(gIOPConnection.getTransport());
        }
    }

    private static final class Pair {
        public final org.omg.CORBA.TypeCode typeCode;
        public final Integer position;

        public Pair(org.omg.CORBA.TypeCode typeCode, Integer n) {
            this.typeCode = typeCode;
            this.position = n;
        }

        public String toString() {
            return this.typeCode + " and " + this.position;
        }
    }
}

