/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.interceptors.aop;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.aop.joinpoint.MethodInvocation;

public class InvocationContextInterceptor {
    private static final String INVOCATION_CONTEXT_KEY = InvocationContextInterceptor.class.getName() + ".invocationContext";

    public static InvocationContext getInvocationContext(Invocation invocation) {
        InvocationContext ctx = (InvocationContext)invocation.getResponseAttachment((Object)INVOCATION_CONTEXT_KEY);
        if (ctx == null) {
            throw new IllegalStateException("InvocationContextInterceptor must be in the interceptor chain");
        }
        ctx.invocation = invocation;
        return ctx;
    }

    public String getName() {
        return "InvocationContextInterceptor";
    }

    public Object fillMethod(Invocation invocation) throws Throwable {
        assert (invocation instanceof MethodInvocation) : "InvocationContextInterceptor.fillMethod only works on method invocation " + invocation;
        MethodInvocation mi = (MethodInvocation)invocation;
        InvocationContext ctx = InvocationContextInterceptor.getInvocationContext(invocation);
        ctx.setBusinessMethodInvocation(mi.getMethod(), mi.getArguments());
        return invocation.invokeNext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object setup(Invocation invocation) throws Throwable {
        InvocationContext ctx = new InvocationContext(invocation);
        invocation.addResponseAttachment((Object)INVOCATION_CONTEXT_KEY, (Object)ctx);
        try {
            Object object = invocation.invokeNext();
            return object;
        }
        finally {
            invocation.getResponseContextInfo().remove(INVOCATION_CONTEXT_KEY);
        }
    }

    private static class InvocationContext
    implements javax.interceptor.InvocationContext {
        private Invocation invocation;
        private Map<String, Object> contextData = new HashMap<String, Object>();
        private Method method = null;
        private Object[] params = null;

        private InvocationContext(Invocation invocation) {
            this.invocation = invocation;
        }

        public Map<String, Object> getContextData() {
            return this.contextData;
        }

        public Method getMethod() {
            return this.method;
        }

        public Object[] getParameters() {
            if (this.method == null) {
                throw new IllegalStateException("Get parameters is not allowed on lifecycle callbacks (EJB 3 12)");
            }
            return this.params;
        }

        public Object getTarget() {
            return this.invocation.getTargetObject();
        }

        public Object proceed() throws Exception {
            try {
                return this.invocation.invokeNext();
            }
            catch (Exception e) {
                throw e;
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
        }

        private void setBusinessMethodInvocation(Method method, Object[] params) {
            this.method = method;
            this.params = params;
        }

        public void setParameters(Object[] params) {
            if (this.method == null) {
                throw new IllegalStateException("Setting parameters is not allowed on lifecycle callbacks (EJB 3 12)");
            }
            this.params = params;
            ((MethodInvocation)this.invocation).setArguments(params);
        }

        public String toString() {
            return "[target=" + this.getTarget() + ", method=" + this.method + ", parameters=" + Arrays.toString(this.params) + ", contextData=" + this.contextData + "]";
        }
    }
}

