/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.eclipsesupport;

import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.net.URL;
import java.security.ProtectionDomain;
import java.util.Vector;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.CtNewMethod;
import org.jboss.aop.AspectManager;
import org.jboss.aop.AspectXmlLoader;
import org.jboss.aop.standalone.AOPTransformer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EclipseTestTransformer
implements ClassFileTransformer {
    AOPTransformer aopTransformer = new AOPTransformer();
    boolean foundRemoteTestRunner;
    static final String MAIN_CLASS = "org/eclipse/jdt/internal/junit/runner/RemoteTestRunner";
    public static final String CLASSLOADER_DEPLOYED_XML = "jboss.aop.eclipse.test.xml.name";

    @Override
    public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws IllegalClassFormatException {
        if (!this.foundRemoteTestRunner && className.equals(MAIN_CLASS)) {
            System.out.println("Found class " + className);
            return this.weaveRemoteTestRunner(loader, className, classBeingRedefined, protectionDomain, classfileBuffer);
        }
        return this.aopTransformer.transform(loader, className, classBeingRedefined, protectionDomain, classfileBuffer);
    }

    private byte[] weaveRemoteTestRunner(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws IllegalClassFormatException {
        try {
            AspectManager manager = AspectManager.instance();
            ClassPool pool = manager.registerClassLoader(loader);
            CtClass remoteTestRunner = pool.get(MAIN_CLASS.replace('/', '.'));
            remoteTestRunner.defrost();
            CtMethod originalMain = remoteTestRunner.getMethod("main", "([Ljava/lang/String;)V");
            System.out.println("-----> Found CtMethod " + (originalMain != null));
            CtMethod wrapper = CtNewMethod.copy((CtMethod)originalMain, (CtClass)remoteTestRunner, null);
            originalMain.setName("originalMain");
            String body = "{  org.jboss.aop.eclipsesupport.EclipseTestTransformer.recordClassNameAndDeployXml($$);  originalMain($$);}";
            wrapper.setBody(body);
            remoteTestRunner.addMethod(wrapper);
            remoteTestRunner.debugWriteFile();
            return remoteTestRunner.toBytecode();
        }
        catch (Exception e) {
            System.out.println("====> Exception " + e);
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public static void recordClassNameAndDeployXml(String[] args) throws Exception {
        String[] fTestClassNames = null;
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].toLowerCase().equals("-classnames") && !args[i].toLowerCase().equals("-classname")) continue;
            Vector<String> list = new Vector<String>();
            for (int j = i + 1; j < args.length && !args[j].startsWith("-"); ++j) {
                list.add(args[j]);
            }
            fTestClassNames = list.toArray(new String[list.size()]);
        }
        if (fTestClassNames == null || fTestClassNames.length == 0) {
            throw new RuntimeException("No classnames could be found");
        }
        if (fTestClassNames.length > 1) {
            throw new RuntimeException("Only one class name is supported");
        }
        EclipseTestTransformer.deployXmlForEclipse((String)fTestClassNames[0]);
    }

    public static void deployXmlForEclipse(String testClass) throws Exception {
        if (System.getProperty("jboss.aop.path") != null) {
            return;
        }
        String testName = null;
        if (testClass.contains(".regression.")) {
            testName = "regression";
        } else {
            int dot = testClass.lastIndexOf(46);
            String packageName = testClass.substring(0, dot);
            dot = packageName.lastIndexOf(46);
            testName = packageName.substring(dot + 1);
        }
        testName = "test/" + testName + "/jboss-aop.xml";
        URL url = Thread.currentThread().getContextClassLoader().getResource(testName);
        if (url != null) {
            System.setProperty(CLASSLOADER_DEPLOYED_XML, testName);
            AspectXmlLoader.deployXML(url);
        }
    }
}

