/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core.jaxws.client;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import javax.jws.HandlerChain;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.naming.Referenceable;
import javax.xml.namespace.QName;
import javax.xml.ws.Service;
import javax.xml.ws.WebServiceClient;
import javax.xml.ws.WebServiceRef;
import javax.xml.ws.WebServiceRefs;
import org.jboss.logging.Logger;
import org.jboss.util.naming.Util;
import org.jboss.ws.core.jaxws.client.ServiceReferenceable;
import org.jboss.wsf.spi.WSFException;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedServiceRefMetaData;
import org.jboss.wsf.spi.serviceref.ServiceRefBinder;

public class NativeServiceRefBinderJAXWS
implements ServiceRefBinder {
    private static Logger log = Logger.getLogger(NativeServiceRefBinderJAXWS.class);

    public void setupServiceRef(Context encCtx, String encName, AnnotatedElement anElement, UnifiedServiceRefMetaData serviceRef, ClassLoader loader) throws NamingException {
        WebServiceRef wsref = null;
        if (null == loader) {
            throw new IllegalArgumentException("There needs to be a classloader available");
        }
        ArrayList<WebServiceRef> wsrefList = new ArrayList<WebServiceRef>();
        if (anElement != null) {
            for (Annotation an : anElement.getAnnotations()) {
                if (an instanceof WebServiceRef) {
                    wsrefList.add((WebServiceRef)an);
                }
                if (!(an instanceof WebServiceRefs)) continue;
                WebServiceRefs wsrefs = (WebServiceRefs)an;
                for (WebServiceRef aux : wsrefs.value()) {
                    wsrefList.add(aux);
                }
            }
        }
        if (wsrefList.size() == 1) {
            wsref = (WebServiceRef)wsrefList.get(0);
        } else {
            for (WebServiceRef aux : wsrefList) {
                if (!encName.endsWith("/" + aux.name())) continue;
                wsref = aux;
                break;
            }
        }
        Class targetClass = null;
        if (anElement instanceof Field) {
            targetClass = ((Field)anElement).getType();
        } else if (anElement instanceof Method) {
            targetClass = ((Method)anElement).getParameterTypes()[0];
        } else if (wsref != null && wsref.type() != Object.class) {
            targetClass = wsref.type();
        }
        String targetClassName = targetClass != null ? targetClass.getName() : null;
        String externalName = encCtx.getNameInNamespace() + "/" + encName;
        log.debug((Object)("setupServiceRef [jndi=" + externalName + ",target=" + targetClassName + "]"));
        String serviceImplClass = null;
        if (wsref != null && wsref.value().getName() != null && !wsref.value().getName().equals(Object.class.getName())) {
            serviceImplClass = wsref.value().getName();
        }
        if (serviceImplClass == null && targetClass != null && Service.class.isAssignableFrom(targetClass)) {
            serviceImplClass = targetClass.getName();
        }
        if (serviceImplClass == null && serviceRef.getServiceInterface() != null) {
            serviceImplClass = serviceRef.getServiceInterface();
        }
        if (serviceImplClass == null) {
            serviceImplClass = Service.class.getName();
        }
        if (wsref != null && wsref.type() != Object.class) {
            targetClassName = wsref.type().getName();
        }
        if (targetClassName == null && targetClass != null && !Service.class.isAssignableFrom(targetClass)) {
            targetClassName = targetClass.getName();
        }
        if (serviceRef.getWsdlOverride() == null && wsref != null && wsref.wsdlLocation().length() > 0) {
            serviceRef.setWsdlOverride(wsref.wsdlLocation());
        }
        String handlerChain = serviceRef.getHandlerChain();
        if (anElement != null) {
            HandlerChain anHandlerChain = anElement.getAnnotation(HandlerChain.class);
            if (handlerChain == null && anHandlerChain != null && anHandlerChain.file().length() > 0) {
                handlerChain = anHandlerChain.file();
            }
        }
        if (handlerChain != null) {
            try {
                new URL(handlerChain);
            }
            catch (MalformedURLException ex) {
                Class declaringClass = null;
                if (anElement instanceof Field) {
                    declaringClass = ((Field)anElement).getDeclaringClass();
                } else if (anElement instanceof Method) {
                    declaringClass = ((Method)anElement).getDeclaringClass();
                } else if (anElement instanceof Class) {
                    declaringClass = (Class)anElement;
                }
                handlerChain = declaringClass.getPackage().getName().replace('.', '/') + "/" + handlerChain;
            }
            serviceRef.setHandlerChain(handlerChain);
        }
        if (null == serviceRef.getServiceQName()) {
            try {
                Class<?> serviceClass = loader.loadClass(serviceImplClass);
                if (serviceClass.getAnnotation(WebServiceClient.class) != null) {
                    WebServiceClient clientDecl = serviceClass.getAnnotation(WebServiceClient.class);
                    serviceRef.setServiceQName(new QName(clientDecl.targetNamespace(), clientDecl.name()));
                }
            }
            catch (ClassNotFoundException e) {
                WSFException.rethrow((String)"Cannot extract service QName for target service", (Throwable)e);
            }
        }
        Referenceable serviceReferenceable = this.buildServiceReferenceable(serviceImplClass, targetClassName, serviceRef);
        Util.bind((Context)encCtx, (String)encName, (Object)serviceReferenceable);
    }

    protected Referenceable buildServiceReferenceable(String serviceImplClass, String targetClassName, UnifiedServiceRefMetaData serviceRef) {
        return new ServiceReferenceable(serviceImplClass, targetClassName, serviceRef);
    }
}

