/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.jbossas5.adapter.api;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.metatype.api.types.MapCompositeMetaType;
import org.jboss.metatype.api.types.MetaType;
import org.jboss.metatype.api.types.PropertiesMetaType;
import org.jboss.metatype.api.values.MetaValue;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.configuration.definition.PropertyDefinitionSimple;
import org.rhq.plugins.jbossas5.adapter.api.PropertyAdapter;
import org.rhq.plugins.jbossas5.adapter.impl.configuration.PropertyListToArrayValueAdapter;
import org.rhq.plugins.jbossas5.adapter.impl.configuration.PropertyListToCollectionValueAdapter;
import org.rhq.plugins.jbossas5.adapter.impl.configuration.PropertyMapToCompositeValueSupportAdapter;
import org.rhq.plugins.jbossas5.adapter.impl.configuration.PropertyMapToGenericValueAdapter;
import org.rhq.plugins.jbossas5.adapter.impl.configuration.PropertyMapToMapCompositeValueSupportAdapter;
import org.rhq.plugins.jbossas5.adapter.impl.configuration.PropertyMapToPropertiesValueAdapter;
import org.rhq.plugins.jbossas5.adapter.impl.configuration.PropertyMapToTableValueAdapter;
import org.rhq.plugins.jbossas5.adapter.impl.configuration.PropertySimpleToEnumValueAdapter;
import org.rhq.plugins.jbossas5.adapter.impl.configuration.PropertySimpleToSimpleValueAdapter;

public class PropertyAdapterFactory {
    private static final Log LOG = LogFactory.getLog(PropertyAdapterFactory.class);

    public static PropertyAdapter getPropertyAdapter(MetaValue metaValue) {
        if (metaValue == null) {
            LOG.debug((Object)"The MetaValue passed in is null.");
            return null;
        }
        MetaType metaType = metaValue.getMetaType();
        return PropertyAdapterFactory.getPropertyAdapter(metaType);
    }

    public static PropertyAdapter getPropertyAdapter(MetaType metaType) {
        PropertyAdapter<PropertySimple, PropertyDefinitionSimple> propertyAdapter = null;
        if (metaType.isSimple()) {
            propertyAdapter = new PropertySimpleToSimpleValueAdapter();
        } else if (metaType.isGeneric()) {
            propertyAdapter = new PropertyMapToGenericValueAdapter();
        } else if (metaType.isComposite()) {
            propertyAdapter = metaType instanceof MapCompositeMetaType ? new PropertyMapToMapCompositeValueSupportAdapter() : new PropertyMapToCompositeValueSupportAdapter();
        } else if (metaType.isTable()) {
            propertyAdapter = new PropertyMapToTableValueAdapter();
        } else if (metaType.isCollection()) {
            propertyAdapter = new PropertyListToCollectionValueAdapter();
        } else if (metaType.isArray()) {
            propertyAdapter = new PropertyListToArrayValueAdapter();
        } else if (metaType.isEnum()) {
            propertyAdapter = new PropertySimpleToEnumValueAdapter();
        } else if (metaType instanceof PropertiesMetaType) {
            propertyAdapter = new PropertyMapToPropertiesValueAdapter();
        } else {
            LOG.warn((Object)("Unsupported MetaType: " + metaType));
        }
        return propertyAdapter;
    }

    public static PropertyAdapter getCustomPropertyAdapter(PropertySimple customProp) {
        if (customProp == null) {
            return null;
        }
        String adapterClassName = customProp.getStringValue();
        PropertyAdapter propertyAdapter = null;
        try {
            Class<?> adapterClass = Class.forName(adapterClassName);
            propertyAdapter = (PropertyAdapter)adapterClass.newInstance();
        }
        catch (Exception e) {
            LOG.error((Object)("Unable to create custom adapter class for " + customProp + "."), (Throwable)e);
        }
        return propertyAdapter;
    }
}

