/*
 * Decompiled with CFR 0.152.
 */
package hidden.org.apache.webdav.lib;

import hidden.de.zeigermann.xml.simpleImporter.DefaultSimpleImportHandler;
import hidden.de.zeigermann.xml.simpleImporter.SimpleImporter;
import hidden.de.zeigermann.xml.simpleImporter.SimplePath;
import hidden.org.apache.commons.httpclient.Credentials;
import hidden.org.apache.commons.httpclient.HttpConnection;
import hidden.org.apache.commons.httpclient.HttpState;
import hidden.org.apache.commons.httpclient.methods.PutMethod;
import hidden.org.apache.commons.httpclient.protocol.Protocol;
import hidden.org.apache.webdav.lib.Subscriber;
import hidden.org.apache.webdav.lib.methods.XMLResponseMethodBase;
import hidden.org.apache.webdav.lib.util.XMLPrinter;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xml.sax.InputSource;
import org.xml.sax.helpers.AttributesImpl;

public class NotificationListener {
    private static Logger logger = Logger.getLogger((class$org$apache$webdav$lib$NotificationListener == null ? (class$org$apache$webdav$lib$NotificationListener = NotificationListener.class$("hidden.org.apache.webdav.lib.NotificationListener")) : class$org$apache$webdav$lib$NotificationListener).getName());
    protected static final Timer timer = new Timer();
    private static final int CONNECTION_TIMEOUT = 30000;
    private String notificationHost;
    private String repositoryHost;
    private String repositoryDomain;
    private int notificationPort;
    private int repositoryPort;
    private Protocol protocol;
    private Credentials credentials;
    private boolean udp = true;
    private List subscribers = new ArrayList();
    private String subscribersAsString;
    static /* synthetic */ Class class$org$apache$webdav$lib$NotificationListener;

    public NotificationListener(String host, int port, String repositoryHost, int repositoryPort, Protocol protocol, Credentials credentials, String repositoryDomain, int pollInterval, boolean udp) {
        Thread listenerThread;
        this.credentials = credentials;
        this.notificationHost = host;
        this.notificationPort = port;
        this.repositoryHost = repositoryHost;
        this.repositoryPort = repositoryPort;
        this.protocol = protocol;
        this.repositoryDomain = repositoryDomain;
        this.udp = udp;
        if (udp) {
            listenerThread = new Thread(new Runnable(){

                public void run() {
                    DatagramSocket serverSocket = null;
                    try {
                        serverSocket = new DatagramSocket(NotificationListener.this.notificationPort);
                        while (true) {
                            byte[] buf = new byte[256];
                            DatagramPacket packet = new DatagramPacket(buf, buf.length);
                            serverSocket.receive(packet);
                            BufferedReader reader = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(buf)));
                            NotificationListener.this.parseNotification(reader);
                        }
                    }
                    catch (IOException e) {
                        logger.log(Level.SEVERE, "Error while listening to socket", e);
                        return;
                    }
                }
            });
            listenerThread.setDaemon(true);
            listenerThread.start();
        } else {
            listenerThread = new Thread(new Runnable(){

                public void run() {
                    ServerSocket serverSocket = null;
                    try {
                        serverSocket = new ServerSocket(NotificationListener.this.notificationPort);
                        while (true) {
                            new ConnectionThread(serverSocket.accept()).start();
                        }
                    }
                    catch (IOException e) {
                        logger.log(Level.SEVERE, "Error while listening to socket", e);
                        return;
                    }
                }
            });
            listenerThread.setDaemon(true);
            listenerThread.start();
        }
        TimerTask poll = new TimerTask(){

            public void run() {
                if (NotificationListener.this.subscribersAsString != null) {
                    NotificationListener.this.poll(NotificationListener.this.subscribersAsString);
                }
            }
        };
        timer.schedule(poll, pollInterval, (long)pollInterval);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean subscribe(String method, String uri, int depth, int lifetime, int notificationDelay, Subscriber listener, Credentials credentials) {
        SubscribeMethod subscribeMethod = new SubscribeMethod(this.repositoryDomain + uri);
        subscribeMethod.addRequestHeader("Notification-type", method);
        if (this.udp) {
            subscribeMethod.addRequestHeader("Call-back", "httpu://" + this.notificationHost + ":" + this.notificationPort);
        } else {
            subscribeMethod.addRequestHeader("Call-back", "http://" + this.notificationHost + ":" + this.notificationPort);
        }
        subscribeMethod.addRequestHeader("Notification-delay", String.valueOf(notificationDelay));
        subscribeMethod.addRequestHeader("Subscription-lifetime", String.valueOf(lifetime));
        subscribeMethod.addRequestHeader("Depth", depth == Integer.MAX_VALUE ? "infinity" : String.valueOf(depth));
        try {
            subscribeMethod.setDoAuthentication(true);
            HttpState httpState = new HttpState();
            httpState.setCredentials(null, this.repositoryHost, credentials);
            HttpConnection httpConnection = new HttpConnection(this.repositoryHost, this.repositoryPort, this.protocol);
            httpConnection.setConnectionTimeout(30000);
            int state = subscribeMethod.execute(httpState, httpConnection);
            if (state == 200) {
                String subscriptionId = subscribeMethod.getResponseHeader("Subscription-ID").getValue();
                logger.log(Level.INFO, "Received subscription id=" + subscriptionId + ", listener: " + listener);
                int id = Integer.valueOf(subscriptionId);
                List list = this.subscribers;
                synchronized (list) {
                    this.subscribers.add(new Subscription(id, uri, listener));
                }
                this.subscribersAsString = this.subscribersAsString == null ? String.valueOf(id) : this.subscribersAsString + ", " + String.valueOf(id);
                return true;
            }
            logger.log(Level.SEVERE, "Subscription for uri='" + uri + "' failed. State: " + state);
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "Subscription of listener '" + listener + "' failed!", e);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean unsubscribe(String uri, Subscriber listener, Credentials credentials) {
        UnsubscribeMethod unsubscribeMethod = new UnsubscribeMethod(this.repositoryDomain + uri);
        List list = this.subscribers;
        synchronized (list) {
            Iterator i = this.subscribers.iterator();
            while (i.hasNext()) {
                Subscription subscription = (Subscription)i.next();
                if (!subscription.getSubscriber().equals(listener)) continue;
                String id = String.valueOf(subscription.getId());
                unsubscribeMethod.addRequestHeader("Subscription-id", id);
                try {
                    unsubscribeMethod.setDoAuthentication(true);
                    HttpState httpState = new HttpState();
                    httpState.setCredentials(null, this.repositoryHost, credentials);
                    HttpConnection httpConnection = new HttpConnection(this.repositoryHost, this.repositoryPort, this.protocol);
                    httpConnection.setConnectionTimeout(30000);
                    int state = unsubscribeMethod.execute(httpState, httpConnection);
                    if (state == 200) {
                        i.remove();
                        return true;
                    }
                    logger.log(Level.SEVERE, "Unsubscription failed. State: " + state);
                }
                catch (IOException e) {
                    logger.log(Level.SEVERE, "Unsubscription of listener '" + listener + "' failed!", e);
                }
            }
        }
        logger.log(Level.SEVERE, "Listener not unsubscribed!");
        return false;
    }

    public void fireEvent(Map information, Credentials credentials) throws IOException {
        EventMethod eventMethod = new EventMethod(this.repositoryDomain);
        eventMethod.addEvent(new Event(information));
        this.fireEvent(eventMethod, credentials);
    }

    public void fireVetoableEvent(Map information, Credentials credentials) throws IOException {
        EventMethod eventMethod = new EventMethod(this.repositoryDomain);
        eventMethod.addVetoableEvent(new Event(information));
        this.fireEvent(eventMethod, credentials);
    }

    protected void fireEvent(EventMethod eventMethod, Credentials credentials) throws IOException {
        eventMethod.setDoAuthentication(true);
        HttpState httpState = new HttpState();
        httpState.setCredentials(null, this.repositoryHost, credentials);
        int state = eventMethod.execute(httpState, new HttpConnection(this.repositoryHost, this.repositoryPort, this.protocol));
        if (state != 200) {
            logger.log(Level.SEVERE, "Event failed. State: " + state);
        }
    }

    protected void fireEvent(int id, Map information) {
        Iterator i = this.subscribers.iterator();
        while (i.hasNext()) {
            Subscription subscriber = (Subscription)i.next();
            if (subscriber.getId() != id) continue;
            subscriber.fireEvent(information);
            break;
        }
    }

    protected void poll(String notifiedSubscribers) {
        StringBuffer registeredSubscribers = new StringBuffer(256);
        StringTokenizer tokenizer = new StringTokenizer(notifiedSubscribers, ",");
        boolean first = true;
        while (tokenizer.hasMoreTokens()) {
            String subscriber = tokenizer.nextToken().trim();
            if (!this.isRegistered(Integer.valueOf(subscriber))) continue;
            if (!first) {
                registeredSubscribers.append(',');
            }
            registeredSubscribers.append(subscriber);
            first = false;
        }
        if (!first) {
            String pollSubscribers = registeredSubscribers.toString();
            logger.log(Level.INFO, "Poll for subscribers: " + pollSubscribers);
            PollMethod pollMethod = new PollMethod(this.repositoryDomain + "/");
            pollMethod.addRequestHeader("Subscription-ID", pollSubscribers);
            try {
                pollMethod.setDoAuthentication(true);
                HttpState httpState = new HttpState();
                httpState.setCredentials(null, this.repositoryHost, this.credentials);
                HttpConnection httpConnection = new HttpConnection(this.repositoryHost, this.repositoryPort, this.protocol);
                httpConnection.setConnectionTimeout(30000);
                int state = pollMethod.execute(httpState, httpConnection);
                if (state == 207) {
                    List events = pollMethod.getEvents();
                    Iterator i = events.iterator();
                    while (i.hasNext()) {
                        Event event = (Event)i.next();
                        this.fireEvent(event.getId(), event.getInformation());
                    }
                } else {
                    logger.log(Level.SEVERE, "Poll failed. State: " + state);
                }
            }
            catch (IOException e) {
                logger.log(Level.SEVERE, "Poll for subscribers '" + this.subscribers + "' failed!");
            }
        }
    }

    private boolean isRegistered(int id) {
        Iterator i = this.subscribers.iterator();
        while (i.hasNext()) {
            Subscription subscription = (Subscription)i.next();
            if (subscription.getId() != id) continue;
            return true;
        }
        return false;
    }

    private void parseNotification(BufferedReader reader) throws IOException {
        String inputLine = reader.readLine();
        if (inputLine != null && inputLine.startsWith("NOTIFY")) {
            while ((inputLine = reader.readLine()) != null) {
                if (!inputLine.startsWith("Subscription-id")) continue;
                String subscribers = inputLine.substring("Subscription-id".length() + 2);
                logger.log(Level.INFO, "Notification received for subscribers: " + subscribers);
                this.poll(subscribers);
            }
        }
        reader.close();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class EventMethod
    extends XMLResponseMethodBase {
        protected static final String E_FIRE_EVENTS = "fire-events";
        protected static final String E_EVENT = "event";
        protected static final String E_VETOABLE_EVENT = "vetoable-event";
        protected static final String E_INFORMATION = "information";
        protected static final String E_STATUS = "status";
        protected static final String A_INFORMATION_KEY = "name";
        public static final String NAME = "EVENT";
        private List vetoableEvents = new ArrayList();
        private List events = new ArrayList();

        public EventMethod(String uri) {
            super(uri);
        }

        public void addEvent(Event event) {
            this.events.add(event);
        }

        public void addVetoableEvent(Event event) {
            this.vetoableEvents.add(event);
        }

        public String getName() {
            return NAME;
        }

        protected String generateRequestBody() {
            String value;
            String name;
            Map.Entry entry;
            Iterator j;
            Map information;
            Event event;
            XMLPrinter printer = new XMLPrinter();
            printer.writeXMLHeader();
            printer.writeElement("D", "DAV:", E_FIRE_EVENTS, 0);
            Iterator i = this.events.iterator();
            while (i.hasNext()) {
                event = (Event)i.next();
                printer.writeElement("D", E_EVENT, 0);
                information = event.getInformation();
                j = information.entrySet().iterator();
                while (j.hasNext()) {
                    entry = j.next();
                    name = (String)entry.getKey();
                    value = (String)entry.getValue();
                    printer.writeElement("D", "information name=\"" + name + "\"", 0);
                    printer.writeText(value);
                    printer.writeElement("D", E_INFORMATION, 1);
                }
                printer.writeElement("D", E_EVENT, 1);
            }
            i = this.vetoableEvents.iterator();
            while (i.hasNext()) {
                event = (Event)i.next();
                printer.writeElement("D", E_VETOABLE_EVENT, 0);
                information = event.getInformation();
                j = information.entrySet().iterator();
                while (j.hasNext()) {
                    entry = j.next();
                    name = (String)entry.getKey();
                    value = (String)entry.getValue();
                    printer.writeElement("D", "information name=\"" + name + "\"", 0);
                    printer.writeText(value);
                    printer.writeElement("D", E_INFORMATION, 1);
                }
                printer.writeElement("D", E_VETOABLE_EVENT, 1);
            }
            printer.writeElement("D", E_FIRE_EVENTS, 1);
            return printer.toString();
        }
    }

    private class UnsubscribeMethod
    extends PutMethod {
        public static final String NAME = "UNSUBSCRIBE";
        public static final String H_SUBSCRIPTION_ID = "Subscription-id";

        public UnsubscribeMethod(String uri) {
            super(uri);
        }

        public String getName() {
            return NAME;
        }
    }

    private class SubscribeMethod
    extends PutMethod {
        public static final String NAME = "SUBSCRIBE";
        public static final String H_NOTIFICATION_TYPE = "Notification-type";
        public static final String H_NOTIFICATION_DELAY = "Notification-delay";
        public static final String H_SUBSCRIPTION_LIFETIME = "Subscription-lifetime";
        public static final String H_SUBSCRIPTION_ID = "Subscription-ID";
        public static final String H_SUBSCRIPTION_ID_RESPONSE = "Subscription-id";
        public static final String H_CALL_BACK = "Call-back";
        public static final String H_DEPTH = "Depth";

        public SubscribeMethod(String uri) {
            super(uri);
        }

        public String getName() {
            return NAME;
        }
    }

    private class PollMethod
    extends PutMethod {
        public static final String NAME = "POLL";
        protected static final String E_SUBSCRIPTION_ID = "subscriptionID";
        protected static final String E_LISTENER = "li";
        protected static final String E_FIRE_EVENTS = "fire-events";
        protected static final String E_EVENT = "event";
        protected static final String E_VETOABLE_EVENT = "vetoable-event";
        protected static final String E_INFORMATION = "information";
        protected static final String E_STATUS = "status";
        public static final String A_NAME = "name";
        protected static final String SUBSCRIPTION = ":subscriptionID";
        protected static final String ID = "li";
        protected static final String EVENT = ":event";
        protected static final String INFORMATION = ":information";
        protected static final String STATUS = ":status";
        protected static final String STATUS_OK = "HTTP/1.1 200 OK";

        public PollMethod() {
        }

        public PollMethod(String uri) {
            super(uri);
        }

        public String getName() {
            return NAME;
        }

        public List getEvents() {
            ArrayList events = new ArrayList();
            try {
                SimpleImporter importer = new SimpleImporter();
                importer.setIncludeLeadingCDataIntoStartElementCallback(true);
                ResponseHandler handler = new ResponseHandler(events);
                importer.addSimpleImportHandler(handler);
                importer.parse(new InputSource(this.getResponseBodyAsStream()));
                return handler.getEvents();
            }
            catch (Throwable exception) {
                logger.log(Level.SEVERE, "Exception while polling for new events: ", exception);
                return events;
            }
        }

        private class ResponseHandler
        extends DefaultSimpleImportHandler {
            private List events;
            private int id;
            private Event event;
            private boolean parseEvents;

            public ResponseHandler(List listeners) {
                this.events = listeners;
            }

            public List getEvents() {
                return this.events;
            }

            public void startElement(SimplePath path, String name, AttributesImpl attributes, String leadingCDdata) {
                if (path.matches(PollMethod.STATUS)) {
                    this.parseEvents = false;
                    if (leadingCDdata.equals(PollMethod.STATUS_OK)) {
                        this.parseEvents = true;
                    }
                }
                if (this.parseEvents) {
                    if (path.matches(":subscriptionID/li")) {
                        this.id = Integer.valueOf(leadingCDdata);
                        this.event = new Event(this.id);
                        this.events.add(this.event);
                    } else if (path.matches(PollMethod.INFORMATION)) {
                        String key = attributes.getValue(PollMethod.A_NAME);
                        String value = leadingCDdata;
                        this.event.addInformation(key, value);
                    }
                }
            }
        }
    }

    private class ConnectionThread
    extends Thread {
        private Socket socket = null;

        public ConnectionThread(Socket socket) {
            super("ConnectionThread");
            this.socket = socket;
        }

        public void run() {
            try {
                BufferedReader in = new BufferedReader(new InputStreamReader(this.socket.getInputStream()));
                NotificationListener.this.parseNotification(in);
                this.socket.close();
            }
            catch (IOException e) {
                logger.log(Level.SEVERE, "Error while listening to connection", e);
            }
        }
    }

    private class Subscription {
        private int id;
        private String uri;
        private Subscriber subscriber;

        public Subscription(int id, String uri, Subscriber subscriber) {
            this.id = id;
            this.uri = uri;
            this.subscriber = subscriber;
        }

        public void fireEvent(Map information) {
            this.subscriber.notify(this.uri, information);
        }

        public Subscriber getSubscriber() {
            return this.subscriber;
        }

        public int getId() {
            return this.id;
        }
    }

    public class Event {
        int id;
        Map information = new HashMap();

        public Event() {
        }

        public Event(int id) {
            this.id = id;
        }

        public Event(Map information) {
            this.information = information;
        }

        public void setId(int id) {
            this.id = id;
        }

        public int getId() {
            return this.id;
        }

        public void addInformation(String key, String value) {
            this.information.put(key, value);
        }

        public Map getInformation() {
            return this.information;
        }
    }
}

