/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.proxy.impl.factory.session.service;

import java.util.Set;
import org.jboss.aop.Advisor;
import org.jboss.aop.advice.Interceptor;
import org.jboss.ejb3.proxy.impl.factory.session.service.ServiceProxyFactory;
import org.jboss.ejb3.proxy.impl.factory.session.service.ServiceProxyFactoryBase;
import org.jboss.ejb3.proxy.impl.handler.session.SessionRemoteProxyInvocationHandler;
import org.jboss.logging.Logger;
import org.jboss.metadata.ejb.jboss.JBossServiceBeanMetaData;

public class ServiceRemoteProxyFactory
extends ServiceProxyFactoryBase
implements ServiceProxyFactory {
    private static final Logger logger = Logger.getLogger(ServiceRemoteProxyFactory.class);
    private static final String DEFAULT_STACK_NAME_STATELESS_SESSION_CLIENT_INTERCEPTORS = "ServiceClientInterceptors";
    private String url;
    private String interceptorStackName;

    public ServiceRemoteProxyFactory(String name, String containerName, String containerGuid, JBossServiceBeanMetaData metadata, ClassLoader classloader, String url, Advisor advisor, String interceptorStackName) {
        super(name, containerName, containerGuid, metadata, classloader, advisor);
        this.setUrl(url);
        this.setInterceptorStackName(interceptorStackName);
    }

    @Override
    protected final Set<String> getBusinessInterfaceTypes() {
        return this.getMetadata().getBusinessRemotes();
    }

    @Override
    protected String getInterceptorStackName() {
        String stackName = DEFAULT_STACK_NAME_STATELESS_SESSION_CLIENT_INTERCEPTORS;
        String overrideName = this.interceptorStackName;
        if (overrideName != null && overrideName.trim().length() > 0) {
            stackName = overrideName;
        }
        return stackName;
    }

    @Override
    protected SessionRemoteProxyInvocationHandler createInvocationHandler() {
        String containerName = this.getContainerName();
        String containerGuid = this.getContainerGuid();
        String url = this.getUrl();
        Interceptor[] interceptors = this.getInterceptors();
        SessionRemoteProxyInvocationHandler handler = new SessionRemoteProxyInvocationHandler(containerName, containerGuid, interceptors, null, url);
        return handler;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    protected void setInterceptorStackName(String interceptorStackName) {
        this.interceptorStackName = interceptorStackName;
    }
}

