/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.interceptors;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.jboss.cache.Fqn;
import org.jboss.cache.InvocationContext;
import org.jboss.cache.NodeSPI;
import org.jboss.cache.commands.write.EvictCommand;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.factories.annotations.Inject;
import org.jboss.cache.interceptors.base.JmxStatsCommandInterceptor;
import org.jboss.cache.jmx.annotations.ManagedAttribute;
import org.jboss.cache.jmx.annotations.ManagedOperation;
import org.jboss.cache.loader.CacheLoader;
import org.jboss.cache.loader.CacheLoaderManager;
import org.jboss.cache.notifications.Notifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PassivationInterceptor
extends JmxStatsCommandInterceptor {
    private final AtomicLong passivations = new AtomicLong(0L);
    protected CacheLoader loader;
    private Notifier notifier;

    @Inject
    public void setDependencies(Notifier notifier, CacheLoaderManager loaderManager) {
        this.notifier = notifier;
        this.loader = loaderManager.getCacheLoader();
    }

    @Override
    public Object visitEvictFqnCommand(InvocationContext ctx, EvictCommand command) throws Throwable {
        if (command.isRecursive()) {
            for (Fqn f : command.getNodesToEvict()) {
                this.passivate(ctx, f);
            }
        } else {
            this.passivate(ctx, command.getFqn());
        }
        return this.invokeNextInterceptor(ctx, command);
    }

    protected void passivate(InvocationContext ctx, Fqn fqn) throws Throwable {
        block4: {
            try {
                Map attributes = this.getNodeAttributes(ctx, fqn);
                this.notifier.notifyNodePassivated(fqn, true, attributes, ctx);
                if (this.trace) {
                    this.log.trace((Object)("Passivating " + fqn));
                }
                this.loader.put(fqn, attributes);
                this.notifier.notifyNodePassivated(fqn, false, Collections.emptyMap(), ctx);
                if (this.getStatisticsEnabled()) {
                    this.passivations.getAndIncrement();
                }
            }
            catch (NodeNotLoadedException e) {
                if (!this.trace) break block4;
                this.log.trace((Object)("Node " + fqn + " not loaded in memory; passivation skipped"));
            }
        }
    }

    private Map getNodeAttributes(InvocationContext ctx, Fqn fqn) throws NodeNotLoadedException {
        if (fqn == null) {
            throw new NodeNotLoadedException();
        }
        NodeSPI n = ctx.lookUpNode(fqn);
        if (n == null) {
            throw new NodeNotLoadedException();
        }
        if (this.configuration.getNodeLockingScheme() != Configuration.NodeLockingScheme.OPTIMISTIC && !n.isDataLoaded()) {
            throw new NodeNotLoadedException();
        }
        return n.getDataDirect();
    }

    @Override
    @ManagedOperation
    public void resetStatistics() {
        this.passivations.set(0L);
    }

    @Override
    @ManagedOperation
    public Map<String, Object> dumpStatistics() {
        HashMap<String, Object> retval = new HashMap<String, Object>();
        retval.put("Passivations", this.passivations.get());
        return retval;
    }

    @ManagedAttribute(description="number of cache node passivations")
    public long getPassivations() {
        return this.passivations.get();
    }

    private static class NodeNotLoadedException
    extends Exception {
        private static final long serialVersionUID = -4078972305344328905L;

        private NodeNotLoadedException() {
        }
    }
}

