/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log.output;

import org.apache.log.LogEvent;
import org.apache.log.format.Formatter;
import org.apache.log.output.AbstractTarget;

public abstract class AbstractOutputTarget
extends AbstractTarget {
    protected Formatter m_formatter;

    public AbstractOutputTarget() {
    }

    public AbstractOutputTarget(Formatter formatter) {
        this.m_formatter = formatter;
    }

    public synchronized Formatter getFormatter() {
        return this.m_formatter;
    }

    public synchronized void setFormatter(Formatter formatter) {
        this.writeTail();
        this.m_formatter = formatter;
        this.writeHead();
    }

    protected void write(String data) {
        this.output(data);
    }

    protected void output(String data) {
    }

    @Override
    protected void doProcessEvent(LogEvent event) {
        String data = this.format(event);
        this.write(data);
    }

    @Override
    protected synchronized void open() {
        if (!this.isOpen()) {
            super.open();
            this.writeHead();
        }
    }

    @Override
    public synchronized void close() {
        if (this.isOpen()) {
            this.writeTail();
            super.close();
        }
    }

    private String format(LogEvent event) {
        if (null != this.m_formatter) {
            return this.m_formatter.format(event);
        }
        return event.toString();
    }

    private void writeHead() {
        if (!this.isOpen()) {
            return;
        }
        String head = this.getHead();
        if (null != head) {
            this.write(head);
        }
    }

    private void writeTail() {
        if (!this.isOpen()) {
            return;
        }
        String tail = this.getTail();
        if (null != tail) {
            this.write(tail);
        }
    }

    private String getHead() {
        return null;
    }

    private String getTail() {
        return null;
    }
}

