/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.util;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.util.HashMap;
import org.jboss.aop.util.Advisable;
import org.jboss.reflect.spi.ArrayInfo;
import org.jboss.reflect.spi.ClassInfo;
import org.jboss.reflect.spi.ConstructorInfo;
import org.jboss.reflect.spi.MethodInfo;
import org.jboss.reflect.spi.PrimitiveInfo;
import org.jboss.reflect.spi.TypeInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassInfoMethodHashing {
    public static long methodHash(MethodInfo methodInfo) {
        try {
            TypeInfo[] parameterTypes = methodInfo.getParameterTypes();
            String methodDesc = methodInfo.getName() + "(";
            for (int j = 0; j < parameterTypes.length; ++j) {
                methodDesc = methodDesc + ClassInfoMethodHashing.getTypeString(parameterTypes[j]);
            }
            methodDesc = methodDesc + ")" + ClassInfoMethodHashing.getTypeString(methodInfo.getReturnType());
            long hash = 0L;
            ByteArrayOutputStream bytearrayoutputstream = new ByteArrayOutputStream(512);
            MessageDigest messagedigest = MessageDigest.getInstance("SHA");
            DataOutputStream dataoutputstream = new DataOutputStream(new DigestOutputStream(bytearrayoutputstream, messagedigest));
            dataoutputstream.writeUTF(methodDesc);
            dataoutputstream.flush();
            byte[] abyte0 = messagedigest.digest();
            for (int j = 0; j < Math.min(8, abyte0.length); ++j) {
                hash += (long)(abyte0[j] & 0xFF) << j * 8;
            }
            return hash;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static long constructorHash(ConstructorInfo constructorInfo) {
        try {
            TypeInfo[] parameterTypes = constructorInfo.getParameterTypes();
            String methodDesc = constructorInfo.getDeclaringClass().getName() + "(";
            for (int j = 0; j < parameterTypes.length; ++j) {
                methodDesc = methodDesc + ClassInfoMethodHashing.getTypeString(parameterTypes[j]);
            }
            methodDesc = methodDesc + ")";
            long hash = 0L;
            ByteArrayOutputStream bytearrayoutputstream = new ByteArrayOutputStream(512);
            MessageDigest messagedigest = MessageDigest.getInstance("SHA");
            DataOutputStream dataoutputstream = new DataOutputStream(new DigestOutputStream(bytearrayoutputstream, messagedigest));
            dataoutputstream.writeUTF(methodDesc);
            dataoutputstream.flush();
            byte[] abyte0 = messagedigest.digest();
            for (int j = 0; j < Math.min(8, abyte0.length); ++j) {
                hash += (long)(abyte0[j] & 0xFF) << j * 8;
            }
            return hash;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static String getTypeString(TypeInfo cl) throws Exception {
        if (cl.getClass().equals(PrimitiveInfo.class)) {
            if (cl.equals(PrimitiveInfo.BYTE)) {
                return "B";
            }
            if (cl.equals(PrimitiveInfo.CHAR)) {
                return "C";
            }
            if (cl.equals(PrimitiveInfo.DOUBLE)) {
                return "D";
            }
            if (cl.equals(PrimitiveInfo.FLOAT)) {
                return "F";
            }
            if (cl.equals(PrimitiveInfo.INT)) {
                return "I";
            }
            if (cl.equals(PrimitiveInfo.LONG)) {
                return "J";
            }
            if (cl.equals(PrimitiveInfo.SHORT)) {
                return "S";
            }
            if (cl.equals(PrimitiveInfo.BOOLEAN)) {
                return "Z";
            }
            if (cl.equals(PrimitiveInfo.VOID)) {
                return "V";
            }
            throw new RuntimeException("Invalid primitive info " + cl);
        }
        if (cl.isArray()) {
            TypeInfo arrayType = ((ArrayInfo)cl).getComponentType();
            return "[" + ClassInfoMethodHashing.getTypeString(arrayType);
        }
        return "L" + cl.getName().replace('.', '/') + ";";
    }

    private static void addDeclaredMethods(HashMap<Long, MethodInfo> advised, ClassInfo superclass) throws Exception {
        MethodInfo[] declaredMethods = superclass.getDeclaredMethods();
        if (declaredMethods != null) {
            for (int i = 0; i < declaredMethods.length; ++i) {
                if (!superclass.isInterface() && !Advisable.isAdvisableMethod(declaredMethods[i].getModifiers(), declaredMethods[i].getName())) continue;
                long hash = ClassInfoMethodHashing.methodHash(declaredMethods[i]);
                advised.put(hash, declaredMethods[i]);
            }
        }
    }

    private static void populateMethodTables(HashMap<Long, MethodInfo> advised, ClassInfo superclass) throws Exception {
        if (superclass == null) {
            return;
        }
        if (superclass.getName().equals("java.lang.Object")) {
            return;
        }
        ClassInfoMethodHashing.populateMethodTables(advised, superclass.getSuperclass());
        ClassInfoMethodHashing.addDeclaredMethods(advised, superclass);
    }

    public static HashMap<Long, MethodInfo> getMethodMap(ClassInfo clazz) throws Exception {
        HashMap<Long, MethodInfo> map = new HashMap<Long, MethodInfo>();
        ClassInfoMethodHashing.populateMethodTables(map, clazz);
        return map;
    }

    public static HashMap<Long, MethodInfo> getDeclaredMethodMap(ClassInfo clazz) throws Exception {
        HashMap<Long, MethodInfo> map = new HashMap<Long, MethodInfo>();
        ClassInfoMethodHashing.addDeclaredMethods(map, clazz);
        return map;
    }
}

