/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.httpclient;

import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.util.URIUtil;

public class HttpURL
extends URI {
    public static final char[] DEFAULT_SCHEME = new char[]{'h', 't', 't', 'p'};
    public static final char[] _default_scheme = DEFAULT_SCHEME;
    public static final int DEFAULT_PORT = 80;
    public static final int _default_port = 80;
    static final long serialVersionUID = -7158031098595039459L;

    protected HttpURL() {
    }

    public HttpURL(char[] cArray, String string) throws URIException, NullPointerException {
        this.protocolCharset = string;
        this.parseUriReference(new String(cArray), true);
        this.checkValid();
    }

    public HttpURL(char[] cArray) throws URIException, NullPointerException {
        this.parseUriReference(new String(cArray), true);
        this.checkValid();
    }

    public HttpURL(String string, String string2) throws URIException {
        this.protocolCharset = string2;
        this.parseUriReference(string, false);
        this.checkValid();
    }

    public HttpURL(String string) throws URIException {
        this.parseUriReference(string, false);
        this.checkValid();
    }

    public HttpURL(String string, int n, String string2) throws URIException {
        this(null, null, string, n, string2, null, null);
    }

    public HttpURL(String string, int n, String string2, String string3) throws URIException {
        this(null, null, string, n, string2, string3, null);
    }

    public HttpURL(String string, String string2, String string3) throws URIException {
        this(string, string2, string3, -1, null, null, null);
    }

    public HttpURL(String string, String string2, String string3, int n) throws URIException {
        this(string, string2, string3, n, null, null, null);
    }

    public HttpURL(String string, String string2, String string3, int n, String string4) throws URIException {
        this(string, string2, string3, n, string4, null, null);
    }

    public HttpURL(String string, String string2, String string3, int n, String string4, String string5) throws URIException {
        this(string, string2, string3, n, string4, string5, null);
    }

    public HttpURL(String string, String string2, String string3, String string4) throws URIException {
        this(null, null, string, -1, string2, string3, string4);
    }

    public HttpURL(String string, String string2, String string3, String string4, String string5) throws URIException {
        this(string, string2, -1, string3, string4, string5);
    }

    public HttpURL(String string, String string2, int n, String string3) throws URIException {
        this(string, string2, n, string3, null, null);
    }

    public HttpURL(String string, String string2, int n, String string3, String string4) throws URIException {
        this(string, string2, n, string3, string4, null);
    }

    public HttpURL(String string, String string2, int n, String string3, String string4, String string5) throws URIException {
        StringBuffer stringBuffer = new StringBuffer();
        if (string != null || string2 != null || n != -1) {
            this._scheme = DEFAULT_SCHEME;
            stringBuffer.append(_default_scheme);
            stringBuffer.append("://");
            if (string != null) {
                stringBuffer.append(string);
                stringBuffer.append('@');
            }
            if (string2 != null) {
                stringBuffer.append(URIUtil.encode(string2, URI.allowed_host));
                if (n != -1 || n != 80) {
                    stringBuffer.append(':');
                    stringBuffer.append(n);
                }
            }
        }
        if (string3 != null) {
            if (scheme != null && !string3.startsWith("/")) {
                throw new URIException(1, "abs_path requested");
            }
            stringBuffer.append(URIUtil.encode(string3, URI.allowed_abs_path));
        }
        if (string4 != null) {
            stringBuffer.append('?');
            stringBuffer.append(URIUtil.encode(string4, URI.allowed_query));
        }
        if (string5 != null) {
            stringBuffer.append('#');
            stringBuffer.append(URIUtil.encode(string5, URI.allowed_fragment));
        }
        this.parseUriReference(stringBuffer.toString(), true);
        this.checkValid();
    }

    public HttpURL(String string, String string2, String string3, int n, String string4, String string5, String string6) throws URIException {
        this(HttpURL.toUserinfo(string, string2), string3, n, string4, string5, string6);
    }

    protected static String toUserinfo(String string, String string2) throws URIException {
        if (string == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(20);
        stringBuffer.append(URIUtil.encode(string, URI.allowed_within_userinfo));
        if (string2 == null) {
            return stringBuffer.toString();
        }
        stringBuffer.append(':');
        stringBuffer.append(URIUtil.encode(string2, URI.allowed_within_userinfo));
        return stringBuffer.toString();
    }

    public HttpURL(HttpURL httpURL, String string) throws URIException {
        this(httpURL, new HttpURL(string));
    }

    public HttpURL(HttpURL httpURL, HttpURL httpURL2) throws URIException {
        super((URI)httpURL, httpURL2);
        this.checkValid();
    }

    @Override
    public char[] getRawScheme() {
        return this._scheme == null ? null : DEFAULT_SCHEME;
    }

    @Override
    public String getScheme() {
        return this._scheme == null ? null : new String(DEFAULT_SCHEME);
    }

    @Override
    public int getPort() {
        return this._port == -1 ? 80 : this._port;
    }

    public void setRawUserinfo(char[] cArray, char[] cArray2) throws URIException {
        if (cArray == null || cArray.length == 0) {
            throw new URIException(1, "user required");
        }
        if (!this.validate(cArray, within_userinfo) || cArray2 != null && !this.validate(cArray2, within_userinfo)) {
            throw new URIException(3, "escaped userinfo not valid");
        }
        String string = new String(cArray);
        String string2 = cArray2 == null ? null : new String(cArray2);
        String string3 = string + (string2 == null ? "" : ":" + string2);
        String string4 = new String(this.getRawHost());
        String string5 = this._port == -1 ? string4 : string4 + ":" + this._port;
        String string6 = string3 + "@" + string5;
        this._userinfo = string3.toCharArray();
        this._authority = string6.toCharArray();
        this.setURI();
    }

    public void setEscapedUserinfo(String string, String string2) throws URIException, NullPointerException {
        this.setRawUserinfo(string.toCharArray(), string2 == null ? null : string2.toCharArray());
    }

    public void setUserinfo(String string, String string2) throws URIException, NullPointerException {
        String string3 = this.getProtocolCharset();
        this.setRawUserinfo(HttpURL.encode(string, within_userinfo, string3), string2 == null ? null : HttpURL.encode(string2, within_userinfo, string3));
    }

    public void setRawUser(char[] cArray) throws URIException {
        if (cArray == null || cArray.length == 0) {
            throw new URIException(1, "user required");
        }
        if (!this.validate(cArray, within_userinfo)) {
            throw new URIException(3, "escaped user not valid");
        }
        String string = new String(cArray);
        char[] cArray2 = this.getRawPassword();
        String string2 = cArray2 == null ? null : new String(cArray2);
        String string3 = string + (string2 == null ? "" : ":" + string2);
        String string4 = new String(this.getRawHost());
        String string5 = this._port == -1 ? string4 : string4 + ":" + this._port;
        String string6 = string3 + "@" + string5;
        this._userinfo = string3.toCharArray();
        this._authority = string6.toCharArray();
        this.setURI();
    }

    public void setEscapedUser(String string) throws URIException, NullPointerException {
        this.setRawUser(string.toCharArray());
    }

    public void setUser(String string) throws URIException, NullPointerException {
        this.setRawUser(HttpURL.encode(string, allowed_within_userinfo, this.getProtocolCharset()));
    }

    public char[] getRawUser() {
        if (this._userinfo == null || this._userinfo.length == 0) {
            return null;
        }
        int n = this.indexFirstOf(this._userinfo, ':');
        if (n == -1) {
            return this._userinfo;
        }
        char[] cArray = new char[n];
        System.arraycopy(this._userinfo, 0, cArray, 0, n);
        return cArray;
    }

    public String getEscapedUser() {
        char[] cArray = this.getRawUser();
        return cArray == null ? null : new String(cArray);
    }

    public String getUser() throws URIException {
        char[] cArray = this.getRawUser();
        return cArray == null ? null : HttpURL.decode(cArray, this.getProtocolCharset());
    }

    public void setRawPassword(char[] cArray) throws URIException {
        if (cArray != null && !this.validate(cArray, within_userinfo)) {
            throw new URIException(3, "escaped password not valid");
        }
        if (this.getRawUser() == null || this.getRawUser().length == 0) {
            throw new URIException(1, "username required");
        }
        String string = new String(this.getRawUser());
        String string2 = cArray == null ? null : new String(cArray);
        String string3 = string + (string2 == null ? "" : ":" + string2);
        String string4 = new String(this.getRawHost());
        String string5 = this._port == -1 ? string4 : string4 + ":" + this._port;
        String string6 = string3 + "@" + string5;
        this._userinfo = string3.toCharArray();
        this._authority = string6.toCharArray();
        this.setURI();
    }

    public void setEscapedPassword(String string) throws URIException {
        this.setRawPassword(string == null ? null : string.toCharArray());
    }

    public void setPassword(String string) throws URIException {
        this.setRawPassword(string == null ? null : HttpURL.encode(string, allowed_within_userinfo, this.getProtocolCharset()));
    }

    public char[] getRawPassword() {
        int n = this.indexFirstOf(this._userinfo, ':');
        if (n == -1) {
            return null;
        }
        int n2 = this._userinfo.length - n - 1;
        char[] cArray = new char[n2];
        System.arraycopy(this._userinfo, n + 1, cArray, 0, n2);
        return cArray;
    }

    public String getEscapedPassword() {
        char[] cArray = this.getRawPassword();
        return cArray == null ? null : new String(cArray);
    }

    public String getPassword() throws URIException {
        char[] cArray = this.getRawPassword();
        return cArray == null ? null : HttpURL.decode(cArray, this.getProtocolCharset());
    }

    @Override
    public char[] getRawCurrentHierPath() throws URIException {
        return this._path == null || this._path.length == 0 ? rootPath : super.getRawCurrentHierPath(this._path);
    }

    @Override
    public char[] getRawAboveHierPath() throws URIException {
        char[] cArray = this.getRawCurrentHierPath();
        return cArray == null || cArray.length == 0 ? rootPath : this.getRawCurrentHierPath(cArray);
    }

    @Override
    public char[] getRawPath() {
        char[] cArray = super.getRawPath();
        return cArray == null || cArray.length == 0 ? rootPath : cArray;
    }

    public void setQuery(String string, String string2) throws URIException, NullPointerException {
        StringBuffer stringBuffer = new StringBuffer();
        String string3 = this.getProtocolCharset();
        stringBuffer.append(HttpURL.encode(string, allowed_within_query, string3));
        stringBuffer.append('=');
        stringBuffer.append(HttpURL.encode(string2, allowed_within_query, string3));
        this._query = stringBuffer.toString().toCharArray();
        this.setURI();
    }

    public void setQuery(String[] stringArray, String[] stringArray2) throws URIException, NullPointerException {
        int n = stringArray.length;
        if (n != stringArray2.length) {
            throw new URIException("wrong array size of query");
        }
        StringBuffer stringBuffer = new StringBuffer();
        String string = this.getProtocolCharset();
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(HttpURL.encode(stringArray[i], allowed_within_query, string));
            stringBuffer.append('=');
            stringBuffer.append(HttpURL.encode(stringArray2[i], allowed_within_query, string));
            if (i + 1 >= n) continue;
            stringBuffer.append('&');
        }
        this._query = stringBuffer.toString().toCharArray();
        this.setURI();
    }

    protected void checkValid() throws URIException {
        if (!this.equals(this._scheme, DEFAULT_SCHEME) && this._scheme != null) {
            throw new URIException(1, "wrong class use");
        }
    }

    @Override
    protected void setURI() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this._scheme != null) {
            stringBuffer.append(this._scheme);
            stringBuffer.append(':');
        }
        if (this._is_net_path) {
            stringBuffer.append("//");
            if (this._authority != null) {
                if (this._userinfo != null) {
                    if (this._host != null) {
                        stringBuffer.append(this._host);
                        if (this._port != -1) {
                            stringBuffer.append(':');
                            stringBuffer.append(this._port);
                        }
                    }
                } else {
                    stringBuffer.append(this._authority);
                }
            }
        }
        if (this._opaque != null && this._is_opaque_part) {
            stringBuffer.append(this._opaque);
        } else if (this._path != null && this._path.length != 0) {
            stringBuffer.append(this._path);
        }
        if (this._query != null) {
            stringBuffer.append('?');
            stringBuffer.append(this._query);
        }
        this._uri = stringBuffer.toString().toCharArray();
        this.hash = 0;
    }
}

