/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jms.server;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.management.Notification;
import javax.management.ObjectName;
import org.jboss.logging.Logger;
import org.jboss.messaging.core.contract.PersistenceManager;
import org.jboss.messaging.core.impl.postoffice.MessagingPostOffice;
import org.jboss.messaging.util.JMXAccessor;
import org.jboss.system.ServiceMBeanSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessagingClusterHealthMBean
extends ServiceMBeanSupport {
    private static final Logger log = Logger.getLogger(MessagingClusterHealthMBean.class);
    private String serverPeer;
    private String postOffice;
    private List<ObjectName> connectionFactories;
    private List<ObjectName> destinations;
    private String persistenceManager;
    private boolean nodeStopped;
    private NodeRecovery nodeRecovery;
    private long shutdownDelay;

    public void startService() throws Exception {
        this.connectionFactories = new ArrayList<ObjectName>();
        this.destinations = new ArrayList<ObjectName>();
        log.info((Object)((Object)((Object)this) + " started."));
    }

    public void stopService() throws Exception {
        this.setServerPeer(null);
        this.setPostOffice(null);
        this.setPersistenceManager(null);
        this.connectionFactories.clear();
        this.destinations.clear();
        if (this.nodeRecovery != null) {
            this.nodeRecovery.abandon();
            this.nodeRecovery = null;
        }
        log.info((Object)((Object)((Object)this) + " stopped."));
    }

    public Object getInstance() {
        return this;
    }

    public synchronized void stopNodeOnDBFailure() throws Exception {
        if (this.nodeStopped) {
            return;
        }
        log.info((Object)"Stopping JBM node on DB failure...");
        this.stopServices(this.destinations);
        this.stopServices(this.connectionFactories);
        ObjectName postOfficeServiceName = new ObjectName(this.postOffice);
        this.getShutdownDelay(postOfficeServiceName);
        this.stopService(postOfficeServiceName);
        ObjectName serverPeerName = new ObjectName(this.serverPeer);
        this.stopService(serverPeerName);
        this.nodeStopped = true;
        this.nodeRecovery = new NodeRecovery();
        this.nodeRecovery.start();
        Notification msg = new Notification("org.jboss.jms.server.MessagingClusterHealthMBean.stopNodeOnDBFailure", (Object)this, this.getNextNotificationSequenceNumber());
        msg.setUserData(this.getServiceName());
        this.sendNotification(msg);
        log.info((Object)"JBM node is stopped.");
    }

    private void getShutdownDelay(ObjectName postOfficeServiceName) {
        try {
            long nodeRefreshInterval = (Long)this.server.getAttribute(postOfficeServiceName, "NodeStateRefreshInterval");
            this.shutdownDelay = nodeRefreshInterval * 2L;
        }
        catch (Exception e) {
            log.warn((Object)"Failed to get node refresh interval, use default.", (Throwable)e);
            this.shutdownDelay = 30000L;
        }
    }

    private void stopService(ObjectName service) throws Exception {
        try {
            this.server.invoke(service, "stop", new Object[0], new String[0]);
            log.debug((Object)("Service " + this.serviceName + " stopped."));
        }
        catch (Exception e) {
            log.warn((Object)("Error stopping service " + this.serviceName), (Throwable)e);
        }
    }

    private void stopServices(List<ObjectName> services) throws Exception {
        for (ObjectName serviceName : services) {
            this.stopService(serviceName);
        }
    }

    public void setServerPeer(String serverPeer) {
        this.serverPeer = serverPeer;
    }

    public String getServerPeer() {
        return this.serverPeer;
    }

    public void setPostOffice(String postOffice) {
        this.postOffice = postOffice;
    }

    public String getPostOffice() {
        return this.postOffice;
    }

    public void setPersistenceManager(String persistenceManager) {
        this.persistenceManager = persistenceManager;
    }

    public String getPersistenceManager() {
        return this.persistenceManager;
    }

    private boolean checkDBConnection() throws Exception {
        ObjectName pmName = new ObjectName(this.persistenceManager);
        PersistenceManager pm = (PersistenceManager)JMXAccessor.getJMXAttributeOverSecurity(this.server, pmName, "Instance");
        boolean isConnOK = false;
        try {
            isConnOK = pm.checkConnection();
        }
        catch (Exception e) {
            log.warn((Object)"failed to check connection", (Throwable)e);
            isConnOK = false;
        }
        return isConnOK;
    }

    private synchronized void restartJBMNode() throws Exception {
        if (!this.nodeStopped) {
            return;
        }
        this.makeSureDelay();
        log.info((Object)"Restarting JBM node...");
        ObjectName spName = new ObjectName(this.serverPeer);
        this.startService(spName);
        ObjectName poName = new ObjectName(this.postOffice);
        this.startService(poName);
        MessagingPostOffice pm = (MessagingPostOffice)JMXAccessor.getJMXAttributeOverSecurity(this.server, poName, "Instance");
        while (!pm.waitForJGroups()) {
            log.info((Object)"Failed to start post office due to JGroups failure, retrying...");
            this.stopService(poName);
            this.makeSureDelay();
            this.startService(poName);
            pm = (MessagingPostOffice)JMXAccessor.getJMXAttributeOverSecurity(this.server, poName, "Instance");
        }
        ArrayList<ObjectName> copy = new ArrayList<ObjectName>(this.connectionFactories);
        this.connectionFactories.clear();
        this.startServices(copy);
        copy = new ArrayList<ObjectName>(this.destinations);
        this.destinations.clear();
        this.startServices(copy);
        this.nodeStopped = false;
        Notification msg = new Notification("org.jboss.jms.server.MessagingClusterHealthMBean.restartJBMNode", (Object)this, this.getNextNotificationSequenceNumber());
        msg.setUserData(this.getServiceName());
        this.sendNotification(msg);
        log.info((Object)"JBM node restarted.");
    }

    private void makeSureDelay() {
        long delay = this.shutdownDelay;
        long stopTime = System.currentTimeMillis();
        while (delay > 0L) {
            try {
                Thread.sleep(delay);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            delay = this.shutdownDelay - (System.currentTimeMillis() - stopTime);
        }
    }

    private void startService(ObjectName serviceName) throws Exception {
        this.server.invoke(serviceName, "start", new Object[0], new String[0]);
        log.debug((Object)("Service " + serviceName + " started."));
    }

    private void startServices(List<ObjectName> services) throws Exception {
        for (ObjectName serviceName : services) {
            this.startService(serviceName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerFactory(ObjectName serviceName) {
        List<ObjectName> list = this.connectionFactories;
        synchronized (list) {
            this.connectionFactories.add(serviceName);
            log.info((Object)("Registered connection factory " + serviceName));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerDestination(ObjectName serviceName) {
        List<ObjectName> list = this.destinations;
        synchronized (list) {
            this.destinations.add(serviceName);
            log.info((Object)("Registered destination " + serviceName));
        }
    }

    private void restartAllMDBs() {
        Set<ObjectName> mbeanNames = this.server.queryNames(null, null);
        for (ObjectName objName : mbeanNames) {
            try {
                this.server.invoke(objName, "stopDelivery", new Object[0], null);
                this.server.invoke(objName, "startDelivery", new Object[0], null);
                log.debug((Object)("Restarted Delivery for: " + objName.getCanonicalName()));
            }
            catch (Exception e) {
                log.trace((Object)("Restarting message delivery on: " + objName.getCanonicalName() + " produced:"));
                log.trace((Object)e);
            }
        }
    }

    private class NodeRecovery
    extends Thread {
        private boolean keepTrying = true;

        public NodeRecovery() {
            this.setDaemon(true);
        }

        public synchronized void abandon() {
            this.keepTrying = false;
            this.notify();
        }

        public synchronized void run() {
            try {
                while (this.keepTrying) {
                    if (MessagingClusterHealthMBean.this.checkDBConnection()) {
                        MessagingClusterHealthMBean.this.restartJBMNode();
                        break;
                    }
                    try {
                        this.wait(5000L);
                    }
                    catch (InterruptedException e) {}
                }
            }
            catch (Exception e) {
                log.error((Object)"Getting exception, stop recovery.", (Throwable)e);
            }
        }
    }
}

