/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.debug.Simulator;
import org.jgroups.protocols.PingHeader;
import org.jgroups.protocols.TCPPING;
import org.jgroups.stack.IpAddress;
import org.jgroups.stack.Protocol;

public class TCPPINGTest
extends TestCase {
    IpAddress a1;
    IpAddress a2;
    Simulator s;
    MessageInterceptor interceptor;
    String old_initial_hosts;

    public TCPPINGTest(String name) {
        super(name);
    }

    public void setUp() throws Exception {
        this.old_initial_hosts = System.clearProperty("jgroups.tcpping.initial_hosts");
        super.setUp();
        this.a1 = new IpAddress(1111);
        this.a2 = new IpAddress(2222);
        Vector<Address> members = new Vector<Address>();
        members.add(this.a1);
        View v = new View(this.a1, 1L, members);
        this.s = new Simulator();
        this.s.setLocalAddress(this.a1);
        this.s.setView(v);
        this.s.addMember(this.a1);
        TCPPING tcpping = new TCPPING();
        Properties props = new Properties();
        props.setProperty("initial_hosts", "127.0.0.1[1111],127.0.0.1[2222]");
        props.setProperty("max_dynamic_hosts", "10");
        tcpping.setPropertiesInternal(props);
        this.interceptor = new MessageInterceptor();
        Protocol[] stack = new Protocol[]{tcpping, this.interceptor};
        this.s.setProtocolStack(stack);
        this.s.start();
    }

    public void tearDown() throws Exception {
        super.tearDown();
        this.s.stop();
        System.setProperty("jgroups.tcpping.initial_hosts", this.old_initial_hosts);
    }

    public void testTCPPING() throws InterruptedException {
        Event evt = new Event(12);
        this.s.send(evt);
        Set<Address> pinged = this.interceptor.getPinged();
        TCPPINGTest.assertEquals((int)1, (int)pinged.size());
        TCPPINGTest.assertFalse((boolean)pinged.contains(this.a1));
        TCPPINGTest.assertTrue((boolean)pinged.contains(this.a2));
    }

    public void testDynamicMembers() throws InterruptedException {
        IpAddress a3 = new IpAddress(3333);
        Vector<Address> members = new Vector<Address>();
        members.add(this.a1);
        members.add(a3);
        View v = new View(this.a1, 2L, members);
        Event evt = new Event(6, v);
        this.s.send(evt);
        evt = new Event(12);
        this.s.send(evt);
        Set<Address> pinged = this.interceptor.getPinged();
        TCPPINGTest.assertEquals((int)2, (int)pinged.size());
        TCPPINGTest.assertFalse((boolean)pinged.contains(this.a1));
        TCPPINGTest.assertTrue((boolean)pinged.contains(this.a2));
        TCPPINGTest.assertTrue((boolean)pinged.contains(a3));
    }

    public static Test suite() {
        return new TestSuite(TCPPINGTest.class);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)TCPPINGTest.suite());
    }

    static class MessageInterceptor
    extends Protocol {
        Set<Address> pinged;

        public MessageInterceptor() {
            this.reset();
        }

        @Override
        public String getName() {
            return "MessageInterceptor";
        }

        public void reset() {
            this.pinged = new HashSet<Address>();
        }

        @Override
        public Object down(Event evt) {
            Message msg;
            PingHeader hdr;
            if (evt.getType() == 1 && (hdr = (PingHeader)(msg = (Message)evt.getArg()).getHeader("TCPPING")) != null && hdr.type == 1) {
                this.pinged.add(msg.getDest());
            }
            return super.down(evt);
        }

        public Set<Address> getPinged() {
            return this.pinged;
        }
    }
}

