/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.util.Vector;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.debug.Simulator;
import org.jgroups.protocols.pbcast.NAKACK;
import org.jgroups.protocols.pbcast.NakAckHeader;
import org.jgroups.stack.IpAddress;
import org.jgroups.stack.Protocol;
import org.jgroups.util.Digest;
import org.jgroups.util.Range;

public class NAKACK_REBROADCAST_Test
extends TestCase {
    IpAddress a1;
    IpAddress a2;
    NAKACK nak;
    MessageInterceptor interceptor;
    Simulator s;

    public NAKACK_REBROADCAST_Test(String name) {
        super(name);
    }

    public void setUp() throws Exception {
        super.setUp();
        this.a1 = new IpAddress(1111);
        this.a2 = new IpAddress(2222);
        Vector<Address> members = new Vector<Address>();
        members.add(this.a1);
        members.add(this.a2);
        View v = new View(this.a1, 1L, members);
        this.s = new Simulator();
        this.s.setLocalAddress(this.a1);
        this.s.setView(v);
        this.s.addMember(this.a1);
        NAKACK nak = new NAKACK();
        this.interceptor = new MessageInterceptor();
        Protocol[] stack = new Protocol[]{nak, this.interceptor};
        this.s.setProtocolStack(stack);
        this.s.start();
    }

    public void tearDown() throws Exception {
        super.tearDown();
        this.s.stop();
    }

    public void testRebroadcast() throws InterruptedException {
        Digest digest = new Digest(this.a2, 0L, 2L, 2L);
        Event evt = new Event(78, digest);
        this.s.send(evt);
        Range range = this.interceptor.getRange();
        this.interceptor.reset();
        NAKACK_REBROADCAST_Test.assertNotNull((Object)range);
        NAKACK_REBROADCAST_Test.assertEquals((long)1L, (long)range.low);
        NAKACK_REBROADCAST_Test.assertEquals((long)2L, (long)range.high);
    }

    public void testRebroadcastSingle() throws InterruptedException {
        Digest digest = new Digest(this.a2, 0L, 1L, 1L);
        Event evt = new Event(78, digest);
        this.s.send(evt);
        Range range = this.interceptor.getRange();
        this.interceptor.reset();
        NAKACK_REBROADCAST_Test.assertNotNull((Object)range);
        NAKACK_REBROADCAST_Test.assertEquals((long)1L, (long)range.low);
        NAKACK_REBROADCAST_Test.assertEquals((long)1L, (long)range.high);
    }

    public static Test suite() {
        return new TestSuite(NAKACK_REBROADCAST_Test.class);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)NAKACK_REBROADCAST_Test.suite());
    }

    static class MessageInterceptor
    extends Protocol {
        private Range range;

        @Override
        public String getName() {
            return "MessageInterceptor";
        }

        @Override
        public Object down(Event evt) {
            Message msg;
            NakAckHeader hdr;
            if (evt.getType() == 1 && (hdr = (NakAckHeader)(msg = (Message)evt.getArg()).getHeader("NAKACK")) != null && hdr.type == 2) {
                this.range = hdr.range;
            }
            return super.down(evt);
        }

        public Range getRange() {
            return this.range;
        }

        public void reset() {
            this.range = null;
        }
    }
}

