/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.contexts;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseId;
import org.jboss.seam.Component;
import org.jboss.seam.ScopeType;
import org.jboss.seam.contexts.Context;
import org.jboss.seam.contexts.FacesLifecycle;
import org.jboss.seam.core.Events;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PageContext
implements Context {
    private static final String PAGE_CONTEXT_PREFIX = ScopeType.PAGE.getPrefix() + '$';
    private Map<String, Object> previousPageMap = PageContext.getOrCreateAttributeMap();
    private Map<String, Object> nextPageMap = new HashMap<String, Object>();

    @Override
    public ScopeType getType() {
        return ScopeType.PAGE;
    }

    private String getKey(String name) {
        return this.getPrefix() + name;
    }

    private String getPrefix() {
        return PAGE_CONTEXT_PREFIX;
    }

    @Override
    public Object get(String name) {
        return this.getCurrentReadableMap().get(this.getKey(name));
    }

    @Override
    public boolean isSet(String name) {
        return this.getCurrentReadableMap().containsKey(this.getKey(name));
    }

    private Map<String, Object> getCurrentReadableMap() {
        if (!PageContext.isInPhase()) {
            return Collections.EMPTY_MAP;
        }
        return PageContext.isRenderResponsePhase() ? this.nextPageMap : this.previousPageMap;
    }

    private Map<String, Object> getCurrentWritableMap() {
        return PageContext.isBeforeInvokeApplicationPhase() ? this.previousPageMap : this.nextPageMap;
    }

    @Override
    public void set(String name, Object value) {
        if (Events.exists()) {
            Events.instance().raiseEvent("org.jboss.seam.preSetVariable." + name, new Object[0]);
        }
        this.getCurrentWritableMap().put(this.getKey(name), value);
        if (Events.exists()) {
            Events.instance().raiseEvent("org.jboss.seam.postSetVariable." + name, new Object[0]);
        }
    }

    @Override
    public void remove(String name) {
        if (Events.exists()) {
            Events.instance().raiseEvent("org.jboss.seam.preRemoveVariable." + name, new Object[0]);
        }
        this.getCurrentWritableMap().remove(this.getKey(name));
        if (Events.exists()) {
            Events.instance().raiseEvent("org.jboss.seam.postRemoveVariable." + name, new Object[0]);
        }
    }

    @Override
    public String[] getNames() {
        Set<String> keys = this.getCurrentReadableMap().keySet();
        ArrayList<String> names = new ArrayList<String>(keys.size());
        String prefix = this.getPrefix();
        for (String key : keys) {
            if (!key.startsWith(prefix)) continue;
            names.add(key.substring(prefix.length()));
        }
        return names.toArray(new String[names.size()]);
    }

    public String toString() {
        return "PageContext";
    }

    @Override
    public Object get(Class clazz) {
        return this.get(Component.getComponentName(clazz));
    }

    @Override
    public void flush() {
        Map attributeMap = PageContext.getOrCreateAttributeMap();
        attributeMap.putAll(this.nextPageMap);
        this.nextPageMap = attributeMap;
    }

    private static Map getOrCreateAttributeMap() {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        if (facesContext == null) {
            throw new IllegalStateException("no FacesContext bound to current thread");
        }
        UIViewRoot viewRoot = facesContext.getViewRoot();
        return viewRoot == null ? new HashMap() : viewRoot.getAttributes();
    }

    private static PhaseId getPhaseId() {
        PhaseId phaseId = FacesLifecycle.getPhaseId();
        if (phaseId == null) {
            throw new IllegalStateException("No phase id bound to current thread (make sure you do not have two SeamPhaseListener instances installed)");
        }
        return phaseId;
    }

    private static boolean isInPhase() {
        return FacesLifecycle.getPhaseId() != null;
    }

    private static boolean isBeforeInvokeApplicationPhase() {
        return PageContext.getPhaseId().compareTo((Object)PhaseId.INVOKE_APPLICATION) < 0;
    }

    private static boolean isRenderResponsePhase() {
        return PageContext.getPhaseId().compareTo((Object)PhaseId.INVOKE_APPLICATION) > 0;
    }
}

