/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.dom;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.AnnotationBinding;
import org.eclipse.jdt.core.dom.AnnotationTypeMemberDeclaration;
import org.eclipse.jdt.core.dom.BindingComparator;
import org.eclipse.jdt.core.dom.BindingResolver;
import org.eclipse.jdt.core.dom.DefaultBindingResolver;
import org.eclipse.jdt.core.dom.IAnnotationBinding;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MemberValuePairBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.MethodVerifier;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedGenericMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.RawTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;
import org.eclipse.jdt.internal.compiler.problem.AbortCompilation;
import org.eclipse.jdt.internal.core.JavaElement;
import org.eclipse.jdt.internal.core.Member;
import org.eclipse.jdt.internal.core.util.Util;

class MethodBinding
implements IMethodBinding {
    private static final int VALID_MODIFIERS = 3391;
    private static final ITypeBinding[] NO_TYPE_BINDINGS = new ITypeBinding[0];
    private org.eclipse.jdt.internal.compiler.lookup.MethodBinding binding;
    private BindingResolver resolver;
    private ITypeBinding[] parameterTypes;
    private ITypeBinding[] exceptionTypes;
    private String name;
    private ITypeBinding declaringClass;
    private ITypeBinding returnType;
    private String key;
    private ITypeBinding[] typeParameters;
    private ITypeBinding[] typeArguments;

    MethodBinding(BindingResolver resolver, org.eclipse.jdt.internal.compiler.lookup.MethodBinding binding) {
        this.resolver = resolver;
        this.binding = binding;
    }

    public boolean isAnnotationMember() {
        return this.getDeclaringClass().isAnnotation();
    }

    public boolean isConstructor() {
        return this.binding.isConstructor();
    }

    public boolean isDefaultConstructor() {
        ReferenceBinding declaringClassBinding = this.binding.declaringClass;
        if (declaringClassBinding.isRawType()) {
            RawTypeBinding rawTypeBinding = (RawTypeBinding)declaringClassBinding;
            if (rawTypeBinding.type.isBinaryBinding()) {
                return false;
            }
            return (this.binding.modifiers & 0x4000000) != 0;
        }
        if (declaringClassBinding.isBinaryBinding()) {
            return false;
        }
        return (this.binding.modifiers & 0x4000000) != 0;
    }

    public String getName() {
        if (this.name == null) {
            this.name = this.binding.isConstructor() ? this.getDeclaringClass().getName() : new String(this.binding.selector);
        }
        return this.name;
    }

    public IAnnotationBinding[] getAnnotations() {
        int length;
        org.eclipse.jdt.internal.compiler.lookup.AnnotationBinding[] annotations = this.binding.getAnnotations();
        if (annotations == null || (length = annotations.length) == 0) {
            return AnnotationBinding.NoAnnotations;
        }
        IAnnotationBinding[] domInstances = new AnnotationBinding[length];
        int i = 0;
        while (i < length) {
            IAnnotationBinding annotationInstance = this.resolver.getAnnotationInstance(annotations[i]);
            if (annotationInstance == null) {
                return AnnotationBinding.NoAnnotations;
            }
            domInstances[i] = annotationInstance;
            ++i;
        }
        return domInstances;
    }

    public ITypeBinding getDeclaringClass() {
        if (this.declaringClass == null) {
            this.declaringClass = this.resolver.getTypeBinding(this.binding.declaringClass);
        }
        return this.declaringClass;
    }

    public IAnnotationBinding[] getParameterAnnotations(int index) {
        int length;
        org.eclipse.jdt.internal.compiler.lookup.AnnotationBinding[] annotations = this.binding.getParameterAnnotations(index);
        if (annotations == null || (length = annotations.length) == 0) {
            return AnnotationBinding.NoAnnotations;
        }
        IAnnotationBinding[] domInstances = new AnnotationBinding[length];
        int i = 0;
        while (i < length) {
            IAnnotationBinding annotationInstance = this.resolver.getAnnotationInstance(annotations[i]);
            if (annotationInstance == null) {
                return AnnotationBinding.NoAnnotations;
            }
            domInstances[i] = annotationInstance;
            ++i;
        }
        return domInstances;
    }

    public ITypeBinding[] getParameterTypes() {
        if (this.parameterTypes != null) {
            return this.parameterTypes;
        }
        TypeBinding[] parameters = this.binding.parameters;
        int length = parameters.length;
        if (length == 0) {
            this.parameterTypes = NO_TYPE_BINDINGS;
        } else {
            this.parameterTypes = new ITypeBinding[length];
            int i = 0;
            while (i < length) {
                ITypeBinding typeBinding = this.resolver.getTypeBinding(parameters[i]);
                if (typeBinding == null) {
                    this.parameterTypes = NO_TYPE_BINDINGS;
                    return NO_TYPE_BINDINGS;
                }
                this.parameterTypes[i] = typeBinding;
                ++i;
            }
        }
        return this.parameterTypes;
    }

    public ITypeBinding getReturnType() {
        if (this.returnType == null) {
            this.returnType = this.resolver.getTypeBinding(this.binding.returnType);
        }
        return this.returnType;
    }

    public Object getDefaultValue() {
        if (this.isAnnotationMember()) {
            return MemberValuePairBinding.buildDOMValue(this.binding.getDefaultValue(), this.resolver);
        }
        return null;
    }

    public ITypeBinding[] getExceptionTypes() {
        if (this.exceptionTypes != null) {
            return this.exceptionTypes;
        }
        ReferenceBinding[] exceptions = this.binding.thrownExceptions;
        int length = exceptions.length;
        if (length == 0) {
            this.exceptionTypes = NO_TYPE_BINDINGS;
        } else {
            this.exceptionTypes = new ITypeBinding[length];
            int i = 0;
            while (i < length) {
                ITypeBinding typeBinding = this.resolver.getTypeBinding(exceptions[i]);
                if (typeBinding == null) {
                    this.exceptionTypes = NO_TYPE_BINDINGS;
                    return NO_TYPE_BINDINGS;
                }
                this.exceptionTypes[i] = typeBinding;
                ++i;
            }
        }
        return this.exceptionTypes;
    }

    public IJavaElement getJavaElement() {
        JavaElement element = this.getUnresolvedJavaElement();
        if (element == null) {
            return null;
        }
        return element.resolved(this.binding);
    }

    private JavaElement getUnresolvedJavaElement() {
        IType declaringType = (IType)this.getDeclaringClass().getJavaElement();
        if (declaringType == null) {
            return null;
        }
        if (!(this.resolver instanceof DefaultBindingResolver)) {
            return null;
        }
        ASTNode node = (ASTNode)((DefaultBindingResolver)this.resolver).bindingsToAstNodes.get(this);
        if (node != null && declaringType.getParent().getElementType() != 6) {
            if (node instanceof MethodDeclaration) {
                MethodDeclaration methodDeclaration = (MethodDeclaration)node;
                ArrayList<String> parameterSignatures = new ArrayList<String>();
                Iterator iterator = methodDeclaration.parameters().iterator();
                while (iterator.hasNext()) {
                    SingleVariableDeclaration parameter = (SingleVariableDeclaration)iterator.next();
                    Type type = parameter.getType();
                    String typeSig = Util.getSignature(type);
                    int arrayDim = parameter.getExtraDimensions();
                    if (parameter.getAST().apiLevel() >= 3 && parameter.isVarargs()) {
                        ++arrayDim;
                    }
                    if (arrayDim > 0) {
                        typeSig = Signature.createArraySignature(typeSig, arrayDim);
                    }
                    parameterSignatures.add(typeSig);
                }
                int parameterCount = parameterSignatures.size();
                String[] parameters = new String[parameterCount];
                parameterSignatures.toArray(parameters);
                return (JavaElement)((Object)declaringType.getMethod(this.getName(), parameters));
            }
            AnnotationTypeMemberDeclaration typeMemberDeclaration = (AnnotationTypeMemberDeclaration)node;
            return (JavaElement)((Object)declaringType.getMethod(typeMemberDeclaration.getName().getIdentifier(), new String[0]));
        }
        org.eclipse.jdt.internal.compiler.lookup.MethodBinding original = this.binding.original();
        String selector = original.isConstructor() ? declaringType.getElementName() : new String(original.selector);
        boolean isBinary = declaringType.isBinary();
        ReferenceBinding enclosingType = original.declaringClass.enclosingType();
        boolean isInnerBinaryTypeConstructor = isBinary && original.isConstructor() && enclosingType != null;
        TypeBinding[] parameters = original.parameters;
        int length = parameters == null ? 0 : parameters.length;
        int declaringIndex = isInnerBinaryTypeConstructor ? 1 : 0;
        String[] parameterSignatures = new String[declaringIndex + length];
        if (isInnerBinaryTypeConstructor) {
            parameterSignatures[0] = new String(enclosingType.genericTypeSignature()).replace('/', '.');
        }
        int i = 0;
        while (i < length) {
            parameterSignatures[declaringIndex + i] = new String(parameters[i].genericTypeSignature()).replace('/', '.');
            ++i;
        }
        IMethod result = declaringType.getMethod(selector, parameterSignatures);
        if (isBinary) {
            return (JavaElement)((Object)result);
        }
        IMethod[] methods = null;
        try {
            methods = declaringType.getMethods();
        }
        catch (JavaModelException javaModelException) {
            return null;
        }
        IMethod[] candidates = Member.findMethods(result, methods);
        if (candidates == null || candidates.length == 0) {
            return null;
        }
        return (JavaElement)((Object)candidates[0]);
    }

    public int getKind() {
        return 4;
    }

    public int getModifiers() {
        return this.binding.getAccessFlags() & 0xD3F;
    }

    public boolean isDeprecated() {
        return this.binding.isDeprecated();
    }

    public boolean isSynthetic() {
        return this.binding.isSynthetic();
    }

    public boolean isVarargs() {
        return this.binding.isVarargs();
    }

    public String getKey() {
        if (this.key == null) {
            this.key = new String(this.binding.computeUniqueKey());
        }
        return this.key;
    }

    public boolean isEqualTo(IBinding other) {
        if (other == this) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (!(other instanceof MethodBinding)) {
            return false;
        }
        org.eclipse.jdt.internal.compiler.lookup.MethodBinding otherBinding = ((MethodBinding)other).binding;
        return BindingComparator.isEqual(this.binding, otherBinding);
    }

    public ITypeBinding[] getTypeParameters() {
        if (this.typeParameters != null) {
            return this.typeParameters;
        }
        TypeVariableBinding[] typeVariableBindings = this.binding.typeVariables();
        if (typeVariableBindings != null) {
            int typeVariableBindingsLength = typeVariableBindings.length;
            if (typeVariableBindingsLength != 0) {
                this.typeParameters = new ITypeBinding[typeVariableBindingsLength];
                int i = 0;
                while (i < typeVariableBindingsLength) {
                    ITypeBinding typeBinding = this.resolver.getTypeBinding(typeVariableBindings[i]);
                    if (typeBinding == null) {
                        this.typeParameters = NO_TYPE_BINDINGS;
                        return NO_TYPE_BINDINGS;
                    }
                    this.typeParameters[i] = typeBinding;
                    ++i;
                }
            } else {
                this.typeParameters = NO_TYPE_BINDINGS;
            }
        } else {
            this.typeParameters = NO_TYPE_BINDINGS;
        }
        return this.typeParameters;
    }

    public boolean isGenericMethod() {
        if (this.typeParameters != null) {
            return this.typeParameters.length > 0;
        }
        TypeVariableBinding[] typeVariableBindings = this.binding.typeVariables();
        return typeVariableBindings != null && typeVariableBindings.length > 0;
    }

    public ITypeBinding[] getTypeArguments() {
        if (this.typeArguments != null) {
            return this.typeArguments;
        }
        if (this.binding instanceof ParameterizedGenericMethodBinding) {
            ParameterizedGenericMethodBinding genericMethodBinding = (ParameterizedGenericMethodBinding)this.binding;
            TypeBinding[] typeArgumentsBindings = genericMethodBinding.typeArguments;
            if (typeArgumentsBindings != null) {
                int typeArgumentsLength = typeArgumentsBindings.length;
                if (typeArgumentsLength != 0) {
                    this.typeArguments = new ITypeBinding[typeArgumentsLength];
                    int i = 0;
                    while (i < typeArgumentsLength) {
                        ITypeBinding typeBinding = this.resolver.getTypeBinding(typeArgumentsBindings[i]);
                        if (typeBinding == null) {
                            this.typeArguments = NO_TYPE_BINDINGS;
                            return NO_TYPE_BINDINGS;
                        }
                        this.typeArguments[i] = typeBinding;
                        ++i;
                    }
                } else {
                    this.typeArguments = NO_TYPE_BINDINGS;
                }
            } else {
                this.typeArguments = NO_TYPE_BINDINGS;
            }
        } else {
            this.typeArguments = NO_TYPE_BINDINGS;
        }
        return this.typeArguments;
    }

    public boolean isParameterizedMethod() {
        return this.binding instanceof ParameterizedGenericMethodBinding && !((ParameterizedGenericMethodBinding)this.binding).isRaw;
    }

    public boolean isRawMethod() {
        return this.binding instanceof ParameterizedGenericMethodBinding && ((ParameterizedGenericMethodBinding)this.binding).isRaw;
    }

    public boolean isSubsignature(IMethodBinding otherMethod) {
        org.eclipse.jdt.internal.compiler.lookup.MethodBinding other;
        block3: {
            try {
                other = ((MethodBinding)otherMethod).binding;
                if (CharOperation.equals(this.binding.selector, other.selector)) break block3;
                return false;
            }
            catch (AbortCompilation abortCompilation) {
                return false;
            }
        }
        return this.binding.areParameterErasuresEqual(other) && this.binding.areTypeVariableErasuresEqual(other);
    }

    public IMethodBinding getMethodDeclaration() {
        return this.resolver.getMethodBinding(this.binding.original());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean overrides(IMethodBinding overridenMethod) {
        try {
            org.eclipse.jdt.internal.compiler.lookup.MethodBinding overridenCompilerBinding = ((MethodBinding)overridenMethod).binding;
            if (this.binding == overridenCompilerBinding) {
                return false;
            }
            char[] selector = this.binding.selector;
            if (!CharOperation.equals(selector, overridenCompilerBinding.selector)) {
                return false;
            }
            TypeBinding match = this.binding.declaringClass.findSuperTypeWithSameErasure(overridenCompilerBinding.declaringClass);
            if (!(match instanceof ReferenceBinding)) {
                return false;
            }
            org.eclipse.jdt.internal.compiler.lookup.MethodBinding[] superMethods = ((ReferenceBinding)match).getMethods(selector);
            int i = 0;
            int length = superMethods.length;
            while (true) {
                if (i >= length) {
                    return false;
                }
                if (superMethods[i].original() == overridenCompilerBinding) {
                    LookupEnvironment lookupEnvironment = this.resolver.lookupEnvironment();
                    if (lookupEnvironment == null) {
                        return false;
                    }
                    MethodVerifier methodVerifier = lookupEnvironment.methodVerifier();
                    org.eclipse.jdt.internal.compiler.lookup.MethodBinding superMethod = superMethods[i];
                    return !superMethod.isPrivate() && (!superMethod.isDefault() || superMethod.declaringClass.getPackage() == this.binding.declaringClass.getPackage()) && methodVerifier.doesMethodOverride(this.binding, superMethod);
                }
                ++i;
            }
        }
        catch (AbortCompilation abortCompilation) {
            return false;
        }
    }

    public String toString() {
        return this.binding.toString();
    }
}

