/*
* JBoss, Home of Professional Open Source
* Copyright 2005, JBoss Inc., and individual contributors as indicated
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/

package org.jboss.serial.persister;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

import org.jboss.serial.classmetamodel.ClassMetaData;
import org.jboss.serial.classmetamodel.StreamingClass;
import org.jboss.serial.objectmetamodel.ObjectSubstitutionInterface;
import org.jboss.serial.objectmetamodel.ObjectsCache;

/**
 * Interface used to define how to load complex objects from the repository or streaming
 * $Id: Persister.java 231 2006-04-24 23:49:41Z csuconic $
 * @author clebert suconic
 */
public interface Persister
{
    /** You need to always return what was sent by setId. This is to enable Streaming to discover what Persister to use */
    public byte getId();
    public void setId(byte id);
    public void writeData(ClassMetaData metaData, ObjectOutput out, Object obj, ObjectSubstitutionInterface substitution) throws IOException;
    
    /**
     * 
     * @param loader
     * @param metaData
     * @param referenceId
     * @param cache It's the persister job to assign the cache with a created object, right after its creation, as if in case of circular references those references are respected.
     * @param input
     * @param substitution
     * @return
     * @throws IOException
     */
    public Object readData (ClassLoader loader, StreamingClass streaming, ClassMetaData metaData, int referenceId, ObjectsCache cache, ObjectInput input, ObjectSubstitutionInterface substitution) throws IOException;
    /** Ask the persister if the persister can handle this object */
    public boolean canPersist(Object obj);
}
