/*
 * JBoss, Home of Professional Open Source
 * Copyright 2008, Red Hat Middleware LLC, and individual contributors
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.bootstrap.spi.microcontainer;

import java.util.Map;

import org.jboss.bootstrap.spi.Server;
import org.jboss.kernel.Kernel;
import org.jboss.kernel.spi.deployment.KernelDeployment;

/**
 * An extension of the Server interface that provides access to the
 * mc Kernel and KernelDeployments loaded by the server prior to starting
 * the registered Bootstraps.
 * 
 * @author Scott.Stark@jboss.org
 * @version $Revision: 80657 $
 */
public interface MCServer extends Server
{
   /**
    * 
    * @return
    */
   public Kernel getKernel();
   /**
    * 
    * @return
    */
   public Map<String, KernelDeployment> getDeployments();
}
