/*
 * JBoss, Home of Professional Open Source
 * Copyright 2008, Red Hat Middleware LLC, and individual contributors
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.managed.api.annotation;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

import org.jboss.managed.api.RunStateMapper;

/**
 * An annotation one can use on a ManagedProperty to indicate that the property
 * provides RunState value information. The metaValues, enumValues attributes
 * can be used to pass information to the RunStateMapper class ctor. If both
 * metaValues, enumValues are non-zero arrays, a
 * ctor(String[] metaValues, String[] enumValues) is used to instantiate the
 * RunStateMapper. Otherwise, the default ctor will be used.
 * 
 * @author Scott.Stark@jboss.org
 * @version $Revision:$
 */
@Target({ElementType.METHOD, ElementType.FIELD})
@Retention(RetentionPolicy.RUNTIME)
public @interface RunStateProperty
{
   /** The class to use for the RunStateMapper implementation */
   Class<? extends RunStateMapper> value();
   /** Optional meta value strings for the */
   String[] metaValues() default {};
   String[] enumValues() default {};
}
