/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2008, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.ha.jndi.spi;

import java.util.Collection;

import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameClassPair;
import javax.naming.NamingException;

import org.jnp.interfaces.Naming;

/**
 * Manages distributed tree operations for HAJNDI.
 * 
 * @author Brian Stansberry
 */
public interface DistributedTreeManager
{
   /** Initializes the DistributedTreeManager */
   void init();

   /** Shuts down the DistributedTreeManager */
   void shutdown();

   /** Bind an object in the distribute tree */
   void bind(Name name, Object obj, String className) throws NamingException;

   /** Re-bind an object in the distribute tree */
   void rebind(Name name, Object obj, String className) throws NamingException;

   /** Unbind an object from the distributed tree */
   void unbind(Name name) throws NamingException;

   /** 
    * Lookup an object in the distributed tree. Does not throw
    * NameNotFoundException if nothing is bound under <code>name</code>;
    * instead it returns <code>null</code>.
    * 
    * @param name the name
    * @return the object bound or <code>null</code>
    */
   Object lookup(Name name) throws NamingException;
   
   /** List the binding in the distributed tree */
   Collection<NameClassPair> list(Name name) throws NamingException;

   /** List the bindings in the distributed tree */
   Collection<Binding> listBindings(Name name) throws NamingException;

   /** Create a subcontext in the distributed tree */
   Context createSubcontext(Name name) throws NamingException;

   /** Get the Naming object relative to which context's are created */
   Naming getHAStub();

   /** Set the Naming object relative to which context's are created */
   void setHAStub(Naming stub);
}