/*
 * JBoss, Home of Professional Open Source
 * Copyright 2008, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.jboss.xnio.metadata;

import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.XmlElement;

/**
 *
 */
@XmlType(name = "destination", propOrder = {})
public final class DestinationMetaData {
    private InetSocketAddressMetaData bindAddress;
    private InetSocketAddressMetaData connectAddress;

    public InetSocketAddressMetaData getBindAddress() {
        return bindAddress;
    }

    @XmlElement(name = "bind-address")
    public void setBindAddress(final InetSocketAddressMetaData bindAddress) {
        this.bindAddress = bindAddress;
    }

    public InetSocketAddressMetaData getConnectAddress() {
        return connectAddress;
    }

    @XmlElement(name = "connect-address", required = true)
    public void setConnectAddress(final InetSocketAddressMetaData connectAddress) {
        this.connectAddress = connectAddress;
    }
}
