/*
 * JBoss, Home of Professional Open Source
 * Copyright 2009, Red Hat Middleware LLC, and individual contributors
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.metatype.plugins.values.defaults;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;

import org.jboss.metatype.api.types.MetaType;
import org.jboss.metatype.api.types.SimpleMetaType;
import org.jboss.metatype.api.values.MetaValue;
import org.jboss.metatype.api.values.SimpleValueSupport;
import org.jboss.metatype.spi.values.DefaultValueBuilder;

/**
 * A DefaultValueBuilder for SimpleMetaTypes
 * 
 * @author Scott.Stark@jboss.org
 * @version $Revision:$
 */
public class SimpleDefaultValueBuilder
{

   public MetaValue buildMetaValue(MetaType metaType, String value)
   {
      MetaValue mvalue = null;
      if(metaType.equals(SimpleMetaType.BOOLEAN))
      {
         Boolean jvalue = Boolean.valueOf(value);
         mvalue = SimpleValueSupport.wrap(jvalue);
      }
      else if(metaType.equals(SimpleMetaType.BOOLEAN_PRIMITIVE))
      {
         Boolean jvalue = Boolean.valueOf(value);
         boolean primitive = jvalue.booleanValue();
         mvalue = SimpleValueSupport.wrap(primitive);
      }
      else if(metaType.equals(SimpleMetaType.BYTE))
      {
         Byte jvalue = Byte.valueOf(value);
         mvalue = SimpleValueSupport.wrap(jvalue);
      }
      else if(metaType.equals(SimpleMetaType.BYTE_PRIMITIVE))
      {
         Byte jvalue = Byte.valueOf(value);
         byte primitive = jvalue.byteValue();
         mvalue = SimpleValueSupport.wrap(primitive);
      }
      else if(metaType.equals(SimpleMetaType.CHARACTER))
      {
         Character jvalue = Character.valueOf(value.charAt(0));
         mvalue = SimpleValueSupport.wrap(jvalue);
      }
      else if(metaType.equals(SimpleMetaType.CHARACTER_PRIMITIVE))
      {
         mvalue = SimpleValueSupport.wrap(value.charAt(0));
      }
      else if(metaType.equals(SimpleMetaType.DATE))
      {
         Date jvalue = new Date(value);
         mvalue = SimpleValueSupport.wrap(jvalue);
      }
      else if(metaType.equals(SimpleMetaType.DOUBLE))
      {
         Double jvalue = Double.valueOf(value);
         mvalue = SimpleValueSupport.wrap(jvalue);
      }
      else if(metaType.equals(SimpleMetaType.DOUBLE_PRIMITIVE))
      {
         Double jvalue = Double.valueOf(value);
         double primitive = jvalue.doubleValue();
         mvalue = SimpleValueSupport.wrap(primitive);
      }
      else if(metaType.equals(SimpleMetaType.FLOAT))
      {
         Float jvalue = Float.valueOf(value);
         mvalue = SimpleValueSupport.wrap(jvalue);
      }
      else if(metaType.equals(SimpleMetaType.FLOAT_PRIMITIVE))
      {
         Float jvalue = Float.valueOf(value);
         float primitive = jvalue.floatValue();
         mvalue = SimpleValueSupport.wrap(primitive);
      }
      else if(metaType.equals(SimpleMetaType.INTEGER))
      {
         Integer jvalue = Integer.valueOf(value);
         mvalue = SimpleValueSupport.wrap(jvalue);
      }
      else if(metaType.equals(SimpleMetaType.INTEGER_PRIMITIVE))
      {
         Integer jvalue = Integer.valueOf(value);
         int primitive = jvalue.intValue();
         mvalue = SimpleValueSupport.wrap(primitive);
      }
      else if(metaType.equals(SimpleMetaType.LONG))
      {
         Long jvalue = Long.valueOf(value);
         mvalue = SimpleValueSupport.wrap(jvalue);
      }
      else if(metaType.equals(SimpleMetaType.LONG_PRIMITIVE))
      {
         Long jvalue = Long.valueOf(value);
         long primitive = jvalue.longValue();
         mvalue = SimpleValueSupport.wrap(primitive);
      }
      else if(metaType.equals(SimpleMetaType.SHORT))
      {
         Short jvalue = Short.valueOf(value);
         mvalue = SimpleValueSupport.wrap(jvalue);
      }
      else if(metaType.equals(SimpleMetaType.SHORT_PRIMITIVE))
      {
         Short jvalue = Short.valueOf(value);
         short primitive = jvalue.shortValue();
         mvalue = SimpleValueSupport.wrap(primitive);
      }
      else if(metaType.equals(SimpleMetaType.STRING))
      {
         mvalue = SimpleValueSupport.wrap(value);
      }
      else
      {
         throw new IllegalStateException("Unknown metaType: "+metaType);
      }
      return mvalue;
   }
   
}
