/*
* JBoss, Home of Professional Open Source
* Copyright 2005, JBoss Inc., and individual contributors as indicated
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/
package org.jboss.ejb3.deployers.metadata.processor;

import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.metadata.ejb.jboss.JBossMetaData;
import org.jboss.metadata.process.processor.JBossMetaDataProcessor;
import org.jboss.metadata.process.processor.ejb.jboss.JNDIBindingPolicyProcessor;

/**
 * {@link JNDIBindingPolicyProcessorFactory} is responsible for creating the
 * {@link JNDIBindingPolicyProcessor} which will set the jndi-binding-policy on all
 * beans in a deployment, if any user specified binding policy exists as a deployment
 * level config. See https://jira.jboss.org/jira/browse/JBMETA-232
 *
 * @author Jaikiran Pai
 * @version $Revision: $
 */
public class JNDIBindingPolicyProcessorFactory implements JBossMetaDataProcessorFactory<JBossMetaData>
{

   /**
    * Returns a {@link JNDIBindingPolicyProcessor} 
    * 
    * @see org.jboss.ejb3.deployers.metadata.processor.JBossMetaDataProcessorFactory#create(org.jboss.deployers.structure.spi.DeploymentUnit)
    */
   public JBossMetaDataProcessor<JBossMetaData> create(DeploymentUnit deploymentUnit)
   {
      return new JNDIBindingPolicyProcessor();
   }

}
