/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.beans.metadata.plugins;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import org.jboss.beans.metadata.plugins.AbstractTypeMetaData;
import org.jboss.beans.metadata.plugins.CloneUtil;
import org.jboss.beans.metadata.plugins.MapEntry;
import org.jboss.beans.metadata.spi.MetaDataVisitor;
import org.jboss.beans.metadata.spi.MetaDataVisitorNode;
import org.jboss.beans.metadata.spi.ValueMetaData;
import org.jboss.reflect.spi.ClassInfo;
import org.jboss.reflect.spi.TypeInfo;
import org.jboss.xb.annotations.JBossXmlMapEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XmlType(name="mapType")
@JBossXmlMapEntry(name="entry", type=MapEntry.class)
public class AbstractMapMetaData
extends AbstractTypeMetaData
implements Map<MetaDataVisitorNode, MetaDataVisitorNode>,
Serializable {
    private static final long serialVersionUID = 2L;
    private Map<MetaDataVisitorNode, MetaDataVisitorNode> map = new HashMap<MetaDataVisitorNode, MetaDataVisitorNode>();
    protected String keyType;
    protected String valueType;

    public String getKeyType() {
        return this.keyType;
    }

    @XmlAttribute(name="keyClass")
    public void setKeyType(String keyType) {
        this.keyType = keyType;
    }

    public String getValueType() {
        return this.valueType;
    }

    @XmlAttribute(name="valueClass")
    public void setValueType(String valueType) {
        this.valueType = valueType;
    }

    @Override
    public Object getValue(TypeInfo info, ClassLoader cl) throws Throwable {
        Map result = this.getTypeInstance(info, cl, this.getExpectedClass());
        ClassInfo keyTypeInfo = this.getKeyClassInfo(cl);
        ClassInfo valueTypeInfo = this.getValueClassInfo(cl);
        if (this.map.size() > 0) {
            boolean first = true;
            for (Map.Entry<MetaDataVisitorNode, MetaDataVisitorNode> entry : this.map.entrySet()) {
                ValueMetaData key = (ValueMetaData)entry.getKey();
                ValueMetaData value = (ValueMetaData)entry.getValue();
                Object keyValue = key.getValue((TypeInfo)keyTypeInfo, cl);
                Object valueValue = value.getValue((TypeInfo)valueTypeInfo, cl);
                try {
                    result.put(keyValue, valueValue);
                }
                catch (UnsupportedOperationException e) {
                    if (!first) {
                        throw e;
                    }
                    result = this.getTypeInstance(info, cl, this.getExpectedClass(), false);
                    result.put(keyValue, valueValue);
                }
                first = false;
            }
        }
        return result;
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    @Override
    public Set<Map.Entry<MetaDataVisitorNode, MetaDataVisitorNode>> entrySet() {
        return this.map.entrySet();
    }

    @Override
    public MetaDataVisitorNode get(Object key) {
        return this.map.get(key);
    }

    @Override
    @XmlTransient
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public Set<MetaDataVisitorNode> keySet() {
        return this.map.keySet();
    }

    @Override
    public MetaDataVisitorNode put(MetaDataVisitorNode key, MetaDataVisitorNode value) {
        return this.map.put(key, value);
    }

    @Override
    public void putAll(Map<? extends MetaDataVisitorNode, ? extends MetaDataVisitorNode> t) {
        this.map.putAll(t);
    }

    @Override
    public MetaDataVisitorNode remove(Object key) {
        return this.map.remove(key);
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public Collection<MetaDataVisitorNode> values() {
        return this.map.values();
    }

    @Override
    @XmlTransient
    public Iterator<? extends MetaDataVisitorNode> getChildren() {
        ArrayList<MetaDataVisitorNode> children = new ArrayList<MetaDataVisitorNode>(this.keySet());
        children.addAll(this.values());
        return children.iterator();
    }

    @Override
    public TypeInfo getType(MetaDataVisitor visitor, MetaDataVisitorNode previous) throws Throwable {
        if (this.keyType != null) {
            for (MetaDataVisitorNode key : this.keySet()) {
                if (!previous.equals(key)) continue;
                return this.getClass(visitor, this.keyType);
            }
        }
        if (this.valueType != null) {
            for (MetaDataVisitorNode v : this.values()) {
                if (!previous.equals(v)) continue;
                return this.getClass(visitor, this.valueType);
            }
        }
        return super.getType(visitor, previous);
    }

    @Override
    @XmlTransient
    protected Object getDefaultInstance() {
        return new HashMap();
    }

    @XmlTransient
    protected Class<? extends Map> getExpectedClass() {
        return Map.class;
    }

    protected ClassInfo getKeyClassInfo(ClassLoader cl) throws Throwable {
        if (this.keyType == null) {
            return null;
        }
        return this.configurator.getClassInfo(this.keyType, cl);
    }

    protected ClassInfo getValueClassInfo(ClassLoader cl) throws Throwable {
        if (this.valueType == null) {
            return null;
        }
        return this.configurator.getClassInfo(this.valueType, cl);
    }

    @Override
    public AbstractMapMetaData clone() {
        AbstractMapMetaData clone = (AbstractMapMetaData)super.clone();
        clone.map = CloneUtil.cloneMap(this.map, MetaDataVisitorNode.class, MetaDataVisitorNode.class);
        return clone;
    }
}

