/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.jaxme.xs.junit;

import java.io.StringReader;
import java.util.Iterator;
import org.apache.ws.jaxme.xs.XSAttributable;
import org.apache.ws.jaxme.xs.XSAttribute;
import org.apache.ws.jaxme.xs.XSComplexType;
import org.apache.ws.jaxme.xs.XSElement;
import org.apache.ws.jaxme.xs.XSEnumeration;
import org.apache.ws.jaxme.xs.XSGroup;
import org.apache.ws.jaxme.xs.XSParticle;
import org.apache.ws.jaxme.xs.XSSimpleType;
import org.apache.ws.jaxme.xs.XSType;
import org.apache.ws.jaxme.xs.jaxb.JAXBAttribute;
import org.apache.ws.jaxme.xs.jaxb.JAXBClass;
import org.apache.ws.jaxme.xs.jaxb.JAXBElement;
import org.apache.ws.jaxme.xs.jaxb.JAXBEnumeration;
import org.apache.ws.jaxme.xs.jaxb.JAXBGlobalBindings;
import org.apache.ws.jaxme.xs.jaxb.JAXBGroup;
import org.apache.ws.jaxme.xs.jaxb.JAXBJavaType;
import org.apache.ws.jaxme.xs.jaxb.JAXBJavadoc;
import org.apache.ws.jaxme.xs.jaxb.JAXBProperty;
import org.apache.ws.jaxme.xs.jaxb.JAXBSchema;
import org.apache.ws.jaxme.xs.jaxb.JAXBSchemaBindings;
import org.apache.ws.jaxme.xs.jaxb.JAXBSimpleType;
import org.apache.ws.jaxme.xs.jaxb.JAXBType;
import org.apache.ws.jaxme.xs.jaxb.JAXBTypesafeEnumClass;
import org.apache.ws.jaxme.xs.jaxb.JAXBTypesafeEnumMember;
import org.apache.ws.jaxme.xs.jaxb.impl.JAXBParser;
import org.apache.ws.jaxme.xs.junit.ParserTest;
import org.apache.ws.jaxme.xs.types.XSDateTime;
import org.apache.ws.jaxme.xs.types.XSNCName;
import org.apache.ws.jaxme.xs.types.XSString;
import org.apache.ws.jaxme.xs.xml.XsQName;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class JAXBParserTest
extends ParserTest {
    public JAXBParserTest(String pName) {
        super(pName);
    }

    public void testJAXBGlobalBindingsDefaults() throws Exception {
        String schemaSource = "<?xml version='1.0'?>\n<xs:schema xmlns:xs='http://www.w3.org/2001/XMLSchema'/>\n";
        JAXBParser parser = this.newJAXBParser();
        InputSource isource = new InputSource(new StringReader("<?xml version='1.0'?>\n<xs:schema xmlns:xs='http://www.w3.org/2001/XMLSchema'/>\n"));
        isource.setSystemId("testGlobalBindingsDefaults.xsd");
        JAXBSchema schema = (JAXBSchema)parser.parse(isource);
        JAXBGlobalBindings globalBindings = schema.getJAXBGlobalBindings();
        String collectionType = globalBindings.getCollectionType();
        JAXBParserTest.assertNull((Object)collectionType);
        JAXBJavaType.JAXBGlobalJavaType[] javaTypes = globalBindings.getJavaType();
        JAXBParserTest.assertNotNull((Object)javaTypes);
        JAXBParserTest.assertEquals((int)0, (int)javaTypes.length);
        XsQName[] typesafeEnumBase = globalBindings.getTypesafeEnumBase();
        JAXBParserTest.assertNotNull((Object)typesafeEnumBase);
        JAXBParserTest.assertEquals((int)1, (int)typesafeEnumBase.length);
        XsQName qName = typesafeEnumBase[0];
        JAXBParserTest.assertEquals((Object)XSNCName.getInstance().getName(), (Object)qName);
        boolean bindingStyleModelGroup = globalBindings.isBindingStyleModelGroup();
        JAXBParserTest.assertTrue((!bindingStyleModelGroup ? 1 : 0) != 0);
        boolean choiceContentProperty = globalBindings.isChoiceContentProperty();
        JAXBParserTest.assertTrue((!choiceContentProperty ? 1 : 0) != 0);
        boolean enableFailFastCheck = globalBindings.isEnableFailFastCheck();
        JAXBParserTest.assertTrue((!enableFailFastCheck ? 1 : 0) != 0);
        boolean enableJavaNamingConventions = globalBindings.isEnableJavaNamingConventions();
        JAXBParserTest.assertTrue((boolean)enableJavaNamingConventions);
        boolean fixedAttributeAsConstantProperty = globalBindings.isFixedAttributeAsConstantProperty();
        JAXBParserTest.assertTrue((!fixedAttributeAsConstantProperty ? 1 : 0) != 0);
        boolean generateIsSetMethod = globalBindings.isGenerateIsSetMethod();
        JAXBParserTest.assertTrue((!generateIsSetMethod ? 1 : 0) != 0);
        JAXBGlobalBindings.UnderscoreBinding underscoreBinding = globalBindings.getUnderscoreBinding();
        JAXBParserTest.assertEquals((Object)JAXBGlobalBindings.UnderscoreBinding.AS_WORD_SEPARATOR, (Object)underscoreBinding);
    }

    public void testJAXBGlobalBindings() throws Exception {
        String schemaSource = "<?xml version='1.0'?>\n<xs:schema xmlns:xs='http://www.w3.org/2001/XMLSchema'>\n  <xs:annotation>\n    <xs:appinfo>\n      <jaxb:globalBindings xmlns:jaxb='http://java.sun.com/xml/ns/jaxb'\n          collectionType='java.util.ArrayList'\n          typesafeEnumBase='xs:string xs:NCName'\n          bindingStyle='modelGroupBinding'\n          choiceContentProperty='true'\n          enableFailFastCheck='1'\n          enableJavaNamingConventions='false'\n          fixedAttributeAsConstantProperty='true'\n          generateIsSetMethod='1'\n          underscoreBinding='asCharInWord'/>\n    </xs:appinfo\n>  </xs:annotation>\n</xs:schema>";
        JAXBParser parser = this.newJAXBParser();
        InputSource isource = new InputSource(new StringReader("<?xml version='1.0'?>\n<xs:schema xmlns:xs='http://www.w3.org/2001/XMLSchema'>\n  <xs:annotation>\n    <xs:appinfo>\n      <jaxb:globalBindings xmlns:jaxb='http://java.sun.com/xml/ns/jaxb'\n          collectionType='java.util.ArrayList'\n          typesafeEnumBase='xs:string xs:NCName'\n          bindingStyle='modelGroupBinding'\n          choiceContentProperty='true'\n          enableFailFastCheck='1'\n          enableJavaNamingConventions='false'\n          fixedAttributeAsConstantProperty='true'\n          generateIsSetMethod='1'\n          underscoreBinding='asCharInWord'/>\n    </xs:appinfo\n>  </xs:annotation>\n</xs:schema>"));
        isource.setSystemId("testGlobalBindingsDefaults.xsd");
        JAXBSchema schema = (JAXBSchema)parser.parse(isource);
        JAXBGlobalBindings globalBindings = schema.getJAXBGlobalBindings();
        String collectionType = globalBindings.getCollectionType();
        JAXBParserTest.assertEquals((String)"java.util.ArrayList", (String)collectionType);
        XsQName[] typesafeEnumBase = globalBindings.getTypesafeEnumBase();
        JAXBParserTest.assertNotNull((Object)typesafeEnumBase);
        JAXBParserTest.assertEquals((int)2, (int)typesafeEnumBase.length);
        XsQName qName = typesafeEnumBase[0];
        JAXBParserTest.assertEquals((Object)qName, (Object)XSString.getInstance().getName());
        qName = typesafeEnumBase[1];
        JAXBParserTest.assertEquals((Object)qName, (Object)XSNCName.getInstance().getName());
        boolean bindingStyleModelGroup = globalBindings.isBindingStyleModelGroup();
        JAXBParserTest.assertTrue((boolean)bindingStyleModelGroup);
        boolean choiceContentProperty = globalBindings.isChoiceContentProperty();
        JAXBParserTest.assertTrue((boolean)choiceContentProperty);
        boolean enableFailFastCheck = globalBindings.isEnableFailFastCheck();
        JAXBParserTest.assertTrue((boolean)enableFailFastCheck);
        boolean enableJavaNamingConventions = globalBindings.isEnableJavaNamingConventions();
        JAXBParserTest.assertTrue((!enableJavaNamingConventions ? 1 : 0) != 0);
        boolean fixedAttributeAsConstantProperty = globalBindings.isFixedAttributeAsConstantProperty();
        JAXBParserTest.assertTrue((boolean)fixedAttributeAsConstantProperty);
        boolean generateIsSetMethod = globalBindings.isGenerateIsSetMethod();
        JAXBParserTest.assertTrue((boolean)generateIsSetMethod);
        JAXBGlobalBindings.UnderscoreBinding underscoreBinding = globalBindings.getUnderscoreBinding();
        JAXBParserTest.assertEquals((Object)JAXBGlobalBindings.UnderscoreBinding.AS_CHAR_IN_WORD, (Object)underscoreBinding);
        JAXBJavaType.JAXBGlobalJavaType[] javaTypes = globalBindings.getJavaType();
        JAXBParserTest.assertNotNull((Object)javaTypes);
        JAXBParserTest.assertEquals((int)0, (int)javaTypes.length);
    }

    public void testJAXBSchemaBindingsDefaults() throws Exception {
        String schemaSource = "<?xml version='1.0'?>\n<xs:schema xmlns:xs='http://www.w3.org/2001/XMLSchema'>\n  <xs:complexType name='a'>\n    <xs:sequence>\n      <xs:element name='b' type='xs:string'/>\n    </xs:sequence>\n  </xs:complexType>\n</xs:schema>";
        JAXBParser parser = this.newJAXBParser();
        InputSource isource = new InputSource(new StringReader("<?xml version='1.0'?>\n<xs:schema xmlns:xs='http://www.w3.org/2001/XMLSchema'>\n  <xs:complexType name='a'>\n    <xs:sequence>\n      <xs:element name='b' type='xs:string'/>\n    </xs:sequence>\n  </xs:complexType>\n</xs:schema>"));
        isource.setSystemId("testSchemaBindingsDefaults.xsd");
        JAXBSchema schema = (JAXBSchema)parser.parse(isource);
        JAXBType a = (JAXBType)schema.getType(new XsQName((String)null, "a"));
        JAXBParserTest.assertNotNull((Object)a);
        this.assertComplexType(a);
        JAXBSchemaBindings schemaBindings = a.getJAXBSchemaBindings();
        JAXBSchemaBindings.NameXmlTransformation[] nameXmlTransformations = schemaBindings.getNameXmlTransformation();
        JAXBParserTest.assertNotNull((Object)nameXmlTransformations);
        JAXBParserTest.assertEquals((int)0, (int)nameXmlTransformations.length);
        JAXBParserTest.assertNull((Object)schemaBindings.getPackage());
    }

    public void testJAXBSchemaBindings() throws Exception {
        String myPackageName = "org.apache.ws.jaxme.somepackage";
        String schemaSource = "<?xml version='1.0'?>\n<xs:schema xmlns:xs='http://www.w3.org/2001/XMLSchema'>\n  <xs:annotation>\n    <xs:appinfo>\n      <jaxb:schemaBindings xmlns:jaxb='http://java.sun.com/xml/ns/jaxb'>\n        <jaxb:package name='org.apache.ws.jaxme.somepackage'>\n          <jaxb:javadoc>Test documentation</jaxb:javadoc>\n        </jaxb:package>\n        <jaxb:nameXmlTransformation>\n          <jaxb:typeName prefix='b' suffix='a'/>\n        </jaxb:nameXmlTransformation>\n      </jaxb:schemaBindings>\n    </xs:appinfo>\n  </xs:annotation>\n  <xs:complexType name='a'>\n    <xs:sequence>\n      <xs:element name='x' type='xs:int'/>\n    </xs:sequence>\n    <xs:attribute name='y' type='xs:string'/>\n  </xs:complexType>\n  <xs:element name='b' type='a'/>\n</xs:schema>";
        JAXBParser parser = this.newJAXBParser();
        InputSource isource = new InputSource(new StringReader("<?xml version='1.0'?>\n<xs:schema xmlns:xs='http://www.w3.org/2001/XMLSchema'>\n  <xs:annotation>\n    <xs:appinfo>\n      <jaxb:schemaBindings xmlns:jaxb='http://java.sun.com/xml/ns/jaxb'>\n        <jaxb:package name='org.apache.ws.jaxme.somepackage'>\n          <jaxb:javadoc>Test documentation</jaxb:javadoc>\n        </jaxb:package>\n        <jaxb:nameXmlTransformation>\n          <jaxb:typeName prefix='b' suffix='a'/>\n        </jaxb:nameXmlTransformation>\n      </jaxb:schemaBindings>\n    </xs:appinfo>\n  </xs:annotation>\n  <xs:complexType name='a'>\n    <xs:sequence>\n      <xs:element name='x' type='xs:int'/>\n    </xs:sequence>\n    <xs:attribute name='y' type='xs:string'/>\n  </xs:complexType>\n  <xs:element name='b' type='a'/>\n</xs:schema>"));
        isource.setSystemId("testSchemaBindings.xsd");
        JAXBSchema schema = (JAXBSchema)parser.parse(isource);
        JAXBType a = (JAXBType)schema.getType(new XsQName((String)null, "a"));
        JAXBSchemaBindings schemaBindings = a.getJAXBSchemaBindings();
        JAXBSchemaBindings.Package schemaPackage = schemaBindings.getPackage();
        JAXBParserTest.assertNotNull((Object)schemaPackage);
        JAXBParserTest.assertEquals((String)"org.apache.ws.jaxme.somepackage", (String)schemaPackage.getName());
        JAXBJavadoc javadoc = schemaPackage.getJavadoc();
        JAXBParserTest.assertNotNull((Object)javadoc);
        JAXBParserTest.assertEquals((String)"Test documentation", (String)javadoc.getText());
        JAXBSchemaBindings.NameXmlTransformation[] nameXmlTransformations = schemaBindings.getNameXmlTransformation();
        JAXBParserTest.assertNotNull((Object)nameXmlTransformations);
        JAXBParserTest.assertEquals((int)1, (int)nameXmlTransformations.length);
        JAXBSchemaBindings.NameXmlTransformation nameXmlTransformation = nameXmlTransformations[0];
        JAXBParserTest.assertNotNull((Object)nameXmlTransformation);
        JAXBSchemaBindings.NameTransformation transformation = nameXmlTransformation.getTypeName();
        JAXBParserTest.assertEquals((String)"a", (String)transformation.getSuffix());
        JAXBParserTest.assertEquals((String)"b", (String)transformation.getPrefix());
    }

    public void testJAXBClass() throws Exception {
        String schemaSource = "<?xml version='1.0'?>\n<xs:schema xmlns:xs='http://www.w3.org/2001/XMLSchema'           xmlns:jaxb='http://java.sun.com/xml/ns/jaxb'>\n  <xs:complexType name='a'>\n    <xs:annotation>\n      <xs:appinfo>\n        <jaxb:class name='b' implClass='com.b.c'/>\n      </xs:appinfo>\n    </xs:annotation>\n    <xs:sequence>\n      <xs:element name='x' type='xs:int'/>\n      <xs:element name='f' type='xs:string'>\n        <xs:annotation><xs:appinfo>\n            <jaxb:class name='x'/>\n        </xs:appinfo></xs:annotation>\n      </xs:element>\n    </xs:sequence>\n    <xs:attribute name='y' type='xs:string'/>\n  </xs:complexType>\n  <xs:element name='g' type='xs:string'/>\n  <xs:group name='m'>\n    <xs:annotation>\n      <xs:appinfo>\n        <jaxb:class name='k' implClass='com.b.i'/>\n      </xs:appinfo>\n    </xs:annotation>\n    <xs:sequence>\n      <xs:element name='n' type='xs:float'/>\n    </xs:sequence>\n  </xs:group>\n</xs:schema>";
        JAXBParser parser = this.newJAXBParser();
        InputSource isource = new InputSource(new StringReader("<?xml version='1.0'?>\n<xs:schema xmlns:xs='http://www.w3.org/2001/XMLSchema'           xmlns:jaxb='http://java.sun.com/xml/ns/jaxb'>\n  <xs:complexType name='a'>\n    <xs:annotation>\n      <xs:appinfo>\n        <jaxb:class name='b' implClass='com.b.c'/>\n      </xs:appinfo>\n    </xs:annotation>\n    <xs:sequence>\n      <xs:element name='x' type='xs:int'/>\n      <xs:element name='f' type='xs:string'>\n        <xs:annotation><xs:appinfo>\n            <jaxb:class name='x'/>\n        </xs:appinfo></xs:annotation>\n      </xs:element>\n    </xs:sequence>\n    <xs:attribute name='y' type='xs:string'/>\n  </xs:complexType>\n  <xs:element name='g' type='xs:string'/>\n  <xs:group name='m'>\n    <xs:annotation>\n      <xs:appinfo>\n        <jaxb:class name='k' implClass='com.b.i'/>\n      </xs:appinfo>\n    </xs:annotation>\n    <xs:sequence>\n      <xs:element name='n' type='xs:float'/>\n    </xs:sequence>\n  </xs:group>\n</xs:schema>"));
        isource.setSystemId("testClass1.xsd");
        JAXBSchema schema = (JAXBSchema)parser.parse(isource);
        JAXBType a = (JAXBType)schema.getType(new XsQName((String)null, "a"));
        JAXBParserTest.assertNotNull((Object)a);
        JAXBClass jaxbClass = a.getJAXBClass();
        JAXBParserTest.assertNotNull((Object)jaxbClass);
        JAXBParserTest.assertEquals((String)"b", (String)jaxbClass.getName());
        JAXBParserTest.assertEquals((String)"com.b.c", (String)jaxbClass.getImplClass());
        XSParticle p1 = this.assertComplexContent(this.assertComplexType(a));
        XSGroup group = this.assertGroup(p1);
        XSParticle[] particles = group.getParticles();
        JAXBParserTest.assertEquals((int)2, (int)particles.length);
        JAXBElement f = (JAXBElement)this.assertElement(particles[1]);
        jaxbClass = f.getJAXBClass();
        JAXBParserTest.assertNotNull((Object)jaxbClass);
        JAXBParserTest.assertEquals((String)"x", (String)jaxbClass.getName());
        JAXBParserTest.assertNull((Object)jaxbClass.getImplClass());
        JAXBElement g = (JAXBElement)schema.getElement(new XsQName((String)null, "g"));
        JAXBParserTest.assertNotNull((Object)g);
        JAXBParserTest.assertNull((Object)g.getJAXBClass());
        JAXBGroup m = (JAXBGroup)schema.getGroup(new XsQName((String)null, "m"));
        jaxbClass = m.getJAXBClass();
        JAXBParserTest.assertNotNull((Object)jaxbClass);
        JAXBParserTest.assertEquals((String)"k", (String)jaxbClass.getName());
        JAXBParserTest.assertEquals((String)"com.b.i", (String)jaxbClass.getImplClass());
        schemaSource = "<?xml version='1.0'?>\n<xs:schema xmlns:xs='http://www.w3.org/2001/XMLSchema'           xmlns:jaxb='http://java.sun.com/xml/ns/jaxb'>\n  <xs:complexType name='d'>\n    <xs:sequence>\n      <xs:element name='e'>\n        <xs:complexType name='a'>\n          <xs:annotation>\n            <xs:appinfo>\n              <jaxb:class name='b'/>\n            </xs:appinfo>\n          </xs:annotation>\n          <xs:sequence>\n            <xs:element name='x' type='xs:int'/>\n          </xs:sequence>\n          <xs:attribute name='y' type='xs:string'/>\n        </xs:complexType>\n      </xs:element>\n      <xs:element name='f' type='xs:string'>\n        <xs:annotation>\n          <xs:appinfo>\n            <jaxb:class name='x'/>\n          </xs:appinfo>\n        </xs:annotation>\n      </xs:element>\n      <xs:element name='g' type='xs:string'/>\n    </xs:sequence>\n  </xs:complexType>\n</xs:schema>";
        parser = this.newJAXBParser();
        isource = new InputSource(new StringReader("<?xml version='1.0'?>\n<xs:schema xmlns:xs='http://www.w3.org/2001/XMLSchema'           xmlns:jaxb='http://java.sun.com/xml/ns/jaxb'>\n  <xs:complexType name='d'>\n    <xs:sequence>\n      <xs:element name='e'>\n        <xs:complexType name='a'>\n          <xs:annotation>\n            <xs:appinfo>\n              <jaxb:class name='b'/>\n            </xs:appinfo>\n          </xs:annotation>\n          <xs:sequence>\n            <xs:element name='x' type='xs:int'/>\n          </xs:sequence>\n          <xs:attribute name='y' type='xs:string'/>\n        </xs:complexType>\n      </xs:element>\n      <xs:element name='f' type='xs:string'>\n        <xs:annotation>\n          <xs:appinfo>\n            <jaxb:class name='x'/>\n          </xs:appinfo>\n        </xs:annotation>\n      </xs:element>\n      <xs:element name='g' type='xs:string'/>\n    </xs:sequence>\n  </xs:complexType>\n</xs:schema>"));
        isource.setSystemId("testJAXBClass2.xsd");
        schema = (JAXBSchema)parser.parse(isource);
        JAXBType d = (JAXBType)schema.getType(new XsQName((String)null, "d"));
        JAXBParserTest.assertNotNull((Object)d);
        XSGroup dGroup = this.assertGroup(this.assertComplexContent(this.assertComplexType(d)));
        this.assertSequence(dGroup);
        XSParticle[] particles2 = dGroup.getParticles();
        JAXBParserTest.assertEquals((int)3, (int)particles2.length);
        JAXBElement e = (JAXBElement)this.assertElement(particles2[0]);
        JAXBType a2 = (JAXBType)e.getType();
        JAXBClass jaxbClass2 = a2.getJAXBClass();
        JAXBParserTest.assertNotNull((Object)jaxbClass2);
        JAXBParserTest.assertEquals((String)"b", (String)jaxbClass2.getName());
        JAXBParserTest.assertNull((Object)jaxbClass2.getImplClass());
        JAXBElement f2 = (JAXBElement)this.assertElement(particles2[1]);
        JAXBParserTest.assertEquals((Object)new XsQName((String)null, "f"), (Object)f2.getName());
        JAXBParserTest.assertNotNull((Object)f2);
        jaxbClass2 = f2.getJAXBClass();
        JAXBParserTest.assertNotNull((Object)jaxbClass2);
        JAXBParserTest.assertEquals((String)"x", (String)jaxbClass2.getName());
        JAXBParserTest.assertNull((Object)jaxbClass2.getImplClass());
        JAXBElement g2 = (JAXBElement)this.assertElement(particles2[2]);
        JAXBParserTest.assertEquals((Object)new XsQName((String)null, "g"), (Object)g2.getName());
        JAXBParserTest.assertNotNull((Object)g2);
        JAXBParserTest.assertNull((Object)g2.getJAXBClass());
        schemaSource = "<?xml version='1.0'?>\n<xs:schema xmlns:xs='http://www.w3.org/2001/XMLSchema'           xmlns:jaxb='http://java.sun.com/xml/ns/jaxb'>\n  <xs:element name='x'>\n    <xs:annotation><xs:appinfo>\n      <jaxb:class name='b' implClass='com.b.c'/>\n    </xs:appinfo></xs:annotation>\n    <xs:complexType>\n      <xs:sequence>\n        <xs:element name='e'>\n          <xs:complexType>\n            <xs:sequence>\n              <xs:element name='x' type='xs:int'/>\n            </xs:sequence>\n            <xs:attribute name='y' type='xs:string'/>\n          </xs:complexType>\n        </xs:element>\n      </xs:sequence>\n    </xs:complexType>\n  </xs:element>\n</xs:schema>";
        parser = this.newJAXBParser();
        isource = new InputSource(new StringReader("<?xml version='1.0'?>\n<xs:schema xmlns:xs='http://www.w3.org/2001/XMLSchema'           xmlns:jaxb='http://java.sun.com/xml/ns/jaxb'>\n  <xs:element name='x'>\n    <xs:annotation><xs:appinfo>\n      <jaxb:class name='b' implClass='com.b.c'/>\n    </xs:appinfo></xs:annotation>\n    <xs:complexType>\n      <xs:sequence>\n        <xs:element name='e'>\n          <xs:complexType>\n            <xs:sequence>\n              <xs:element name='x' type='xs:int'/>\n            </xs:sequence>\n            <xs:attribute name='y' type='xs:string'/>\n          </xs:complexType>\n        </xs:element>\n      </xs:sequence>\n    </xs:complexType>\n  </xs:element>\n</xs:schema>"));
        isource.setSystemId("testJAXBClass3.xsd");
        boolean haveException = false;
        try {
            parser.parse(isource);
        }
        catch (SAXException e2) {
            haveException = true;
            JAXBParserTest.assertTrue((e2.getMessage().indexOf("[JAXB 6.7.3.4]") >= 0 ? 1 : 0) != 0);
        }
        JAXBParserTest.assertTrue((boolean)haveException);
    }

    public void testJAXBProperty1() throws Exception {
        String schemaSource = "<?xml version='1.0'?>\n<xs:schema xmlns:xs='http://www.w3.org/2001/XMLSchema'           xmlns:jaxb='http://java.sun.com/xml/ns/jaxb'>\n  <xs:complexType name='ct'>\n    <xs:sequence>\n    </xs:sequence>\n    <xs:attribute name='a' type='xs:dateTime'>\n      <xs:annotation><xs:appinfo>\n        <jaxb:property name='ap' collectionType='indexed'\n            fixedAttributeAsConstantProperty='true'\n            generateIsSetMethod='false'\n            enableFailFastCheck='1'>\n          <jaxb:baseType>\n            <jaxb:javaType name='java.math.BigDecimal'\n                parseMethod='javax.xml.bind.DatatypeConverter.parseInteger'\n                printMethod='javax.xml.bind.DatatypeConverter.printInteger'/>\n          </jaxb:baseType>\n        </jaxb:property>\n      </xs:appinfo></xs:annotation>\n    </xs:attribute>  </xs:complexType>\n</xs:schema>\n";
        JAXBParser parser = this.newJAXBParser();
        InputSource isource = new InputSource(new StringReader("<?xml version='1.0'?>\n<xs:schema xmlns:xs='http://www.w3.org/2001/XMLSchema'           xmlns:jaxb='http://java.sun.com/xml/ns/jaxb'>\n  <xs:complexType name='ct'>\n    <xs:sequence>\n    </xs:sequence>\n    <xs:attribute name='a' type='xs:dateTime'>\n      <xs:annotation><xs:appinfo>\n        <jaxb:property name='ap' collectionType='indexed'\n            fixedAttributeAsConstantProperty='true'\n            generateIsSetMethod='false'\n            enableFailFastCheck='1'>\n          <jaxb:baseType>\n            <jaxb:javaType name='java.math.BigDecimal'\n                parseMethod='javax.xml.bind.DatatypeConverter.parseInteger'\n                printMethod='javax.xml.bind.DatatypeConverter.printInteger'/>\n          </jaxb:baseType>\n        </jaxb:property>\n      </xs:appinfo></xs:annotation>\n    </xs:attribute>  </xs:complexType>\n</xs:schema>\n"));
        isource.setSystemId("testJAXBProperty1.xsd");
        JAXBSchema schema = (JAXBSchema)parser.parse(isource);
        XSType type = schema.getType(new XsQName((String)null, "ct"));
        XSComplexType complexType = this.assertComplexType(type);
        XSAttributable[] attributes = complexType.getAttributes();
        JAXBParserTest.assertNotNull((Object)attributes);
        JAXBParserTest.assertEquals((int)1, (int)attributes.length);
        JAXBAttribute a1 = (JAXBAttribute)attributes[0];
        JAXBParserTest.assertEquals((Object)XSDateTime.getInstance(), (Object)a1.getType());
        JAXBProperty ap1 = a1.getJAXBProperty();
        JAXBParserTest.assertNotNull((Object)ap1);
        JAXBParserTest.assertEquals((String)"ap", (String)ap1.getName());
        JAXBParserTest.assertEquals((String)"indexed", (String)ap1.getCollectionType());
        Boolean b = ap1.isFixedAttributeAsConstantProperty();
        JAXBParserTest.assertTrue((b != null && b != false ? 1 : 0) != 0);
        b = ap1.isGenerateIsSetMethod();
        JAXBParserTest.assertTrue((b != null && b == false ? 1 : 0) != 0);
        b = ap1.isEnableFailFastCheck();
        JAXBParserTest.assertTrue((b != null && b != false ? 1 : 0) != 0);
        JAXBProperty.BaseType apbt1 = ap1.getBaseType();
        JAXBParserTest.assertNotNull((Object)apbt1);
        JAXBJavaType apjt1 = apbt1.getJavaType();
        JAXBParserTest.assertNotNull((Object)apjt1);
        JAXBParserTest.assertEquals((String)"java.math.BigDecimal", (String)apjt1.getName());
        JAXBParserTest.assertEquals((String)"javax.xml.bind.DatatypeConverter.parseInteger", (String)apjt1.getParseMethod());
        JAXBParserTest.assertEquals((String)"javax.xml.bind.DatatypeConverter.printInteger", (String)apjt1.getPrintMethod());
    }

    public void testJAXBProperty2() throws Exception {
        String schemaSource = "<?xml version='1.0'?>\n<xs:schema xmlns:xs='http://www.w3.org/2001/XMLSchema'           xmlns:jaxb='http://java.sun.com/xml/ns/jaxb'>\n  <xs:attribute name='a' type='xs:dateTime'>\n    <xs:annotation><xs:appinfo>\n      <jaxb:property name='ap' collectionType='indexed'\n          fixedAttributeAsConstantProperty='true'\n          generateIsSetMethod='false'\n          enableFailFastCheck='1'>\n        <jaxb:baseType>\n          <jaxb:javaType name='java.math.BigDecimal'\n              parseMethod='javax.xml.bind.DatatypeConverter.parseInteger'\n              printMethod='javax.xml.bind.DatatypeConverter.printInteger'/>\n        </jaxb:baseType>\n      </jaxb:property>\n    </xs:appinfo></xs:annotation>\n  </xs:attribute></xs:schema>\n";
        JAXBParser parser = this.newJAXBParser();
        InputSource isource = new InputSource(new StringReader("<?xml version='1.0'?>\n<xs:schema xmlns:xs='http://www.w3.org/2001/XMLSchema'           xmlns:jaxb='http://java.sun.com/xml/ns/jaxb'>\n  <xs:attribute name='a' type='xs:dateTime'>\n    <xs:annotation><xs:appinfo>\n      <jaxb:property name='ap' collectionType='indexed'\n          fixedAttributeAsConstantProperty='true'\n          generateIsSetMethod='false'\n          enableFailFastCheck='1'>\n        <jaxb:baseType>\n          <jaxb:javaType name='java.math.BigDecimal'\n              parseMethod='javax.xml.bind.DatatypeConverter.parseInteger'\n              printMethod='javax.xml.bind.DatatypeConverter.printInteger'/>\n        </jaxb:baseType>\n      </jaxb:property>\n    </xs:appinfo></xs:annotation>\n  </xs:attribute></xs:schema>\n"));
        isource.setSystemId("testJAXBProperty2.xsd");
        boolean haveException = false;
        try {
            parser.parse(isource);
        }
        catch (SAXException e) {
            haveException = true;
            JAXBParserTest.assertTrue((e.getMessage().indexOf("[JAXB 6.8.1.2.1]") >= 0 ? 1 : 0) != 0);
        }
        JAXBParserTest.assertTrue((boolean)haveException);
    }

    public void testJAXBProperty3() throws Exception {
        String schemaSource = "<?xml version='1.0'?>\n<xs:schema xmlns:xs='http://www.w3.org/2001/XMLSchema'           xmlns:jaxb='http://java.sun.com/xml/ns/jaxb'>\n  <xs:attribute name='a' type='xs:dateTime'>\n    <xs:annotation><xs:appinfo>\n      <jaxb:property name='ap' collectionType='indexed'\n          fixedAttributeAsConstantProperty='true'\n          generateIsSetMethod='false'\n          enableFailFastCheck='1'>\n      </jaxb:property>\n    </xs:appinfo></xs:annotation>\n  </xs:attribute>  <xs:complexType name='ct'>\n    <xs:sequence>\n    </xs:sequence>\n    <xs:attribute ref='a'/>\n  </xs:complexType>\n</xs:schema>\n";
        JAXBParser parser = this.newJAXBParser();
        InputSource isource = new InputSource(new StringReader("<?xml version='1.0'?>\n<xs:schema xmlns:xs='http://www.w3.org/2001/XMLSchema'           xmlns:jaxb='http://java.sun.com/xml/ns/jaxb'>\n  <xs:attribute name='a' type='xs:dateTime'>\n    <xs:annotation><xs:appinfo>\n      <jaxb:property name='ap' collectionType='indexed'\n          fixedAttributeAsConstantProperty='true'\n          generateIsSetMethod='false'\n          enableFailFastCheck='1'>\n      </jaxb:property>\n    </xs:appinfo></xs:annotation>\n  </xs:attribute>  <xs:complexType name='ct'>\n    <xs:sequence>\n    </xs:sequence>\n    <xs:attribute ref='a'/>\n  </xs:complexType>\n</xs:schema>\n"));
        isource.setSystemId("testJAXBProperty1.xsd");
        JAXBSchema schema = (JAXBSchema)parser.parse(isource);
        XSAttribute[] outerAttr = schema.getAttributes();
        JAXBParserTest.assertEquals((int)1, (int)outerAttr.length);
        JAXBAttribute outerA = (JAXBAttribute)outerAttr[0];
        XSType ct = schema.getType(new XsQName((String)null, "ct"));
        XSAttributable[] attributes = this.assertComplexType(ct).getAttributes();
        JAXBParserTest.assertNotNull((Object)attributes);
        JAXBParserTest.assertEquals((int)1, (int)attributes.length);
        JAXBAttribute a1 = (JAXBAttribute)attributes[0];
        JAXBParserTest.assertEquals((Object)XSDateTime.getInstance(), (Object)a1.getType());
        JAXBProperty ap1 = a1.getJAXBProperty();
        JAXBParserTest.assertEquals((Object)ap1, (Object)outerA.getJAXBProperty());
        JAXBParserTest.assertNotNull((Object)ap1);
        JAXBParserTest.assertEquals((String)"ap", (String)ap1.getName());
        JAXBParserTest.assertEquals((String)"indexed", (String)ap1.getCollectionType());
        Boolean b = ap1.isFixedAttributeAsConstantProperty();
        JAXBParserTest.assertTrue((b != null && b != false ? 1 : 0) != 0);
        b = ap1.isGenerateIsSetMethod();
        JAXBParserTest.assertTrue((b != null && b == false ? 1 : 0) != 0);
        b = ap1.isEnableFailFastCheck();
        JAXBParserTest.assertTrue((b != null && b != false ? 1 : 0) != 0);
        JAXBParserTest.assertNull((Object)ap1.getBaseType());
    }

    public void testJAXBJavaType1() throws Exception {
        String schemaSource = "<?xml version='1.0'?>\n<xs:schema xmlns:xs='http://www.w3.org/2001/XMLSchema'           xmlns:jaxb='http://java.sun.com/xml/ns/jaxb'>\n  <xs:simpleType name='a'>\n    <xs:annotation><xs:appinfo>\n      <jaxb:javaType name='java.math.BigDecimal'\n          hasNsContext='0'\n          parseMethod='javax.xml.bind.DatatypeConverter.parseInteger'\n          printMethod='javax.xml.bind.DatatypeConverter.printInteger'/>\n    </xs:appinfo></xs:annotation>\n    <xs:restriction base='xs:string'/>\n  </xs:simpleType>\n  <xs:element name='b'>\n    <xs:simpleType>\n      <xs:restriction base='a'/>\n    </xs:simpleType>\n  </xs:element>\n  <xs:element name='c'>\n    <xs:simpleType>\n    <xs:annotation><xs:appinfo>\n      <jaxb:javaType name='java.math.BigInteger'\n          hasNsContext='true'\n          parseMethod='javax.xml.bind.DatatypeConverter.parseInt'\n          printMethod='javax.xml.bind.DatatypeConverter.printInt'/>\n    </xs:appinfo></xs:annotation>\n      <xs:restriction base='a'/>\n    </xs:simpleType>\n  </xs:element>\n</xs:schema>\n";
        JAXBParser parser = this.newJAXBParser();
        InputSource isource = new InputSource(new StringReader("<?xml version='1.0'?>\n<xs:schema xmlns:xs='http://www.w3.org/2001/XMLSchema'           xmlns:jaxb='http://java.sun.com/xml/ns/jaxb'>\n  <xs:simpleType name='a'>\n    <xs:annotation><xs:appinfo>\n      <jaxb:javaType name='java.math.BigDecimal'\n          hasNsContext='0'\n          parseMethod='javax.xml.bind.DatatypeConverter.parseInteger'\n          printMethod='javax.xml.bind.DatatypeConverter.printInteger'/>\n    </xs:appinfo></xs:annotation>\n    <xs:restriction base='xs:string'/>\n  </xs:simpleType>\n  <xs:element name='b'>\n    <xs:simpleType>\n      <xs:restriction base='a'/>\n    </xs:simpleType>\n  </xs:element>\n  <xs:element name='c'>\n    <xs:simpleType>\n    <xs:annotation><xs:appinfo>\n      <jaxb:javaType name='java.math.BigInteger'\n          hasNsContext='true'\n          parseMethod='javax.xml.bind.DatatypeConverter.parseInt'\n          printMethod='javax.xml.bind.DatatypeConverter.printInt'/>\n    </xs:appinfo></xs:annotation>\n      <xs:restriction base='a'/>\n    </xs:simpleType>\n  </xs:element>\n</xs:schema>\n"));
        isource.setSystemId("testJAXBJavaType1.xsd");
        JAXBSchema schema = (JAXBSchema)parser.parse(isource);
        XSType a = schema.getType(new XsQName((String)null, "a"));
        JAXBSimpleType ast = (JAXBSimpleType)this.assertSimpleType(a);
        JAXBJavaType ajjt = ast.getJAXBJavaType();
        JAXBParserTest.assertEquals((String)"java.math.BigDecimal", (String)ajjt.getName());
        JAXBParserTest.assertEquals((String)"javax.xml.bind.DatatypeConverter.parseInteger", (String)ajjt.getParseMethod());
        JAXBParserTest.assertEquals((String)"javax.xml.bind.DatatypeConverter.printInteger", (String)ajjt.getPrintMethod());
        JAXBParserTest.assertTrue((!ajjt.hasNsContext() ? 1 : 0) != 0);
        XSElement b = schema.getElement(new XsQName((String)null, "b"));
        XSType bt = b.getType();
        JAXBSimpleType bst = (JAXBSimpleType)this.assertSimpleType(bt);
        JAXBParserTest.assertEquals((Object)a, (Object)this.assertRestriction(bst));
        JAXBParserTest.assertNull((Object)bst.getJAXBJavaType());
        XSElement c = schema.getElement(new XsQName((String)null, "c"));
        XSType ct = c.getType();
        JAXBSimpleType cst = (JAXBSimpleType)this.assertSimpleType(ct);
        JAXBParserTest.assertEquals((Object)a, (Object)this.assertRestriction(cst));
        JAXBJavaType cjjt = cst.getJAXBJavaType();
        JAXBParserTest.assertEquals((String)"java.math.BigInteger", (String)cjjt.getName());
        JAXBParserTest.assertEquals((String)"javax.xml.bind.DatatypeConverter.parseInt", (String)cjjt.getParseMethod());
        JAXBParserTest.assertEquals((String)"javax.xml.bind.DatatypeConverter.printInt", (String)cjjt.getPrintMethod());
        JAXBParserTest.assertTrue((boolean)cjjt.hasNsContext());
    }

    private void checkJAXBTypesafeEnumClass1AType(XSType pType) throws SAXException {
        JAXBSimpleType ast = (JAXBSimpleType)this.assertSimpleType(pType);
        JAXBTypesafeEnumClass aec = ast.getJAXBTypesafeEnumClass();
        JAXBParserTest.assertEquals((String)"USStateAbbr", (String)aec.getName());
        JAXBParserTest.assertTrue((!aec.getTypesafeEnumMember().hasNext() ? 1 : 0) != 0);
        XSEnumeration[] enumerations = ast.getEnumerations();
        JAXBParserTest.assertEquals((int)2, (int)enumerations.length);
        JAXBEnumeration e1 = (JAXBEnumeration)enumerations[0];
        JAXBParserTest.assertEquals((String)"AK", (String)e1.getValue());
        JAXBTypesafeEnumMember m1 = e1.getJAXBTypesafeEnumMember();
        JAXBParserTest.assertEquals((String)"STATE_AK", (String)m1.getName());
        JAXBEnumeration e2 = (JAXBEnumeration)enumerations[1];
        JAXBTypesafeEnumMember m2 = e2.getJAXBTypesafeEnumMember();
        JAXBParserTest.assertEquals((String)"STATE_AL", (String)m2.getName());
        JAXBParserTest.assertEquals((String)"AL", (String)e2.getValue());
    }

    private void checkJAXBTypesafeEnumClass1BType(XSType pType) throws SAXException {
        JAXBSimpleType bst = (JAXBSimpleType)this.assertSimpleType(pType);
        JAXBTypesafeEnumClass bec = bst.getJAXBTypesafeEnumClass();
        JAXBParserTest.assertEquals((String)"USStateAbbr2", (String)bec.getName());
        Iterator iter = bec.getTypesafeEnumMember();
        JAXBParserTest.assertTrue((boolean)iter.hasNext());
        JAXBTypesafeEnumMember iem = (JAXBTypesafeEnumMember)iter.next();
        JAXBParserTest.assertEquals((String)"STATE2_AK", (String)iem.getName());
        JAXBParserTest.assertEquals((String)"AK", (String)iem.getValue());
        JAXBParserTest.assertTrue((boolean)iter.hasNext());
        iem = (JAXBTypesafeEnumMember)iter.next();
        JAXBParserTest.assertEquals((String)"STATE2_AL", (String)iem.getName());
        JAXBParserTest.assertEquals((String)"AL", (String)iem.getValue());
        JAXBParserTest.assertTrue((!iter.hasNext() ? 1 : 0) != 0);
        XSEnumeration[] enumerations = bst.getEnumerations();
        JAXBParserTest.assertEquals((int)2, (int)enumerations.length);
        JAXBEnumeration be1 = (JAXBEnumeration)enumerations[0];
        JAXBParserTest.assertEquals((String)"AK", (String)be1.getValue());
        JAXBParserTest.assertNull((Object)be1.getJAXBTypesafeEnumMember());
        JAXBEnumeration be2 = (JAXBEnumeration)enumerations[1];
        JAXBParserTest.assertEquals((String)"AL", (String)be2.getValue());
        JAXBParserTest.assertNull((Object)be2.getJAXBTypesafeEnumMember());
    }

    public void testJAXBTypesafeEnumClass1() throws Exception {
        String schemaSource = "<?xml version='1.0'?>\n<xs:schema xmlns:xs='http://www.w3.org/2001/XMLSchema'           xmlns:jaxb='http://java.sun.com/xml/ns/jaxb'>\n  <xs:simpleType name='a'>\n    <xs:annotation><xs:appinfo>\n      <jaxb:typesafeEnumClass name='USStateAbbr'/>\n    </xs:appinfo></xs:annotation>\n    <xs:restriction base='xs:NCName'>\n      <xs:enumeration value='AK'>\n        <xs:annotation><xs:appinfo>\n          <jaxb:typesafeEnumMember name='STATE_AK'/>\n        </xs:appinfo></xs:annotation>\n      </xs:enumeration>\n      <xs:enumeration value='AL'>\n        <xs:annotation><xs:appinfo>\n          <jaxb:typesafeEnumMember name='STATE_AL'/>\n        </xs:appinfo></xs:annotation>\n      </xs:enumeration>\n    </xs:restriction>\n  </xs:simpleType>\n  <xs:simpleType name='b'>\n    <xs:annotation><xs:appinfo>\n      <jaxb:typesafeEnumClass name='USStateAbbr2'>\n        <jaxb:typesafeEnumMember name='STATE2_AK' value='AK'/>\n        <jaxb:typesafeEnumMember name='STATE2_AL' value='AL'/>\n      </jaxb:typesafeEnumClass>\n    </xs:appinfo></xs:annotation>\n    <xs:restriction base='xs:NCName'>\n      <xs:enumeration value='AK'/>\n      <xs:enumeration value='AL'/>\n    </xs:restriction>\n  </xs:simpleType>\n\n  <xs:element name='allTypes'>\n    <xs:complexType>\n      <xs:sequence>\n        <xs:element name='aElement' type='a'/>\n        <xs:element name='bElement' type='b'/>\n      </xs:sequence>\n    </xs:complexType>\n  </xs:element>\n</xs:schema>\n";
        JAXBParser parser = this.newJAXBParser();
        InputSource isource = new InputSource(new StringReader("<?xml version='1.0'?>\n<xs:schema xmlns:xs='http://www.w3.org/2001/XMLSchema'           xmlns:jaxb='http://java.sun.com/xml/ns/jaxb'>\n  <xs:simpleType name='a'>\n    <xs:annotation><xs:appinfo>\n      <jaxb:typesafeEnumClass name='USStateAbbr'/>\n    </xs:appinfo></xs:annotation>\n    <xs:restriction base='xs:NCName'>\n      <xs:enumeration value='AK'>\n        <xs:annotation><xs:appinfo>\n          <jaxb:typesafeEnumMember name='STATE_AK'/>\n        </xs:appinfo></xs:annotation>\n      </xs:enumeration>\n      <xs:enumeration value='AL'>\n        <xs:annotation><xs:appinfo>\n          <jaxb:typesafeEnumMember name='STATE_AL'/>\n        </xs:appinfo></xs:annotation>\n      </xs:enumeration>\n    </xs:restriction>\n  </xs:simpleType>\n  <xs:simpleType name='b'>\n    <xs:annotation><xs:appinfo>\n      <jaxb:typesafeEnumClass name='USStateAbbr2'>\n        <jaxb:typesafeEnumMember name='STATE2_AK' value='AK'/>\n        <jaxb:typesafeEnumMember name='STATE2_AL' value='AL'/>\n      </jaxb:typesafeEnumClass>\n    </xs:appinfo></xs:annotation>\n    <xs:restriction base='xs:NCName'>\n      <xs:enumeration value='AK'/>\n      <xs:enumeration value='AL'/>\n    </xs:restriction>\n  </xs:simpleType>\n\n  <xs:element name='allTypes'>\n    <xs:complexType>\n      <xs:sequence>\n        <xs:element name='aElement' type='a'/>\n        <xs:element name='bElement' type='b'/>\n      </xs:sequence>\n    </xs:complexType>\n  </xs:element>\n</xs:schema>\n"));
        isource.setSystemId("testJAXBJavaTypesafeEnumClass1.xsd");
        JAXBSchema schema = (JAXBSchema)parser.parse(isource);
        XSType a = schema.getType(new XsQName((String)null, "a"));
        this.checkJAXBTypesafeEnumClass1AType(a);
        XSType b = schema.getType(new XsQName((String)null, "b"));
        this.checkJAXBTypesafeEnumClass1BType(b);
        XSElement[] elements = schema.getElements();
        JAXBParserTest.assertEquals((int)1, (int)elements.length);
        XSElement allTypesElement = elements[0];
        XSGroup allTypesGroup = this.assertGroup(this.assertComplexContent(this.assertComplexType(allTypesElement.getType())));
        this.assertSequence(allTypesGroup);
        XSParticle[] allTypesChilds = allTypesGroup.getParticles();
        JAXBParserTest.assertEquals((int)2, (int)allTypesChilds.length);
        this.checkJAXBTypesafeEnumClass1AType(this.assertElement(allTypesChilds[0]).getType());
        this.checkJAXBTypesafeEnumClass1BType(this.assertElement(allTypesChilds[1]).getType());
    }

    public void testJAXBTypesafeEnumClass2() throws Exception {
        String schemaSource = "<xs:schema xmlns:xs='http://www.w3.org/2001/XMLSchema' xml:lang='EN'\n    targetNamespace='http://ws.apache.org/jaxme/examples/misc/enumeration'\n    xmlns:ex='http://ws.apache.org/jaxme/examples/misc/enumeration'\n    xmlns:jaxb='http://java.sun.com/xml/ns/jaxb'\n    elementFormDefault='qualified'\n    attributeFormDefault='unqualified'>\n  <xs:annotation>\n    <xs:documentation>\n      Demonstration of a complex type with all sorts of enumeration values\n    </xs:documentation>\n    <xs:appinfo>\n      <jaxb:globalBindings typesafeEnumBase='xs:string xs:int xs:long xs:short xs:double xs:float'/>\n    </xs:appinfo>\n  </xs:annotation>\n\n  <!-- In this example the typesafeEnumMember instances are part of the\n       typesafeEnumClass. -->\n  <xs:simpleType name='StringType'>\n    <xs:annotation>\n      <xs:appinfo>\n        <jaxb:typesafeEnumClass name='MyStringTypeClass'>\n          <jaxb:typesafeEnumMember name='FOO' value='FOO'/>\n          <jaxb:typesafeEnumMember name='BAR' value='BAR'/>\n        </jaxb:typesafeEnumClass>\n      </xs:appinfo>\n    </xs:annotation>\n    <xs:restriction base='xs:string'>\n      <xs:enumeration value='FOO'/>\n      <xs:enumeration value='BAR'/>\n    </xs:restriction>\n  </xs:simpleType>\n\n  <!-- Here's another case: The typesafeEnumMember instances are part\n       of their respective values. Choose your own style. -->\n  <xs:simpleType name='IntType'>\n    <xs:annotation><xs:appinfo>\n      <jaxb:typesafeEnumClass name='MyIntTypeClass'/>\n    </xs:appinfo></xs:annotation>\n    <xs:restriction base='xs:int'>\n      <xs:enumeration value='3'>\n        <xs:annotation><xs:appinfo>\n          <jaxb:typesafeEnumMember name='INT3'/>\n        </xs:appinfo></xs:annotation>\n      </xs:enumeration>\n      <xs:enumeration value='0'>\n        <xs:annotation><xs:appinfo>\n          <jaxb:typesafeEnumMember name='INT0'/>\n        </xs:appinfo></xs:annotation>\n      </xs:enumeration>\n      <xs:enumeration value='-7'>\n        <xs:annotation><xs:appinfo>\n          <jaxb:typesafeEnumMember name='INT_7'/>\n        </xs:appinfo></xs:annotation>\n      </xs:enumeration>\n    </xs:restriction>\n  </xs:simpleType>\n\n  <!-- I personally prefer the former style, for shortness. So we\n       revert to this style. -->\n  <xs:simpleType name='LongType'>\n    <xs:annotation><xs:appinfo>\n      <jaxb:typesafeEnumClass name='MyLongTypeClass'>\n        <jaxb:typesafeEnumMember name='LONG_POSITIVE' value='987298379879887'/>\n        <jaxb:typesafeEnumMember name='LONG_ZERO' value='0'/>\n        <jaxb:typesafeEnumMember name='LONG_NEGATIVE' value='-23987982739273989'/>\n      </jaxb:typesafeEnumClass>\n    </xs:appinfo></xs:annotation>\n    <xs:restriction base='xs:long'>\n      <xs:enumeration value='987298379879887'/>\n      <xs:enumeration value='0'/>\n      <xs:enumeration value='-23987982739273989'/>\n    </xs:restriction>\n  </xs:simpleType>\n\n  <xs:simpleType name='ShortType'>\n    <xs:annotation><xs:appinfo>\n      <jaxb:typesafeEnumClass name='MyShortTypeClass'>\n        <jaxb:typesafeEnumMember name='SHORT_POSITIVE' value='3468'/>\n        <jaxb:typesafeEnumMember name='SHORT_ZERO' value='0'/>\n        <jaxb:typesafeEnumMember name='SHORT_NEGATIVE' value='-23'/>\n      </jaxb:typesafeEnumClass>\n    </xs:appinfo></xs:annotation>\n    <xs:restriction base='xs:short'>\n      <xs:enumeration value='3468'/>\n      <xs:enumeration value='0'/>\n      <xs:enumeration value='-23'/>\n    </xs:restriction>\n  </xs:simpleType>\n\n  <xs:simpleType name='DoubleType'>\n    <xs:annotation><xs:appinfo>\n      <jaxb:typesafeEnumClass name='MyDoubleTypeClass'>\n        <jaxb:typesafeEnumMember name='DOUBLE_POSITIVE' value='3249239847982.234'/>\n        <jaxb:typesafeEnumMember name='DOUBLE_ZERO' value='0'/>\n        <jaxb:typesafeEnumMember name='DOUBLE_NEGATIVE' value='-324234.234'/>\n      </jaxb:typesafeEnumClass>\n    </xs:appinfo></xs:annotation>\n    <xs:restriction base='xs:double'>\n      <xs:enumeration value='3249239847982.234'/>\n      <xs:enumeration value='0'/>\n      <xs:enumeration value='-324234.234'/>\n    </xs:restriction>\n  </xs:simpleType>\n\n  <xs:simpleType name='FloatType'>\n    <xs:annotation><xs:appinfo>\n      <jaxb:typesafeEnumClass name='MyFloatTypeClass'>\n        <jaxb:typesafeEnumMember name='FLOAT_POSITIVE' value='47982.234'/>\n        <jaxb:typesafeEnumMember name='FLOAT_ZERO' value='0'/>\n        <jaxb:typesafeEnumMember name='FLOAT_NEGATIVE' value='-24234.234'/>\n      </jaxb:typesafeEnumClass>\n    </xs:appinfo></xs:annotation>\n    <xs:restriction base='xs:float'>\n      <xs:enumeration value='47982.234'/>\n      <xs:enumeration value='0'/>\n      <xs:enumeration value='-24234.234'/>\n    </xs:restriction>\n  </xs:simpleType>\n\n  <xs:complexType name='AllSimpleTypes'>\n    <xs:sequence>\n      <xs:element name='StringElem' type='ex:StringType'/>\n      <xs:element name='IntElem' type='ex:IntType'/>\n      <xs:element name='LongElem' type='ex:LongType'/>\n      <xs:element name='ShortElem' type='ex:ShortType'/>\n      <xs:element name='DoubleElem' type='ex:DoubleType'/>\n      <xs:element name='FloatElem' type='ex:FloatType'/>\n      <xs:element name='DateTimeElem' minOccurs='0'>\n        <xs:simpleType>\n          <xs:restriction base='xs:dateTime'>\n            <xs:enumeration value='2002-12-17T12:23:11'/>\n            <xs:enumeration value='2002-12-16T12:00:11'/>\n          </xs:restriction>\n        </xs:simpleType>\n      </xs:element>\n      <xs:element name='DateElem' minOccurs='0'>\n        <xs:simpleType>\n          <xs:restriction base='xs:date'>\n            <xs:enumeration value='2002-12-17'/>\n            <xs:enumeration value='2002-12-16'/>\n          </xs:restriction>\n        </xs:simpleType>\n      </xs:element>\n      <xs:element name='TimeElem' minOccurs='0'>\n        <xs:simpleType>\n          <xs:restriction base='xs:time'>\n            <xs:enumeration value='12:23:11'/>\n            <xs:enumeration value='12:00:11'/>\n          </xs:restriction>\n        </xs:simpleType>\n      </xs:element>\n    </xs:sequence>\n  </xs:complexType>\n\n  <xs:element name='AllTypesElement'>\n    <xs:complexType>\n      <xs:sequence>\n        <xs:element type='ex:AllSimpleTypes' name='AllSimpleTypesElement'/>\n      </xs:sequence>\n    </xs:complexType>\n  </xs:element>\n</xs:schema>\n";
        JAXBParser parser = this.newJAXBParser();
        InputSource isource = new InputSource(new StringReader("<xs:schema xmlns:xs='http://www.w3.org/2001/XMLSchema' xml:lang='EN'\n    targetNamespace='http://ws.apache.org/jaxme/examples/misc/enumeration'\n    xmlns:ex='http://ws.apache.org/jaxme/examples/misc/enumeration'\n    xmlns:jaxb='http://java.sun.com/xml/ns/jaxb'\n    elementFormDefault='qualified'\n    attributeFormDefault='unqualified'>\n  <xs:annotation>\n    <xs:documentation>\n      Demonstration of a complex type with all sorts of enumeration values\n    </xs:documentation>\n    <xs:appinfo>\n      <jaxb:globalBindings typesafeEnumBase='xs:string xs:int xs:long xs:short xs:double xs:float'/>\n    </xs:appinfo>\n  </xs:annotation>\n\n  <!-- In this example the typesafeEnumMember instances are part of the\n       typesafeEnumClass. -->\n  <xs:simpleType name='StringType'>\n    <xs:annotation>\n      <xs:appinfo>\n        <jaxb:typesafeEnumClass name='MyStringTypeClass'>\n          <jaxb:typesafeEnumMember name='FOO' value='FOO'/>\n          <jaxb:typesafeEnumMember name='BAR' value='BAR'/>\n        </jaxb:typesafeEnumClass>\n      </xs:appinfo>\n    </xs:annotation>\n    <xs:restriction base='xs:string'>\n      <xs:enumeration value='FOO'/>\n      <xs:enumeration value='BAR'/>\n    </xs:restriction>\n  </xs:simpleType>\n\n  <!-- Here's another case: The typesafeEnumMember instances are part\n       of their respective values. Choose your own style. -->\n  <xs:simpleType name='IntType'>\n    <xs:annotation><xs:appinfo>\n      <jaxb:typesafeEnumClass name='MyIntTypeClass'/>\n    </xs:appinfo></xs:annotation>\n    <xs:restriction base='xs:int'>\n      <xs:enumeration value='3'>\n        <xs:annotation><xs:appinfo>\n          <jaxb:typesafeEnumMember name='INT3'/>\n        </xs:appinfo></xs:annotation>\n      </xs:enumeration>\n      <xs:enumeration value='0'>\n        <xs:annotation><xs:appinfo>\n          <jaxb:typesafeEnumMember name='INT0'/>\n        </xs:appinfo></xs:annotation>\n      </xs:enumeration>\n      <xs:enumeration value='-7'>\n        <xs:annotation><xs:appinfo>\n          <jaxb:typesafeEnumMember name='INT_7'/>\n        </xs:appinfo></xs:annotation>\n      </xs:enumeration>\n    </xs:restriction>\n  </xs:simpleType>\n\n  <!-- I personally prefer the former style, for shortness. So we\n       revert to this style. -->\n  <xs:simpleType name='LongType'>\n    <xs:annotation><xs:appinfo>\n      <jaxb:typesafeEnumClass name='MyLongTypeClass'>\n        <jaxb:typesafeEnumMember name='LONG_POSITIVE' value='987298379879887'/>\n        <jaxb:typesafeEnumMember name='LONG_ZERO' value='0'/>\n        <jaxb:typesafeEnumMember name='LONG_NEGATIVE' value='-23987982739273989'/>\n      </jaxb:typesafeEnumClass>\n    </xs:appinfo></xs:annotation>\n    <xs:restriction base='xs:long'>\n      <xs:enumeration value='987298379879887'/>\n      <xs:enumeration value='0'/>\n      <xs:enumeration value='-23987982739273989'/>\n    </xs:restriction>\n  </xs:simpleType>\n\n  <xs:simpleType name='ShortType'>\n    <xs:annotation><xs:appinfo>\n      <jaxb:typesafeEnumClass name='MyShortTypeClass'>\n        <jaxb:typesafeEnumMember name='SHORT_POSITIVE' value='3468'/>\n        <jaxb:typesafeEnumMember name='SHORT_ZERO' value='0'/>\n        <jaxb:typesafeEnumMember name='SHORT_NEGATIVE' value='-23'/>\n      </jaxb:typesafeEnumClass>\n    </xs:appinfo></xs:annotation>\n    <xs:restriction base='xs:short'>\n      <xs:enumeration value='3468'/>\n      <xs:enumeration value='0'/>\n      <xs:enumeration value='-23'/>\n    </xs:restriction>\n  </xs:simpleType>\n\n  <xs:simpleType name='DoubleType'>\n    <xs:annotation><xs:appinfo>\n      <jaxb:typesafeEnumClass name='MyDoubleTypeClass'>\n        <jaxb:typesafeEnumMember name='DOUBLE_POSITIVE' value='3249239847982.234'/>\n        <jaxb:typesafeEnumMember name='DOUBLE_ZERO' value='0'/>\n        <jaxb:typesafeEnumMember name='DOUBLE_NEGATIVE' value='-324234.234'/>\n      </jaxb:typesafeEnumClass>\n    </xs:appinfo></xs:annotation>\n    <xs:restriction base='xs:double'>\n      <xs:enumeration value='3249239847982.234'/>\n      <xs:enumeration value='0'/>\n      <xs:enumeration value='-324234.234'/>\n    </xs:restriction>\n  </xs:simpleType>\n\n  <xs:simpleType name='FloatType'>\n    <xs:annotation><xs:appinfo>\n      <jaxb:typesafeEnumClass name='MyFloatTypeClass'>\n        <jaxb:typesafeEnumMember name='FLOAT_POSITIVE' value='47982.234'/>\n        <jaxb:typesafeEnumMember name='FLOAT_ZERO' value='0'/>\n        <jaxb:typesafeEnumMember name='FLOAT_NEGATIVE' value='-24234.234'/>\n      </jaxb:typesafeEnumClass>\n    </xs:appinfo></xs:annotation>\n    <xs:restriction base='xs:float'>\n      <xs:enumeration value='47982.234'/>\n      <xs:enumeration value='0'/>\n      <xs:enumeration value='-24234.234'/>\n    </xs:restriction>\n  </xs:simpleType>\n\n  <xs:complexType name='AllSimpleTypes'>\n    <xs:sequence>\n      <xs:element name='StringElem' type='ex:StringType'/>\n      <xs:element name='IntElem' type='ex:IntType'/>\n      <xs:element name='LongElem' type='ex:LongType'/>\n      <xs:element name='ShortElem' type='ex:ShortType'/>\n      <xs:element name='DoubleElem' type='ex:DoubleType'/>\n      <xs:element name='FloatElem' type='ex:FloatType'/>\n      <xs:element name='DateTimeElem' minOccurs='0'>\n        <xs:simpleType>\n          <xs:restriction base='xs:dateTime'>\n            <xs:enumeration value='2002-12-17T12:23:11'/>\n            <xs:enumeration value='2002-12-16T12:00:11'/>\n          </xs:restriction>\n        </xs:simpleType>\n      </xs:element>\n      <xs:element name='DateElem' minOccurs='0'>\n        <xs:simpleType>\n          <xs:restriction base='xs:date'>\n            <xs:enumeration value='2002-12-17'/>\n            <xs:enumeration value='2002-12-16'/>\n          </xs:restriction>\n        </xs:simpleType>\n      </xs:element>\n      <xs:element name='TimeElem' minOccurs='0'>\n        <xs:simpleType>\n          <xs:restriction base='xs:time'>\n            <xs:enumeration value='12:23:11'/>\n            <xs:enumeration value='12:00:11'/>\n          </xs:restriction>\n        </xs:simpleType>\n      </xs:element>\n    </xs:sequence>\n  </xs:complexType>\n\n  <xs:element name='AllTypesElement'>\n    <xs:complexType>\n      <xs:sequence>\n        <xs:element type='ex:AllSimpleTypes' name='AllSimpleTypesElement'/>\n      </xs:sequence>\n    </xs:complexType>\n  </xs:element>\n</xs:schema>\n"));
        isource.setSystemId("testJAXBJavaTypesafeEnumClass2.xsd");
        JAXBSchema schema = (JAXBSchema)parser.parse(isource);
        XSType[] types = schema.getTypes();
        JAXBParserTest.assertEquals((int)7, (int)types.length);
        XSType stringType = types[0];
        this.checkJAXBTypesafeEnumClass2StringType(stringType);
        XSElement[] elements = schema.getElements();
        JAXBParserTest.assertEquals((int)1, (int)elements.length);
        XSElement allTypesElement = elements[0];
        XSParticle allTypesElementParticle = this.assertComplexContent(this.assertComplexType(allTypesElement.getType()));
        XSGroup group = allTypesElementParticle.getGroup();
        this.assertSequence(group);
        XSParticle[] allTypesElementsChilds = group.getParticles();
        JAXBParserTest.assertEquals((int)1, (int)allTypesElementsChilds.length);
        XSElement allSimpleTypesElement = this.assertElement(allTypesElementsChilds[0]);
        XSParticle allSimpleTypesElementParticle = this.assertComplexContent(this.assertComplexType(allSimpleTypesElement.getType()));
        XSGroup allSimpleTypesElementGroup = allSimpleTypesElementParticle.getGroup();
        this.assertSequence(allSimpleTypesElementGroup);
        XSParticle[] allSimpleTypesElementChilds = allSimpleTypesElementGroup.getParticles();
        JAXBParserTest.assertEquals((int)9, (int)allSimpleTypesElementChilds.length);
        XSElement stringTypeElement = this.assertElement(allSimpleTypesElementChilds[0]);
        this.checkJAXBTypesafeEnumClass2StringType(stringTypeElement.getType());
    }

    private void checkJAXBTypesafeEnumClass2StringType(XSType pType) throws SAXException {
        XSSimpleType stStringType = this.assertSimpleType(pType);
        JAXBParserTest.assertEquals((Object)XSString.getInstance(), (Object)this.assertRestriction(stStringType));
        JAXBParserTest.assertTrue((boolean)(stStringType instanceof JAXBSimpleType));
        JAXBSimpleType jaxbStringType = (JAXBSimpleType)stStringType;
        JAXBTypesafeEnumClass typesafeEnumClass = jaxbStringType.getJAXBTypesafeEnumClass();
        JAXBParserTest.assertNotNull((Object)typesafeEnumClass);
        JAXBParserTest.assertEquals((String)"MyStringTypeClass", (String)typesafeEnumClass.getName());
    }
}

