/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.proxy.impl.factory;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.HashSet;
import java.util.Set;
import org.jboss.aop.Advisor;
import org.jboss.aop.AspectManager;
import org.jboss.aop.advice.AdviceStack;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.microcontainer.annotations.DisableAOP;
import org.jboss.ejb3.proxy.impl.factory.ProxyFactory;
import org.jboss.logging.Logger;

@DisableAOP
public abstract class ProxyFactoryBase
implements ProxyFactory {
    private static final Logger log = Logger.getLogger(ProxyFactoryBase.class);
    private String name;
    private String containerName;
    private String containerGuid;
    private ClassLoader classloader;
    private Advisor advisor;

    public ProxyFactoryBase(String name, String containerName, String containerGuid, ClassLoader classloader, Advisor advisor) {
        this.setName(name);
        this.setContainerName(containerName);
        this.setContainerGuid(containerGuid);
        this.setClassLoader(classloader);
        this.setAdvisor(advisor);
    }

    protected Constructor<?> createProxyConstructor(Set<Class<?>> interfaces, ClassLoader cl) {
        interfaces.addAll(this.getCommonProxyInterfaces());
        Class<?> proxyClass = Proxy.getProxyClass(cl, interfaces.toArray(new Class[0]));
        Constructor<?> proxyConstructor = null;
        try {
            proxyConstructor = proxyClass.getConstructor(InvocationHandler.class);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        return proxyConstructor;
    }

    protected Set<Class<?>> getCommonProxyInterfaces() {
        HashSet interfaces = new HashSet();
        return interfaces;
    }

    protected String getInterceptorStackName() {
        return null;
    }

    protected Interceptor[] getInterceptors() {
        String stackName = this.getInterceptorStackName();
        if (stackName == null) {
            return new Interceptor[0];
        }
        AspectManager manager = AspectManager.instance();
        AdviceStack stack = manager.getAdviceStack(stackName);
        assert (stack != null) : "Could not find Advice Stack with name: " + stackName;
        Advisor advisor = this.getAdvisor();
        Interceptor[] interceptors = stack.createInterceptors(advisor, null);
        return interceptors;
    }

    @Override
    public void start() throws Exception {
        log.debug((Object)("Started: " + this));
    }

    @Override
    public void stop() throws Exception {
        log.debug((Object)("Stopped: " + this));
    }

    public ClassLoader getClassLoader() {
        return this.classloader;
    }

    protected void setClassLoader(ClassLoader classloader) {
        this.classloader = classloader;
    }

    @Override
    public String getName() {
        return this.name;
    }

    protected void setName(String name) {
        this.name = name;
    }

    protected String getContainerName() {
        return this.containerName;
    }

    public void setContainerName(String containerName) {
        this.containerName = containerName;
    }

    protected Advisor getAdvisor() {
        return this.advisor;
    }

    private void setAdvisor(Advisor advisor) {
        this.advisor = advisor;
    }

    protected String getContainerGuid() {
        return this.containerGuid;
    }

    private void setContainerGuid(String containerGuid) {
        this.containerGuid = containerGuid;
    }
}

