/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.xacml.sunxacml.finder;

import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.security.xacml.sunxacml.EvaluationCtx;
import org.jboss.security.xacml.sunxacml.attr.BagAttribute;
import org.jboss.security.xacml.sunxacml.cond.EvaluationResult;
import org.jboss.security.xacml.sunxacml.finder.AttributeFinderModule;
import org.w3c.dom.Node;

public class AttributeFinder {
    private List allModules = new ArrayList();
    private List designatorModules = new ArrayList();
    private List selectorModules = new ArrayList();
    private static final Logger logger = Logger.getLogger(AttributeFinder.class.getName());

    public List getModules() {
        return new ArrayList(this.allModules);
    }

    public void setModules(List modules) {
        Iterator it = modules.iterator();
        this.allModules = new ArrayList(modules);
        this.designatorModules = new ArrayList();
        this.selectorModules = new ArrayList();
        while (it.hasNext()) {
            AttributeFinderModule module = (AttributeFinderModule)it.next();
            if (module.isDesignatorSupported()) {
                this.designatorModules.add(module);
            }
            if (!module.isSelectorSupported()) continue;
            this.selectorModules.add(module);
        }
    }

    public EvaluationResult findAttribute(URI attributeType, URI attributeId, URI issuer, URI subjectCategory, EvaluationCtx context, int designatorType) {
        for (AttributeFinderModule module : this.designatorModules) {
            Set types = module.getSupportedDesignatorTypes();
            if (types != null && !types.contains(new Integer(designatorType))) continue;
            EvaluationResult result = module.findAttribute(attributeType, attributeId, issuer, subjectCategory, context, designatorType);
            if (result == null) {
                if (logger.isLoggable(Level.WARNING)) {
                    logger.log(Level.WARNING, "Module returned null:" + module.getClass().getCanonicalName() + " for attributeID:" + attributeId);
                }
                result = new EvaluationResult(BagAttribute.createEmptyBag(attributeType));
            }
            if (result == null || result.indeterminate()) {
                if (logger.isLoggable(Level.INFO)) {
                    logger.info("Error while trying to resolve values: " + result.getStatus().getMessage());
                }
                return result;
            }
            BagAttribute bag = (BagAttribute)result.getAttributeValue();
            if (bag.isEmpty()) continue;
            return result;
        }
        if (logger.isLoggable(Level.INFO)) {
            logger.info("Failed to resolve any values for " + attributeId.toString());
        }
        return new EvaluationResult(BagAttribute.createEmptyBag(attributeType));
    }

    public EvaluationResult findAttribute(String contextPath, Node namespaceNode, URI attributeType, EvaluationCtx context, String xpathVersion) {
        for (AttributeFinderModule module : this.selectorModules) {
            EvaluationResult result = module.findAttribute(contextPath, namespaceNode, attributeType, context, xpathVersion);
            if (result.indeterminate()) {
                if (logger.isLoggable(Level.INFO)) {
                    logger.info("Error while trying to resolve values: " + result.getStatus().getMessage());
                }
                return result;
            }
            BagAttribute bag = (BagAttribute)result.getAttributeValue();
            if (bag.isEmpty()) continue;
            return result;
        }
        if (logger.isLoggable(Level.INFO)) {
            logger.info("Failed to resolve any values for " + contextPath);
        }
        return new EvaluationResult(BagAttribute.createEmptyBag(attributeType));
    }
}

