/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.xacml.core.ext;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.jboss.security.xacml.sunxacml.ParsingException;
import org.jboss.security.xacml.sunxacml.UnknownIdentifierException;
import org.jboss.security.xacml.sunxacml.attr.AttributeProxy;
import org.jboss.security.xacml.sunxacml.attr.AttributeValue;
import org.jboss.security.xacml.sunxacml.attr.BaseAttributeFactory;
import org.jboss.security.xacml.sunxacml.attr.proxy.AnyURIAttributeProxy;
import org.jboss.security.xacml.sunxacml.attr.proxy.Base64BinaryAttributeProxy;
import org.jboss.security.xacml.sunxacml.attr.proxy.BooleanAttributeProxy;
import org.jboss.security.xacml.sunxacml.attr.proxy.DNSNameAttributeProxy;
import org.jboss.security.xacml.sunxacml.attr.proxy.DateAttributeProxy;
import org.jboss.security.xacml.sunxacml.attr.proxy.DateTimeAttributeProxy;
import org.jboss.security.xacml.sunxacml.attr.proxy.DayTimeDurationAttributeProxy;
import org.jboss.security.xacml.sunxacml.attr.proxy.DoubleAttributeProxy;
import org.jboss.security.xacml.sunxacml.attr.proxy.HexBinaryAttributeProxy;
import org.jboss.security.xacml.sunxacml.attr.proxy.IPAddressAttributeProxy;
import org.jboss.security.xacml.sunxacml.attr.proxy.IntegerAttributeProxy;
import org.jboss.security.xacml.sunxacml.attr.proxy.RFC822NameAttributeProxy;
import org.jboss.security.xacml.sunxacml.attr.proxy.StringAttributeProxy;
import org.jboss.security.xacml.sunxacml.attr.proxy.TimeAttributeProxy;
import org.jboss.security.xacml.sunxacml.attr.proxy.X500NameAttributeProxy;
import org.jboss.security.xacml.sunxacml.attr.proxy.YearMonthDurationAttributeProxy;
import org.w3c.dom.Node;

public class ExtendedAttributeFactory
extends BaseAttributeFactory {
    private static ExtendedAttributeFactory instance = null;
    private static Map<String, AttributeProxy> supportedDatatypes = new HashMap<String, AttributeProxy>();

    private ExtendedAttributeFactory() {
        super(supportedDatatypes);
        supportedDatatypes.put("http://www.w3.org/2001/XMLSchema#boolean", new BooleanAttributeProxy());
        supportedDatatypes.put("http://www.w3.org/2001/XMLSchema#string", new StringAttributeProxy());
        supportedDatatypes.put("http://www.w3.org/2001/XMLSchema#date", new DateAttributeProxy());
        supportedDatatypes.put("http://www.w3.org/2001/XMLSchema#time", new TimeAttributeProxy());
        supportedDatatypes.put("http://www.w3.org/2001/XMLSchema#dateTime", new DateTimeAttributeProxy());
        supportedDatatypes.put("http://www.w3.org/TR/2002/WD-xquery-operators-20020816#dayTimeDuration", new DayTimeDurationAttributeProxy());
        supportedDatatypes.put("http://www.w3.org/TR/2002/WD-xquery-operators-20020816#yearMonthDuration", new YearMonthDurationAttributeProxy());
        supportedDatatypes.put("http://www.w3.org/2001/XMLSchema#double", new DoubleAttributeProxy());
        supportedDatatypes.put("http://www.w3.org/2001/XMLSchema#integer", new IntegerAttributeProxy());
        supportedDatatypes.put("http://www.w3.org/2001/XMLSchema#anyURI", new AnyURIAttributeProxy());
        supportedDatatypes.put("http://www.w3.org/2001/XMLSchema#hexBinary", new HexBinaryAttributeProxy());
        supportedDatatypes.put("http://www.w3.org/2001/XMLSchema#base64Binary", new Base64BinaryAttributeProxy());
        supportedDatatypes.put("urn:oasis:names:tc:xacml:1.0:data-type:x500Name", new X500NameAttributeProxy());
        supportedDatatypes.put("urn:oasis:names:tc:xacml:1.0:data-type:rfc822Name", new RFC822NameAttributeProxy());
        supportedDatatypes.put("urn:oasis:names:tc:xacml:2.0:data-type:dnsName", new DNSNameAttributeProxy());
        supportedDatatypes.put("urn:oasis:names:tc:xacml:2.0:data-type:ipAddress", new IPAddressAttributeProxy());
    }

    public void addDatatype(String id, AttributeProxy proxy) {
        supportedDatatypes.put(id, proxy);
    }

    public AttributeValue createValue(URI dataType, String value) throws UnknownIdentifierException, ParsingException {
        try {
            return this.getProxy(dataType.toString()).getInstance(value);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public AttributeValue createValue(Node root, String type) throws UnknownIdentifierException, ParsingException {
        try {
            return this.getProxy(type).getInstance(root);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public AttributeValue createValue(Node root, URI dataType) throws UnknownIdentifierException, ParsingException {
        return this.createValue(root, dataType.toString());
    }

    public static ExtendedAttributeFactory getFactory() {
        if (instance == null) {
            instance = new ExtendedAttributeFactory();
        }
        return instance;
    }

    private AttributeProxy getProxy(String type) {
        AttributeProxy proxy = supportedDatatypes.get(type.toString());
        if (proxy == null) {
            throw new RuntimeException("proxy null for " + type);
        }
        return proxy;
    }
}

