/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.common;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.jboss.logging.Logger;
import org.jboss.wsf.spi.deployment.UnifiedVirtualFile;

public class URLLoaderAdapter
implements UnifiedVirtualFile {
    private static final long serialVersionUID = 8263115387770740414L;
    private URL rootURL;
    private URL resourceURL;
    private transient URLClassLoader loader;
    private static Logger log = Logger.getLogger(URLLoaderAdapter.class);
    private static final String jarFileSeparator = "/";

    public URLLoaderAdapter(URL rootURL) {
        this.rootURL = rootURL;
    }

    private URLLoaderAdapter(URL rootURL, URLClassLoader loader, URL resourceURL) {
        this.rootURL = rootURL;
        this.resourceURL = resourceURL;
        this.loader = loader;
    }

    public UnifiedVirtualFile findChild(String resourcePath) throws IOException {
        URL resourceURL = null;
        if (resourcePath != null) {
            try {
                resourceURL = new URL(resourcePath);
            }
            catch (MalformedURLException ex) {
                // empty catch block
            }
            if (resourceURL == null) {
                try {
                    File file = new File(resourcePath);
                    if (file.exists()) {
                        resourceURL = file.toURL();
                    }
                }
                catch (MalformedURLException e) {
                    // empty catch block
                }
            }
            if (resourceURL == null) {
                try {
                    resourceURL = this.getResourceLoader().getResource(resourcePath);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (resourceURL == null) {
            throw new IOException("Cannot get URL for: " + resourcePath);
        }
        return new URLLoaderAdapter(this.rootURL, this.loader, resourceURL);
    }

    public URL toURL() {
        if (this.resourceURL != null) {
            return this.resourceURL;
        }
        return this.rootURL;
    }

    private URLClassLoader getResourceLoader() {
        if (this.loader == null) {
            this.loader = new URLClassLoader(new URL[]{this.rootURL});
        }
        return this.loader;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public List<UnifiedVirtualFile> getChildren() throws IOException {
        LinkedList<UnifiedVirtualFile> list = new LinkedList<UnifiedVirtualFile>();
        URL url = this.toURL();
        if (url.getProtocol().equals("jar")) {
            String path;
            String urlString = url.toExternalForm();
            String jarRoot = urlString.substring(4, urlString.indexOf("ar!") + 2);
            String string = path = urlString.contains("!") ? urlString.substring(urlString.lastIndexOf("!") + 2) : "";
            if (path.endsWith(jarFileSeparator)) {
                path = path.substring(0, path.lastIndexOf(jarFileSeparator));
            }
            try {
                String folder = jarRoot.substring(5, jarRoot.lastIndexOf(jarFileSeparator));
                String filename = jarRoot.substring(jarRoot.lastIndexOf(jarFileSeparator) + 1);
                final File jar = new File(folder, filename);
                PrivilegedAction<JarFile> action = new PrivilegedAction<JarFile>(){

                    @Override
                    public JarFile run() {
                        try {
                            return new JarFile(jar);
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    }
                };
                JarFile jarFile = AccessController.doPrivileged(action);
                if (!jar.canRead()) return list;
                Enumeration<JarEntry> entries = jarFile.entries();
                LinkedList<String> pathMatch = new LinkedList<String>();
                LinkedList<String> finalMatch = new LinkedList<String>();
                while (entries.hasMoreElements()) {
                    JarEntry entry = entries.nextElement();
                    String name = entry.getName();
                    if (!name.startsWith(path + jarFileSeparator) || name.length() <= path.length() + 1 || name.contains("$")) continue;
                    pathMatch.add(name.substring(path.length() + 1));
                }
                for (String s : pathMatch) {
                    if (s.contains(jarFileSeparator) && s.indexOf(jarFileSeparator) != s.length() - 1) continue;
                    finalMatch.add(s);
                }
                for (String s : finalMatch) {
                    URL sUrl = new URL(urlString + jarFileSeparator + s);
                    list.add(new URLLoaderAdapter(this.rootURL, this.loader, sUrl));
                }
                return list;
            }
            catch (Exception e) {
                e.printStackTrace();
                log.error((Object)("Cannot get children for resource: " + url));
                return list;
            }
        }
        try {
            File[] files;
            File file = new File(url.toURI());
            if (!file.exists() || !file.isDirectory() || (files = file.listFiles()) == null) return list;
            for (File f : files) {
                list.add(new URLLoaderAdapter(this.rootURL, this.loader, f.toURL()));
            }
            return list;
        }
        catch (Exception e) {
            log.error((Object)("Cannot get children for resource: " + url), (Throwable)e);
        }
        return list;
    }

    public String getName() {
        String name = null;
        try {
            String filename = this.toURL().getFile();
            File f = new File(filename);
            name = f.getName();
            if (f.isDirectory() || this.toURL().getProtocol().equals("jar") && filename.endsWith(jarFileSeparator)) {
                name = name + jarFileSeparator;
            }
        }
        catch (Exception e) {
            log.error((Object)("Cannot get name for resource: " + this.toURL()), (Throwable)e);
        }
        return name;
    }
}

