/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.bpm;

import java.io.Serializable;
import org.jboss.seam.Component;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.intercept.BypassInterceptors;
import org.jboss.seam.bpm.Actor;
import org.jboss.seam.bpm.ManagedJbpmContext;
import org.jboss.seam.bpm.ProcessInstance;
import org.jboss.seam.bpm.TaskInstance;
import org.jboss.seam.bpm.Transition;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.core.AbstractMutable;
import org.jboss.seam.core.Events;
import org.jboss.seam.international.StatusMessage;
import org.jboss.seam.international.StatusMessages;
import org.jboss.seam.log.LogProvider;
import org.jboss.seam.log.Logging;
import org.jbpm.graph.def.ProcessDefinition;

@Scope(value=ScopeType.CONVERSATION)
@Name(value="org.jboss.seam.bpm.businessProcess")
@BypassInterceptors
@Install(dependencies={"org.jboss.seam.bpm.jbpm"}, precedence=0)
public class BusinessProcess
extends AbstractMutable
implements Serializable {
    private static final LogProvider log = Logging.getLogProvider(BusinessProcess.class);
    private static final long serialVersionUID = 4722350870845851070L;
    private Long processId;
    private Long taskId;

    public static BusinessProcess instance() {
        if (!Contexts.isConversationContextActive()) {
            throw new IllegalStateException("No active conversation context");
        }
        return (BusinessProcess)Component.getInstance(BusinessProcess.class, ScopeType.CONVERSATION);
    }

    public boolean hasCurrentProcess() {
        return this.processId != null;
    }

    public boolean hasActiveProcess() {
        return this.hasCurrentProcess() && !ProcessInstance.instance().hasEnded();
    }

    public boolean hasCurrentTask() {
        return this.taskId != null;
    }

    public Long getProcessId() {
        return this.processId;
    }

    public void setProcessId(Long processId) {
        this.setDirty(this.processId, processId);
        this.processId = processId;
    }

    public Long getTaskId() {
        return this.taskId;
    }

    public void setTaskId(Long taskId) {
        this.setDirty(this.taskId, taskId);
        this.taskId = taskId;
    }

    public void createProcess(String processDefinitionName) {
        this.createProcess(processDefinitionName, true);
    }

    public void createProcess(String processDefinitionName, boolean shouldSignalProcess) {
        org.jbpm.graph.exe.ProcessInstance process = ManagedJbpmContext.instance().newProcessInstanceForUpdate(processDefinitionName);
        this.afterCreateProcess(processDefinitionName, process, shouldSignalProcess);
    }

    public void createProcess(String processDefinitionName, String businessKey) {
        org.jbpm.graph.exe.ProcessInstance process = ManagedJbpmContext.instance().newProcessInstanceForUpdate(processDefinitionName);
        process.setKey(businessKey);
        this.afterCreateProcess(processDefinitionName, process, true);
    }

    private void afterCreateProcess(String processDefinitionName, org.jbpm.graph.exe.ProcessInstance process, boolean shouldSignalProcess) {
        this.setProcessId(process.getId());
        Contexts.getBusinessProcessContext().flush();
        if (shouldSignalProcess) {
            process.signal();
        }
        Events.instance().raiseEvent("org.jboss.seam.createProcess." + processDefinitionName, new Object[0]);
    }

    public void startTask() {
        String actorId = Actor.instance().getId();
        org.jbpm.taskmgmt.exe.TaskInstance task = TaskInstance.instance();
        if (actorId != null) {
            task.start(actorId);
        } else {
            task.start();
        }
        Events.instance().raiseEvent("org.jboss.seam.startTask." + task.getTask().getName(), new Object[0]);
    }

    public void endTask(String transitionName) throws Exception {
        org.jbpm.taskmgmt.exe.TaskInstance task = TaskInstance.instance();
        if (task == null) {
            throw new IllegalStateException("no task instance associated with context");
        }
        if (transitionName == null || "".equals(transitionName)) {
            transitionName = Transition.instance().getName();
        }
        try {
            if (transitionName == null) {
                task.end();
            } else {
                task.end(transitionName);
            }
        }
        catch (Exception e) {
            this.processId = null;
            this.taskId = null;
            throw new RuntimeException(e);
        }
        this.setTaskId(null);
        Events.instance().raiseEvent("org.jboss.seam.endTask." + task.getTask().getName(), new Object[0]);
        org.jbpm.graph.exe.ProcessInstance process = ProcessInstance.instance();
        if (process.hasEnded()) {
            Events.instance().raiseEvent("org.jboss.seam.endProcess." + process.getProcessDefinition().getName(), new Object[0]);
        }
    }

    public void transition(String transitionName) throws Exception {
        org.jbpm.graph.exe.ProcessInstance process = ProcessInstance.instance();
        try {
            process.signal(transitionName);
        }
        catch (Exception e) {
            this.processId = null;
            this.taskId = null;
            throw new RuntimeException(e);
        }
        if (process.hasEnded()) {
            Events.instance().raiseEvent("org.jboss.seam.endProcess." + process.getProcessDefinition().getName(), new Object[0]);
        }
    }

    public boolean resumeTask(Long taskId) throws Exception {
        this.setTaskId(taskId);
        org.jbpm.taskmgmt.exe.TaskInstance task = TaskInstance.instance();
        if (task == null) {
            this.taskNotFound(taskId);
            return false;
        }
        if (task.hasEnded()) {
            this.taskEnded(taskId);
            return false;
        }
        try {
            this.setProcessId(task.getTaskMgmtInstance().getProcessInstance().getId());
        }
        catch (Exception e) {
            this.processId = null;
            this.taskId = null;
            throw new RuntimeException(e);
        }
        Events.instance().raiseEvent("org.jboss.seam.initTask." + task.getTask().getName(), new Object[0]);
        return true;
    }

    public boolean resumeProcess(Long processId) {
        this.setProcessId(processId);
        org.jbpm.graph.exe.ProcessInstance process = ProcessInstance.instance();
        return this.afterResumeProcess(processId, process);
    }

    public boolean resumeProcess(String processDefinition, String key) {
        org.jbpm.graph.exe.ProcessInstance process;
        ProcessDefinition definition = ManagedJbpmContext.instance().getGraphSession().findLatestProcessDefinition(processDefinition);
        org.jbpm.graph.exe.ProcessInstance processInstance = process = definition == null ? null : ManagedJbpmContext.instance().getProcessInstanceForUpdate(definition, key);
        if (process != null) {
            this.setProcessId(process.getId());
        }
        return this.afterResumeProcess(key, process);
    }

    private boolean afterResumeProcess(long processId, org.jbpm.graph.exe.ProcessInstance process) {
        if (process == null) {
            this.processNotFound(processId);
            return false;
        }
        if (process.hasEnded()) {
            this.processEnded(processId);
            return false;
        }
        Events.instance().raiseEvent("org.jboss.seam.initProcess." + process.getProcessDefinition().getName(), new Object[0]);
        return true;
    }

    private boolean afterResumeProcess(String processKey, org.jbpm.graph.exe.ProcessInstance process) {
        if (process == null) {
            this.processNotFound(processKey);
            return false;
        }
        if (process.hasEnded()) {
            this.processEnded(processKey);
            return false;
        }
        Events.instance().raiseEvent("org.jboss.seam.initProcess." + process.getProcessDefinition().getName(), new Object[0]);
        return true;
    }

    public boolean validateTask() {
        if (!this.hasCurrentTask()) {
            this.taskNotFound(this.taskId);
            return false;
        }
        if (TaskInstance.instance().hasEnded()) {
            this.taskEnded(this.taskId);
            return false;
        }
        return true;
    }

    protected void taskNotFound(Long taskId) {
        StatusMessages.instance().addFromResourceBundleOrDefault(StatusMessage.Severity.WARN, "org.jboss.seam.TaskNotFound", "Task #0 not found", taskId);
    }

    protected void taskEnded(Long taskId) {
        StatusMessages.instance().addFromResourceBundleOrDefault(StatusMessage.Severity.WARN, "org.jboss.seam.TaskEnded", "Task #0 already ended", taskId);
    }

    protected void processEnded(Long processId) {
        StatusMessages.instance().addFromResourceBundleOrDefault(StatusMessage.Severity.WARN, "org.jboss.seam.ProcessEnded", "Process #0 already ended", processId);
    }

    protected void processNotFound(Long processId) {
        StatusMessages.instance().addFromResourceBundleOrDefault(StatusMessage.Severity.WARN, "org.jboss.seam.ProcessNotFound", "Process #0 not found", processId);
    }

    protected void processEnded(String key) {
        StatusMessages.instance().addFromResourceBundleOrDefault(StatusMessage.Severity.WARN, "org.jboss.seam.ProcessEnded", "Process #0 already ended", key);
    }

    protected void processNotFound(String key) {
        StatusMessages.instance().addFromResourceBundleOrDefault(StatusMessage.Severity.WARN, "org.jboss.seam.ProcessNotFound", "Process #0 not found", key);
    }

    public String toString() {
        return "BusinessProcess(processId=" + this.processId + ",taskId=" + this.taskId + ")";
    }
}

