/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.types.resources;

import java.util.ConcurrentModificationException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.WeakHashMap;

class FailFast
implements Iterator {
    private static final WeakHashMap MAP = new WeakHashMap();
    private Object parent;
    private Iterator wrapped;

    static synchronized void invalidate(Object o) {
        Set s = (Set)MAP.get(o);
        if (s != null) {
            s.clear();
        }
    }

    private static synchronized void add(FailFast f) {
        HashSet<FailFast> s = (HashSet<FailFast>)MAP.get(f.parent);
        if (s == null) {
            s = new HashSet<FailFast>();
            MAP.put(f.parent, s);
        }
        s.add(f);
    }

    private static synchronized void remove(FailFast f) {
        Set s = (Set)MAP.get(f.parent);
        if (s != null) {
            s.remove(f);
        }
    }

    private static synchronized void failFast(FailFast f) {
        Set s = (Set)MAP.get(f.parent);
        if (!s.contains(f)) {
            throw new ConcurrentModificationException();
        }
    }

    FailFast(Object o, Iterator i) {
        if (o == null) {
            throw new IllegalArgumentException("parent object is null");
        }
        if (i == null) {
            throw new IllegalArgumentException("cannot wrap null iterator");
        }
        this.parent = o;
        if (i.hasNext()) {
            this.wrapped = i;
            FailFast.add(this);
        }
    }

    public boolean hasNext() {
        if (this.wrapped == null) {
            return false;
        }
        FailFast.failFast(this);
        return this.wrapped.hasNext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object next() {
        if (this.wrapped == null || !this.wrapped.hasNext()) {
            throw new NoSuchElementException();
        }
        FailFast.failFast(this);
        try {
            Object e = this.wrapped.next();
            return e;
        }
        finally {
            if (!this.wrapped.hasNext()) {
                this.wrapped = null;
                FailFast.remove(this);
            }
        }
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }
}

