/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.persist.impl;

import com.sleepycat.bind.EntryBinding;
import com.sleepycat.bind.tuple.TupleBase;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.persist.impl.Catalog;
import com.sleepycat.persist.impl.CompositeKeyFormat;
import com.sleepycat.persist.impl.EntityInput;
import com.sleepycat.persist.impl.EntityOutput;
import com.sleepycat.persist.impl.Format;
import com.sleepycat.persist.impl.SimpleCatalog;

public class PersistKeyBinding
implements EntryBinding {
    Catalog catalog;
    Format keyFormat;
    boolean rawAccess;

    public PersistKeyBinding(Catalog catalog, String clsName, boolean rawAccess) {
        this.catalog = catalog;
        this.keyFormat = catalog.getFormat(clsName);
        if (this.keyFormat == null) {
            throw new IllegalArgumentException("Class is not persistent: " + clsName);
        }
        if (!(this.keyFormat.isSimple() || this.keyFormat.getClassMetadata() != null && this.keyFormat.getClassMetadata().getCompositeKeyFields() != null)) {
            throw new IllegalArgumentException("Key class is not a simple type or a composite key class (composite keys must include @KeyField annotations): " + clsName);
        }
        this.rawAccess = rawAccess;
    }

    PersistKeyBinding(Class cls, String[] compositeFieldOrder) {
        this.catalog = SimpleCatalog.getInstance();
        if (compositeFieldOrder != null) {
            assert (!SimpleCatalog.isSimpleType(cls));
            this.keyFormat = new CompositeKeyFormat(cls, null, compositeFieldOrder);
        } else {
            assert (SimpleCatalog.isSimpleType(cls));
            this.keyFormat = this.catalog.getFormat(cls);
        }
        this.keyFormat.initializeIfNeeded(this.catalog);
    }

    Object bytesToObject(byte[] bytes, int offset, int length) {
        return PersistKeyBinding.readKey(this.keyFormat, this.catalog, bytes, offset, length, this.rawAccess);
    }

    static Object readKey(Format keyFormat, Catalog catalog, byte[] bytes, int offset, int length, boolean rawAccess) {
        EntityInput input = new EntityInput(catalog, rawAccess, null, 0, bytes, offset, length);
        return input.readKeyObject(keyFormat);
    }

    @Override
    public Object entryToObject(DatabaseEntry entry) {
        return this.bytesToObject(entry.getData(), entry.getOffset(), entry.getSize());
    }

    @Override
    public void objectToEntry(Object object, DatabaseEntry entry) {
        EntityOutput output = new EntityOutput(this.catalog, this.rawAccess);
        output.writeKeyObject(object, this.keyFormat);
        TupleBase.outputToEntry(output, entry);
    }
}

