/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.tree;

import com.sleepycat.je.dbi.DatabaseId;
import com.sleepycat.je.tree.Key;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class BINReference {
    protected byte[] idKey;
    private long nodeId;
    private DatabaseId databaseId;
    private Set deletedKeys;

    BINReference(long nodeId, DatabaseId databaseId, byte[] idKey) {
        this.nodeId = nodeId;
        this.databaseId = databaseId;
        this.idKey = idKey;
    }

    public long getNodeId() {
        return this.nodeId;
    }

    public DatabaseId getDatabaseId() {
        return this.databaseId;
    }

    public byte[] getKey() {
        return this.idKey;
    }

    public byte[] getData() {
        return null;
    }

    public void addDeletedKey(Key key) {
        if (this.deletedKeys == null) {
            this.deletedKeys = new HashSet();
        }
        this.deletedKeys.add(key);
    }

    public void addDeletedKeys(BINReference other) {
        if (this.deletedKeys == null) {
            this.deletedKeys = new HashSet();
        }
        if (other.deletedKeys != null) {
            this.deletedKeys.addAll(other.deletedKeys);
        }
    }

    public void removeDeletedKey(Key key) {
        if (this.deletedKeys != null) {
            this.deletedKeys.remove(key);
            if (this.deletedKeys.size() == 0) {
                this.deletedKeys = null;
            }
        }
    }

    public boolean hasDeletedKey(Key key) {
        return this.deletedKeys != null && this.deletedKeys.contains(key);
    }

    public boolean deletedKeysExist() {
        return this.deletedKeys != null && this.deletedKeys.size() > 0;
    }

    public Iterator getDeletedKeyIterator() {
        if (this.deletedKeys != null) {
            return this.deletedKeys.iterator();
        }
        return null;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof BINReference)) {
            return false;
        }
        return ((BINReference)obj).nodeId == this.nodeId;
    }

    public int hashCode() {
        return (int)this.nodeId;
    }

    public String toString() {
        return "idKey=" + Key.getNoFormatString(this.idKey) + " nodeId = " + this.nodeId + " db=" + this.databaseId + " deletedKeys=" + this.deletedKeys;
    }
}

