/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.recovery;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.dbi.DatabaseId;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.dbi.INList;
import com.sleepycat.je.dbi.MemoryBudget;
import com.sleepycat.je.recovery.Checkpointer;
import com.sleepycat.je.tree.IN;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;

class DirtyINMap {
    private EnvironmentImpl envImpl;
    private SortedMap dirtyMap;
    private int numEntries;
    private int highestLevelSeen;

    DirtyINMap(EnvironmentImpl envImpl) {
        this.envImpl = envImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void selectDirtyINsForCheckpoint(Set mustSyncSet) throws DatabaseException {
        this.dirtyMap = new TreeMap();
        this.numEntries = 0;
        this.highestLevelSeen = -1;
        INList inMemINs = this.envImpl.getInMemoryINs();
        inMemINs.latchMajor();
        long totalSize = 0L;
        MemoryBudget mb = this.envImpl.getMemoryBudget();
        try {
            Iterator iter = inMemINs.iterator();
            while (iter.hasNext()) {
                Object var9_7;
                IN in;
                block7: {
                    block6: {
                        in = (IN)iter.next();
                        in.latch(false);
                        try {
                            totalSize = mb.accumulateNewUsage(in, totalSize);
                            if (in.getDatabase().isDeferredWrite() && !mustSyncSet.contains(in.getDatabase().getId())) {
                                var9_7 = null;
                                break block6;
                            }
                            this.addDirtyIN(in);
                            break block7;
                        }
                        catch (Throwable throwable) {
                            var9_7 = null;
                            in.releaseLatch();
                            throw throwable;
                        }
                    }
                    in.releaseLatch();
                    continue;
                }
                var9_7 = null;
                in.releaseLatch();
            }
            mb.refreshTreeMemoryUsage(totalSize);
            Object var11_9 = null;
        }
        catch (Throwable throwable) {
            Object var11_10 = null;
            inMemINs.releaseMajorLatchIfHeld();
            throw throwable;
        }
        inMemINs.releaseMajorLatchIfHeld();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void selectDirtyINsForDb(DatabaseImpl dbImpl) throws DatabaseException {
        this.dirtyMap = new TreeMap();
        DatabaseId dbId = dbImpl.getId();
        INList inMemINs = this.envImpl.getInMemoryINs();
        inMemINs.latchMajor();
        try {
            Iterator iter = inMemINs.iterator();
            while (iter.hasNext()) {
                Object var7_6;
                IN in = (IN)iter.next();
                if (!in.getDatabaseId().equals(dbId)) continue;
                in.latch(false);
                try {
                    this.addDirtyIN(in);
                    var7_6 = null;
                }
                catch (Throwable throwable) {
                    var7_6 = null;
                    in.releaseLatch();
                    throw throwable;
                }
                in.releaseLatch();
                {
                }
            }
            Object var9_8 = null;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            inMemINs.releaseMajorLatchIfHeld();
            throw throwable;
        }
        inMemINs.releaseMajorLatchIfHeld();
    }

    int getNumLevels() {
        return this.dirtyMap.size();
    }

    int getHighestLevel() {
        return this.highestLevelSeen;
    }

    void addCostToMemoryBudget() {
        MemoryBudget mb = this.envImpl.getMemoryBudget();
        int cost = this.numEntries * MemoryBudget.CHECKPOINT_REFERENCE_SIZE;
        mb.updateMiscMemoryUsage(cost);
    }

    void removeCostFromMemoryBudget() {
        MemoryBudget mb = this.envImpl.getMemoryBudget();
        int cost = this.numEntries * MemoryBudget.CHECKPOINT_REFERENCE_SIZE;
        mb.updateMiscMemoryUsage(0 - cost);
    }

    void addDirtyIN(IN in) {
        if (in.getDirty()) {
            Set<Checkpointer.CheckpointReference> dirtySet;
            Integer level;
            int levelVal = in.getLevel();
            if (levelVal > this.highestLevelSeen) {
                this.highestLevelSeen = levelVal;
            }
            if (this.dirtyMap.containsKey(level = new Integer(levelVal))) {
                dirtySet = (Set)this.dirtyMap.get(level);
            } else {
                dirtySet = new HashSet();
                this.dirtyMap.put(level, dirtySet);
            }
            dirtySet.add(new Checkpointer.CheckpointReference(in.getDatabase(), in.getNodeId(), in.containsDuplicates(), in.isDbRoot(), in.getMainTreeKey(), in.getDupTreeKey()));
            ++this.numEntries;
        }
    }

    Integer getLowestLevelSet() {
        return (Integer)this.dirtyMap.firstKey();
    }

    Set getSet(Integer level) {
        return (Set)this.dirtyMap.get(level);
    }

    void removeSet(Integer level) {
        this.dirtyMap.remove(level);
    }
}

